/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Tile;
import com.sun.perseus.model.ModelNode;

class RenderingManager {
    protected ModelNode node;
    protected boolean rTileDirty = true;
    protected Tile rTile = new Tile();
    protected Tile lastRenderedTile = null;
    protected Tile lrtCache = new Tile();

    protected RenderingManager(ModelNode node) {
        this.node = node;
    }

    protected Tile getRenderingTile() {
        if (this.rTileDirty) {
            this.node.computeRenderingTile(this.rTile);
            this.rTileDirty = false;
        }
        return this.rTile;
    }

    protected final void dirty() {
        this.rTileDirty = true;
        this.node.modifyingNodeRendering();
    }

    protected Tile getLastRenderedTile() {
        return this.lastRenderedTile;
    }

    protected void clearLastRenderedTile() {
        this.lastRenderedTile = null;
    }

    protected void rendered() {
        if (this.lastRenderedTile == null) {
            this.lastRenderedTile = this.lrtCache;
        }
        this.lastRenderedTile.x = this.rTile.x;
        this.lastRenderedTile.y = this.rTile.y;
        this.lastRenderedTile.maxX = this.rTile.maxX;
        this.lastRenderedTile.maxY = this.rTile.maxY;
    }
}

