/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.builder.ModelBuilder;
import com.sun.perseus.builder.SVGTinyModelFactory;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.model.DefaultImageLoader;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SVG;
import com.sun.perseus.model.SVGImageLoader;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.UpdateAdapter;
import com.sun.perseus.platform.GZIPSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.m2g.ExternalResourceHandler;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableImage;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGElement;

public class SVGImageImpl
extends SVGImage {
    static final int DEFAULT_IMAGE_READ_BUFFER_LENGTH = 64;
    DocumentNode documentNode = null;
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    SVGImageLoader svgImageLoader;
    SVGElement lastElement = null;
    String waitURI = new String();
    boolean isBrokenImage = false;

    public Document getDocument() {
        return this.documentNode;
    }

    private SVGImageImpl(DocumentNode documentNode, ExternalResourceHandler handler) {
        this.documentNode = documentNode;
        if (handler != null) {
            this.svgImageLoader = new SVGImageLoader(this, handler);
            documentNode.setImageLoader(this.svgImageLoader);
        } else {
            documentNode.setImageLoader(new DefaultImageLoader());
        }
    }

    public static SVGImage createEmptyImage(ExternalResourceHandler handler) {
        DocumentNode documentNode = new DocumentNode();
        SVG svg = new SVG(documentNode);
        svg.setWidth(100.0f);
        svg.setHeight(100.0f);
        documentNode.add(svg);
        documentNode.setSize(100, 100);
        SVGImageImpl sii = new SVGImageImpl(documentNode, handler);
        Vector prototypes = SVGTinyModelFactory.getPrototypes(documentNode);
        int n = prototypes.size();
        for (int i = 0; i < n; ++i) {
            documentNode.addPrototype((ElementNode)prototypes.elementAt(i));
        }
        documentNode.initializeTimingEngine();
        documentNode.sample(new Time(0L));
        documentNode.setLoaded(true);
        return sii;
    }

    public void dispatchMouseEvent(String type, int x, int y) throws NullPointerException, IllegalArgumentException, DOMException {
        if (type == null) {
            throw new NullPointerException();
        }
        if (x < 0 || y < 0) {
            throw new IllegalArgumentException();
        }
        if (!type.equals("click")) {
            throw new DOMException(9, "Event type is NOT click.");
        }
        if (x > this.getViewportWidth() || y > this.getViewportHeight()) {
            return;
        }
        float[] pt = new float[]{x, y};
        ModelNode target = this.documentNode.nodeHitAt(pt);
        if (target == null) {
            return;
        }
        this.documentNode.dispatchEvent(this.documentNode.initEngineEvent("DOMActivate", target));
        this.documentNode.dispatchEvent(this.documentNode.initEngineEvent("click", target));
    }

    public void activate() {
        if (this.lastElement == null) {
            return;
        }
        this.documentNode.dispatchEvent(this.documentNode.initEngineEvent("DOMActivate", (ModelNode)this.lastElement));
    }

    public void focusOn(SVGElement element) throws DOMException {
        if (element == null) {
            if (this.lastElement != null) {
                this.documentNode.dispatchEvent(this.documentNode.initEngineEvent("DOMFocusOut", (ModelNode)this.lastElement));
                this.lastElement = null;
            }
            return;
        }
        DocumentNode ownerDocument = ((ModelNode)element).getOwnerDocument();
        if (!ownerDocument.equals(this.documentNode)) {
            throw new DOMException(4, "Invalid element.");
        }
        if (this.lastElement != element) {
            if (this.lastElement != null) {
                this.documentNode.dispatchEvent(this.documentNode.initEngineEvent("DOMFocusOut", (ModelNode)this.lastElement));
            }
            this.documentNode.dispatchEvent(this.documentNode.initEngineEvent("DOMFocusIn", (ModelNode)element));
            this.lastElement = element;
        }
    }

    public void incrementTime(final float seconds) {
        if (this.documentNode.updateQueue == null) {
            this.documentNode.incrementTime(seconds);
        } else if (Thread.currentThread() == this.documentNode.updateQueue.getThread()) {
            this.documentNode.incrementTime(seconds);
            this.documentNode.applyAnimations();
        } else {
            this.documentNode.safeInvokeAndWait(new Runnable(){

                public void run() {
                    SVGImageImpl.this.documentNode.incrementTime(seconds);
                    SVGImageImpl.this.documentNode.applyAnimations();
                }
            });
        }
    }

    public static ScalableImage createImage(InputStream stream, ExternalResourceHandler handler) throws IOException {
        if (stream == null) {
            throw new NullPointerException();
        }
        DocumentNode documentNode = new DocumentNode();
        return SVGImageImpl.loadDocument(documentNode, stream, handler);
    }

    private static ScalableImage loadDocument(DocumentNode documentNode, InputStream is, ExternalResourceHandler handler) throws IOException {
        UpdateAdapter updateAdapter = new UpdateAdapter();
        documentNode.setUpdateListener(updateAdapter);
        SVGImageImpl sii = new SVGImageImpl(documentNode, handler);
        ModelBuilder.loadDocument(is, documentNode);
        if (updateAdapter.hasLoadingFailed()) {
            if (updateAdapter.getLoadingFailedException() != null) {
                throw new IOException(updateAdapter.getLoadingFailedException().getMessage());
            }
            throw new IOException();
        }
        Element root = documentNode.getDocumentElement();
        if (!(root instanceof SVG)) {
            throw new IOException(Messages.formatMessage(Messages.ERROR_NON_SVG_RESOURCE, new String[]{documentNode.getURIBase()}));
        }
        SVG svg = (SVG)((Object)root);
        int width = (int)svg.getWidth();
        int height = (int)svg.getHeight();
        documentNode.setSize(width, height);
        documentNode.initializeTimingEngine();
        documentNode.sample(new Time(0L));
        return sii;
    }

    public static ScalableImage createImage(String URL2, ExternalResourceHandler handler) throws IOException, SecurityException {
        if (URL2 == null) {
            throw new NullPointerException();
        }
        DocumentNode documentNode = new DocumentNode();
        documentNode.setDocumentURI(URL2);
        InputStream is = null;
        try {
            is = GZIPSupport.openHandleGZIP(URL2);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
        return SVGImageImpl.loadDocument(documentNode, is, handler);
    }

    public void setViewportWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        this.documentNode.setSize(width, this.documentNode.getHeight());
    }

    public void setViewportHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException();
        }
        this.documentNode.setSize(this.documentNode.getWidth(), height);
    }

    public int getViewportWidth() {
        return this.documentNode.getWidth();
    }

    public int getViewportHeight() {
        return this.documentNode.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCompleted(String uri, InputStream resourceData) throws IOException {
        System.err.println(">>>>> requestCompleted : " + uri + " / " + resourceData);
        if (uri == null) {
            throw new NullPointerException();
        }
        SVGImageImpl sVGImageImpl = this;
        synchronized (sVGImageImpl) {
            RasterImage img;
            boolean isWaitURI = this.waitURI.equals(uri);
            if (resourceData == null) {
                img = this.svgImageLoader.getBrokenImage();
                this.isBrokenImage = true;
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
                byte[] ib = new byte[64];
                int byteRead = -1;
                int totalByteRead = 0;
                while ((byteRead = resourceData.read(ib, 0, ib.length)) != -1) {
                    bos.write(ib, 0, byteRead);
                    totalByteRead += byteRead;
                }
                img = this.svgImageLoader.loaderUtil.createImage(bos.toByteArray());
            }
            this.svgImageLoader.addToCache(uri, img);
            this.svgImageLoader.setRasterImageConsumerImage(uri, img);
            if (isWaitURI) {
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    synchronized RasterImage waitOnRequestCompleted(String uri) {
        this.waitURI = uri;
        try {
            while (!this.isBrokenImage && this.svgImageLoader.getImageFromCache(uri) == null) {
                ((Object)((Object)this)).wait();
            }
        }
        catch (InterruptedException ie) {
            return this.svgImageLoader.getBrokenImage();
        }
        this.waitURI = new String();
        if (this.isBrokenImage) {
            this.isBrokenImage = false;
            return this.svgImageLoader.getBrokenImage();
        }
        return this.svgImageLoader.getImageFromCache(uri);
    }
}

