/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.ImageLoaderUtil;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.model.DefaultImageLoader;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.RasterImageConsumer;
import com.sun.perseus.model.SVGImageImpl;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.m2g.ExternalResourceHandler;
import javax.microedition.m2g.ScalableImage;

public class SVGImageLoader
extends DefaultImageLoader {
    protected static final String IMAGE_REQUESTED = "Image Requested.";
    protected ExternalResourceHandler handler;
    protected SVGImageImpl svgImage;
    protected Hashtable rasterImageConsumerTable = new Hashtable();
    protected ImageLoaderUtil loaderUtil = new ImageLoaderUtil();
    protected boolean documentLoaded;
    protected Vector pendingNeedsURI = new Vector();

    public SVGImageLoader(SVGImageImpl svgImage, ExternalResourceHandler handler) {
        if (svgImage == null || handler == null) {
            throw new NullPointerException();
        }
        this.svgImage = svgImage;
        this.handler = handler;
    }

    public void needsURI(String absoluteURI) {
        if (this.documentLoaded) {
            this.needsURIDocumentLoaded(absoluteURI);
        } else if (!this.loaderUtil.isDataURI(absoluteURI) && !this.pendingNeedsURI.contains(absoluteURI)) {
            this.pendingNeedsURI.addElement(absoluteURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void needsURIDocumentLoaded(String absoluteURI) {
        if (!this.loaderUtil.isDataURI(absoluteURI)) {
            boolean isRequested = true;
            Hashtable hashtable = this.cache;
            synchronized (hashtable) {
                Object imgObj = this.cache.get(absoluteURI);
                if (null == imgObj) {
                    isRequested = false;
                    this.addToCache(absoluteURI, IMAGE_REQUESTED);
                } else if (IMAGE_REQUESTED != imgObj) {
                    this.setRasterImageConsumerImage(absoluteURI, (RasterImage)imgObj);
                    return;
                }
            }
            if (!isRequested) {
                System.err.println("handler.requestResource: " + absoluteURI);
                this.handler.requestResource((ScalableImage)this.svgImage, absoluteURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterImage getImageAndWait(String uri) {
        Object img;
        if (this.loaderUtil.isDataURI(uri)) {
            return this.loaderUtil.getEmbededImage(uri);
        }
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            img = this.cache.get(uri);
        }
        if (img != null && img != IMAGE_REQUESTED) {
            return (RasterImage)img;
        }
        if (img == null) {
            this.needsURI(uri);
        }
        img = this.svgImage.waitOnRequestCompleted(uri);
        return (RasterImage)img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getImageLater(String uri, RasterImageConsumer rasterImageConsumer) {
        if (this.loaderUtil.isDataURI(uri)) {
            rasterImageConsumer.setImage(this.loaderUtil.getEmbededImage(uri), uri);
            return;
        }
        Object img = null;
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            img = this.cache.get(uri);
        }
        if (img != null && img != IMAGE_REQUESTED) {
            rasterImageConsumer.setImage(img, uri);
            return;
        }
        this.addRasterImageConsumer(uri, rasterImageConsumer);
    }

    public boolean allowsRelativeURI() {
        return true;
    }

    public void documentLoaded(DocumentNode doc) {
        this.documentLoaded = true;
        int n = this.pendingNeedsURI.size();
        for (int i = 0; i < n; ++i) {
            this.needsURIDocumentLoaded((String)this.pendingNeedsURI.elementAt(i));
        }
        this.pendingNeedsURI.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRasterImageConsumer(String absoluteURI, RasterImageConsumer imageNode) {
        if (absoluteURI == null) {
            return;
        }
        Hashtable hashtable = this.rasterImageConsumerTable;
        synchronized (hashtable) {
            Vector<RasterImageConsumer> v = (Vector<RasterImageConsumer>)this.rasterImageConsumerTable.get(absoluteURI);
            if (v == null) {
                v = new Vector<RasterImageConsumer>(1);
                v.addElement(imageNode);
                this.rasterImageConsumerTable.put(absoluteURI, v);
            } else if (!v.contains(imageNode)) {
                v.addElement(imageNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRasterImageConsumer(String absoluteURI, RasterImageConsumer imageNode) {
        if (absoluteURI != null) {
            Hashtable hashtable = this.rasterImageConsumerTable;
            synchronized (hashtable) {
                Vector v = (Vector)this.rasterImageConsumerTable.get(absoluteURI);
                if (v != null) {
                    v.removeElement(imageNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RasterImage getImageFromCache(String uri) {
        Object img;
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            img = this.cache.get(uri);
            if (IMAGE_REQUESTED == img) {
                img = null;
            }
        }
        return (RasterImage)img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCache(String uri, Object image) {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            this.cache.put(uri, image);
        }
    }

    void setRasterImageConsumerImage(final String uri, final RasterImage image) {
        ((DocumentNode)this.svgImage.getDocument()).safeInvokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Hashtable hashtable = SVGImageLoader.this.rasterImageConsumerTable;
                synchronized (hashtable) {
                    Vector v = (Vector)SVGImageLoader.this.rasterImageConsumerTable.get(uri);
                    if (v != null) {
                        int n = v.size();
                        for (int i = 0; i < n; ++i) {
                            RasterImageConsumer in = (RasterImageConsumer)v.elementAt(i);
                            in.setImage(image, uri);
                        }
                    }
                }
            }
        });
    }
}

