/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.Path;
import com.sun.perseus.j2d.PathSupport;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.AbstractShapeNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGPath;

public class ShapeNode
extends AbstractShapeNode {
    static final Path EMPTY_PATH = new Path();
    static final String[] PATH_REQUIRED_TRAITS = new String[]{"d"};
    static final String[] POLY_ALL_REQUIRED_TRAITS = new String[]{"points"};
    protected Path path = EMPTY_PATH;
    protected String localName;

    public ShapeNode(DocumentNode ownerDocument) {
        this(ownerDocument, "path");
        this.canRenderState |= 0x200;
    }

    public ShapeNode(DocumentNode ownerDocument, String localName) {
        super(ownerDocument);
        if ("polyline" != localName && "polygon" != localName && "path" != localName) {
            throw new IllegalArgumentException();
        }
        this.localName = localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new ShapeNode(doc, this.localName);
    }

    public Path getShape() {
        return this.path;
    }

    public void setPath(Path newPath) {
        if (ShapeNode.equal(newPath, this.path)) {
            return;
        }
        this.modifyingNode();
        this.renderingDirty();
        this.path = newPath != null ? newPath : new Path();
        this.computeCanRenderEmptyPathBit(this.path);
        this.modifiedNode();
    }

    public void fillShape(RenderGraphics rg) {
        rg.fill(this.path);
    }

    public void drawShape(RenderGraphics rg) {
        rg.draw(this.path);
    }

    public boolean contains(float x, float y, int fillRule) {
        return PathSupport.isHit(this.path, fillRule, x, y);
    }

    Object getStrokedPath(GraphicsProperties gp) {
        return PathSupport.getStrokedPath(this.path, gp);
    }

    boolean supportsTrait(String traitName) {
        if ("path" == this.localName ? "d" == traitName : "points" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        if ("path" == this.localName) {
            return PATH_REQUIRED_TRAITS;
        }
        return POLY_ALL_REQUIRED_TRAITS;
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("path" == this.localName) {
            if ("d" == name) {
                return this.path.toString();
            }
        } else if ("points" == name) {
            return this.path.toPointsString();
        }
        return super.getTraitImpl(name);
    }

    SVGPath getPathTraitImpl(String name) throws DOMException {
        if ("path".equals(this.localName) && "d".equals(name)) {
            return new Path(this.path);
        }
        return super.getPathTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("d" == traitName || "points" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGPath");
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("d" == name || "points" == name) {
            if (!this.path.equals(value)) {
                this.modifyingNode();
                this.renderingDirty();
                this.path.setData(value[0]);
                this.modifiedNode();
            }
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("d" == traitName) {
            Path path = this.parsePathTrait(traitName, value);
            return this.toAnimatedFloatArray(path);
        }
        if ("points" == traitName) {
            Path path = this.parsePointsTrait(traitName, value);
            if ("polygon" == this.localName) {
                path.close();
            }
            return this.toAnimatedFloatArray(path);
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("path" == this.localName) {
            if ("d" == name) {
                this.setPath(this.parsePathTrait(name, value));
            } else {
                super.setTraitImpl(name, value);
            }
        } else if ("points" == name) {
            this.setPath(this.parsePointsTrait(name, value));
            if (this.ownerDocument.getDelayedException() == null && "polygon" == this.localName) {
                this.path.close();
            }
        } else {
            super.setTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("path".equals(this.localName) && "d".equals(name)) {
            return this.path.toString(value[0]);
        }
        if ("points".equals(name)) {
            return this.path.toPointsString(value[0]);
        }
        return super.toStringTrait(name, value);
    }

    void setPathTraitImpl(String name, SVGPath path) throws DOMException {
        if ("path".equals(this.localName) && "d".equals(name)) {
            if (path.getNumberOfSegments() > 0 && path.getSegment(0) != 77) {
                throw this.illegalTraitValue(name, path.toString());
            }
            this.setPath(new Path((Path)path));
        } else {
            super.setPathTraitImpl(name, path);
        }
    }

    Box addNodeBBox(Box bbox, Transform t) {
        return ShapeNode.addShapeBBox(bbox, this.path, t);
    }
}

