/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.model.CanvasUpdateListener;
import com.sun.perseus.model.DirtyAreaManager;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.UpdateListener;
import com.sun.perseus.util.RunnableQueue;
import java.io.InputStream;

public class SimpleCanvasManager
implements UpdateListener,
RunnableQueue.RunnableHandler {
    public final Object lock = new Object();
    protected boolean canvasConsumed = true;
    protected RenderGraphics rg;
    protected DocumentNode documentNode;
    protected CanvasUpdateListener canvasUpdateListener;
    protected boolean needRepaint;
    protected RGB clearPaint = RGB.white;
    protected DirtyAreaManager dirtyAreaManager;
    protected boolean isOff = false;

    public SimpleCanvasManager(RenderGraphics rg, DocumentNode documentNode, CanvasUpdateListener canvasUpdateListener) {
        if (rg == null || documentNode == null || canvasUpdateListener == null) {
            throw new IllegalArgumentException("RenderGraphics : " + rg + " DocumentNode : " + documentNode + " CanvasUpdateListener : " + canvasUpdateListener);
        }
        this.rg = rg;
        this.documentNode = documentNode;
        this.canvasUpdateListener = canvasUpdateListener;
        this.documentNode.setUpdateListener(this);
        this.dirtyAreaManager = new DirtyAreaManager(documentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderGraphics(RenderGraphics rg) {
        if (rg == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.rg = rg;
            this.needRepaint = true;
            this.canvasConsumed = false;
        }
    }

    public RenderGraphics getRenderGraphics() {
        return this.rg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume() {
        Object object = this.lock;
        synchronized (object) {
            this.canvasConsumed = true;
            this.lock.notifyAll();
        }
    }

    public void nodeInserted(ModelNode node) {
        if (DirtyAreaManager.ON) {
            this.dirtyAreaManager.nodeInserted(node);
        }
        this.needRepaint = true;
    }

    public void modifyingNode(ModelNode node) {
        if ((node.hasNodeRendering() || node.hasDescendants()) && node.canRenderState == 0) {
            this.needRepaint = true;
        }
    }

    public void modifyingNodeRendering(ModelNode node) {
        if (DirtyAreaManager.ON) {
            this.dirtyAreaManager.modifyingNodeRendering(node);
        }
    }

    public void modifiedNode(ModelNode node) {
        if (!this.needRepaint && (node.hasNodeRendering() || node.hasDescendants())) {
            this.needRepaint = true;
        }
    }

    public void loadComplete(ModelNode node) {
    }

    public void loadingFailed(DocumentNode documentNode, Exception error) {
    }

    public void loadStarting(DocumentNode documentNode, InputStream is) {
    }

    public void loadBegun(ModelNode node) {
    }

    public void textInserted(ModelNode node) {
    }

    public void updateCanvas() {
        if (this.needRepaint) {
            if (this.canvasConsumed) {
                this.fullPaint();
                this.needRepaint = false;
            } else if (this.documentNode.getUpdateQueue().getSize() == 0) {
                this.documentNode.getUpdateQueue().preemptLater(new Runnable(){

                    public void run() {
                    }
                }, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullPaint() {
        Object object = this.lock;
        synchronized (object) {
            if (DirtyAreaManager.ON) {
                this.dirtyAreaManager.refresh(this.documentNode, this.rg, this.clearPaint);
            } else {
                this.rg.setRenderingTile(null);
                this.rg.setFill(this.clearPaint);
                this.rg.setTransform(null);
                this.rg.setFillOpacity(1.0f);
                this.rg.fillRect(0.0f, 0.0f, this.documentNode.getWidth(), this.documentNode.getHeight(), 0.0f, 0.0f);
                this.documentNode.paint(this.rg);
            }
            this.canvasConsumed = false;
        }
        this.canvasUpdateListener.updateComplete(this);
    }

    public void setClearPaint(RGB clearPaint) {
        if (clearPaint == null) {
            throw new NullPointerException();
        }
        this.clearPaint = clearPaint;
        this.needRepaint = true;
    }

    public void turnOff() {
        this.isOff = true;
    }

    public void turnOn() {
        this.isOff = false;
    }

    public boolean isOff() {
        return this.isOff;
    }

    public void runnableInvoked(RunnableQueue rq, Runnable r) {
        if (!this.isOff) {
            this.updateCanvas();
        }
    }
}

