/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.RGB;
import com.sun.perseus.model.CompositeGraphicsNode;
import com.sun.perseus.model.CompositeGraphicsNodeProxy;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.GradientElement;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGRGBColor;

public class Stop
extends CompositeGraphicsNode {
    static final String[] REQUIRED_TRAITS = new String[]{"offset"};
    static final RGB DEFAULT_STOP_COLOR = RGB.black;
    static final float DEFAULT_STOP_OPACITY = 1.0f;
    RGB stopColor = DEFAULT_STOP_COLOR;
    float stopOpacity = 1.0f;
    float offset;

    public Stop(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    ElementNodeProxy buildProxy() {
        return new CompositeGraphicsNodeProxy(this);
    }

    public String getLocalName() {
        return "stop";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new Stop(doc);
    }

    public void setStopColor(RGB newStopColor) {
        if (this.stopColor.equals(newStopColor)) {
            return;
        }
        this.stopColor = newStopColor;
        this.updateGradient();
    }

    public RGB getStopColor() {
        return this.stopColor;
    }

    public void setStopOpacity(float newStopOpacity) {
        if (newStopOpacity == this.stopOpacity) {
            return;
        }
        this.stopOpacity = newStopOpacity;
        this.updateGradient();
    }

    public float getStopOpacity() {
        return this.stopOpacity;
    }

    public void setOffset(float newOffset) {
        if (newOffset == this.offset) {
            return;
        }
        this.offset = newOffset;
        this.updateGradient();
    }

    public float getOffset() {
        return this.offset;
    }

    void updateGradient() {
        if (this.parent != null && this.parent instanceof GradientElement) {
            ((GradientElement)this.parent).onPaintChange();
        }
    }

    public int getNumberOfProperties() {
        return 14;
    }

    boolean supportsTrait(String traitName) {
        if ("stop-color" == traitName || "stop-opacity" == traitName || "offset" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        return REQUIRED_TRAITS;
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("stop-opacity" == traitName || "offset" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("stop-color" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRGBColor");
        }
        return super.createTraitAnimImpl(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("stop-color" == name) {
            return this.stopColor.toString();
        }
        if ("stop-opacity" == name) {
            return Float.toString(this.stopOpacity);
        }
        if ("offset" == name) {
            return Float.toString(this.offset);
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("stop-opacity" == name) {
            return this.stopOpacity;
        }
        if ("offset" == name) {
            return this.offset;
        }
        return super.getFloatTraitImpl(name);
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        if ("stop-color".equals(name)) {
            return this.stopColor;
        }
        return super.getRGBColorTraitImpl(name);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("stop-color" == name) {
            this.setStopColor(this.toRGB(name, value));
        } else if ("stop-opacity" == name) {
            if (value[0][0] < 0.0f || value[0][0] > 1.0f) {
                throw this.illegalTraitValue(name, Float.toString(value[0][0]));
            }
            this.setStopOpacity(value[0][0]);
        } else if ("offset" == name) {
            this.setOffset(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("stop-color" == traitName) {
            RGB color = this.parseColorTrait("color", value);
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("stop-opacity" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        if ("offset" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("stop-opacity" == name) {
            if ("inherit".equals(value)) {
                this.setStopOpacity(1.0f);
            } else {
                this.setStopOpacity(this.parsePositiveFloatTrait(name, value));
            }
        } else if ("stop-color".equals(name)) {
            if ("inherit".equals(value)) {
                this.setStopColor(DEFAULT_STOP_COLOR);
            } else if ("currentColor".equals(value)) {
                this.setStopColor(this.getColor());
            } else {
                this.setStopColor(this.parseColorTrait("stop-color", value));
            }
        } else if ("offset" == name) {
            this.setOffset(this.parseFloatTrait(name, value));
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("stop-opacity" == name) {
            this.setStopOpacity(value);
        } else if ("offset" == name) {
            this.setOffset(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("stop-opacity" == name || "offset" == name) {
            return Float.toString(value[0][0]);
        }
        if ("stop-color" == name) {
            return this.toRGBString(name, value);
        }
        return super.toStringTrait(name, value);
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        try {
            if ("stop-color".equals(name)) {
                this.setStopColor((RGB)color);
            } else {
                super.setRGBColorTraitImpl(name, color);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }
}

