/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.TextRenderingProperties;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.CompositeGraphicsNode;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNodeProxy;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.StructureNodeProxy;
import com.sun.perseus.model.TextNode;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGRect;

public abstract class StructureNode
extends CompositeGraphicsNode
implements TextNode,
TextRenderingProperties {
    public static final int FONT_WEIGHT_BOLDER_MARKER = 0x800000;
    public static final int FONT_WEIGHT_LIGHTER_MARKER = 0x1000000;
    public static final int ALIGN_NONE = 0;
    public static final int ALIGN_XMIDYMID = 1;
    protected String[] fontFamily = INITIAL_FONT_FAMILY;
    protected float fontSize = 10.0f;

    public StructureNode(DocumentNode ownerDocument) {
        super(ownerDocument);
    }

    Box addBBox(Box bbox, Transform t) {
        ModelNode c = this.getFirstChildNode();
        while (c != null) {
            if (c.contributeBBox()) {
                bbox = c.addBBox(bbox, c.appendTransform(t, null));
            }
            c = c.nextSibling;
        }
        return bbox;
    }

    public SVGRect getBBox() {
        return this.addBBox(null, null);
    }

    public SVGRect getScreenBBox() {
        if (!this.inDocumentTree()) {
            return null;
        }
        return this.addBBox(null, this.txf);
    }

    public ModelNode nodeHitAt(float[] pt) {
        if (this.canRenderState != 0) {
            return null;
        }
        return this.nodeHitAt(this.getLastChildNode(), pt);
    }

    ModelNode proxyNodeHitAt(float[] pt, ElementNodeProxy proxy) {
        if (this.canRenderState != 0) {
            return null;
        }
        return this.nodeHitAt(proxy.getLastExpandedChild(), pt);
    }

    public int getNumberOfProperties() {
        return 19;
    }

    void recomputeInheritedProperties() {
        super.recomputeInheritedProperties();
        ModelNode p = this.ownerDocument;
        if (this.parent != null) {
            p = this.parent;
        }
        this.recomputePropertyState(65536, p.getPropertyState(65536));
        this.recomputeFloatPropertyState(131072, p.getFloatPropertyState(131072));
        this.recomputePackedPropertyState(262144, p.getPackedPropertyState(262144));
        this.recomputePackedPropertyState(524288, p.getPackedPropertyState(524288));
        this.recomputePackedPropertyState(0x100000, p.getPackedPropertyState(0x100000));
    }

    protected void recomputePackedPropertyState(int propertyIndex, int parentPropertyValue) {
        if (propertyIndex != 524288) {
            super.recomputePackedPropertyState(propertyIndex, parentPropertyValue);
        } else {
            boolean isBolder = this.isMarkerSet(0x800000);
            boolean isLighter = this.isMarkerSet(0x1000000);
            if (!this.isInherited(propertyIndex) && !isBolder && !isLighter || this.isPackedPropertyState(propertyIndex, parentPropertyValue)) {
                return;
            }
            int packedFontWeight = parentPropertyValue;
            if (isBolder) {
                packedFontWeight = this.computeFontWeight(parentPropertyValue, 512);
            } else if (isLighter) {
                packedFontWeight = this.computeFontWeight(parentPropertyValue, 1024);
            }
            this.setPackedPropertyState(propertyIndex, packedFontWeight);
            this.propagatePackedPropertyState(propertyIndex, parentPropertyValue);
        }
    }

    protected Object getPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 65536: {
                return this.fontFamily;
            }
        }
        return super.getPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 131072: {
                return this.fontSize;
            }
        }
        return super.getFloatPropertyState(propertyIndex);
    }

    protected int getPackedPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 262144: {
                return this.pack & 0x60000000;
            }
            case 524288: {
                return this.pack & 0x1E000000;
            }
            case 0x100000: {
                return this.pack & 0x1800000;
            }
        }
        return super.getPackedPropertyState(propertyIndex);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 65536: {
                this.setComputedFontFamily((String[])propertyValue);
                break;
            }
            default: {
                super.setPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 131072: {
                this.setComputedFontSize(propertyValue);
                break;
            }
            default: {
                super.setFloatPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setPackedPropertyState(int propertyIndex, int propertyValue) {
        block0 : switch (propertyIndex) {
            case 262144: {
                switch (propertyValue) {
                    case 0: {
                        this.setComputedFontStyle(1);
                        break block0;
                    }
                    case 0x40000000: {
                        this.setComputedFontStyle(4);
                        break block0;
                    }
                }
                this.setComputedFontStyle(2);
                break;
            }
            case 524288: {
                this.setComputedFontWeight(propertyValue);
                break;
            }
            case 0x100000: {
                switch (propertyValue) {
                    case 0x800000: {
                        this.setComputedTextAnchor(0);
                        break block0;
                    }
                    case 0: {
                        this.setComputedTextAnchor(1);
                        break block0;
                    }
                }
                this.setComputedTextAnchor(2);
                break;
            }
            default: {
                super.setPackedPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 65536: {
                return this.fontFamily == propertyValue;
            }
        }
        return super.isPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 131072: {
                return this.fontSize == propertyValue;
            }
        }
        return super.isFloatPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isPackedPropertyState(int propertyIndex, int propertyValue) {
        switch (propertyIndex) {
            case 262144: {
                return propertyValue == (this.pack & 0x60000000);
            }
            case 524288: {
                return propertyValue == (this.pack & 0x1E000000);
            }
            case 0x100000: {
                return propertyValue == (this.pack & 0x1800000);
            }
        }
        return super.isPackedPropertyState(propertyIndex, propertyValue);
    }

    public String[] getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String[] newFontFamily) {
        if (!this.isInherited(65536) && StructureNode.equal(newFontFamily, this.fontFamily)) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(65536, false);
        this.setComputedFontFamily(newFontFamily);
        this.propagatePropertyState(65536, newFontFamily);
        this.modifiedNode();
    }

    void setComputedFontFamily(String[] newFontFamily) {
        this.fontFamily = newFontFamily;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float newFontSize) {
        if (newFontSize < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (!this.isInherited(131072) && newFontSize == this.fontSize) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(131072, false);
        this.setComputedFontSize(newFontSize);
        this.propagateFloatPropertyState(131072, newFontSize);
        this.modifiedNode();
    }

    void setComputedFontSize(float newFontSize) {
        this.fontSize = newFontSize;
    }

    public int getFontStyle() {
        switch (this.pack & 0x60000000) {
            case 0: {
                return 1;
            }
            case 0x40000000: {
                return 4;
            }
        }
        return 2;
    }

    public void setFontStyle(int newFontStyle) {
        if (!this.isInherited(262144) && newFontStyle == this.getFontStyle()) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(262144, false);
        this.setComputedFontStyle(newFontStyle);
        this.propagatePackedPropertyState(262144, this.pack & 0x60000000);
        this.modifiedNode();
    }

    void setComputedFontStyle(int newFontStyle) {
        this.pack &= 0x9FFFFFFF;
        switch (newFontStyle) {
            case 1: {
                this.pack |= 0;
                break;
            }
            case 4: {
                this.pack |= 0x40000000;
                break;
            }
            default: {
                this.pack |= 0x60000000;
            }
        }
    }

    public int getFontWeight() {
        switch (this.pack & 0x1E000000) {
            case 0: {
                return 1;
            }
            case 0x2000000: {
                return 2;
            }
            case 0x4000000: {
                return 4;
            }
            case 0x6000000: {
                return 8;
            }
            case 0x8000000: {
                return 16;
            }
            case 0xA000000: {
                return 32;
            }
            case 0xC000000: {
                return 64;
            }
            case 0xE000000: {
                return 128;
            }
            case 0x10000000: {
                return 256;
            }
            case 0x12000000: {
                return 1024;
            }
        }
        return 512;
    }

    public void setFontWeight(int newFontWeight) {
        if (!this.isInherited(524288) && newFontWeight == this.getFontWeight()) {
            return;
        }
        this.modifyingNode();
        this.setInheritedQuiet(524288, false);
        int packedParentFontWeight = this.getInheritedPackedPropertyState(524288);
        this.setComputedFontWeight(this.computeFontWeight(packedParentFontWeight, newFontWeight));
        this.propagatePackedPropertyState(524288, this.pack & 0x1E000000);
        this.modifiedNode();
    }

    void setComputedFontWeight(int newFontWeight) {
        this.pack &= 0xE1FFFFFF;
        this.pack |= newFontWeight;
    }

    public int getTextAnchor() {
        switch (this.pack & 0x1800000) {
            case 0x800000: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return 2;
    }

    public void setTextAnchor(int newTextAnchor) {
        if (!this.isInherited(0x100000) && newTextAnchor == this.getTextAnchor()) {
            return;
        }
        this.modifyingNode();
        this.setComputedTextAnchor(newTextAnchor);
        this.setInheritedQuiet(0x100000, false);
        this.propagatePackedPropertyState(0x100000, this.pack & 0x1800000);
        this.modifiedNode();
    }

    void setComputedTextAnchor(int newTextAnchor) {
        this.pack &= 0xFE7FFFFF;
        switch (newTextAnchor) {
            case 0: {
                this.pack |= 0x800000;
                break;
            }
            case 1: {
                this.pack |= 0;
                break;
            }
            default: {
                this.pack |= 0x1000000;
            }
        }
    }

    int computeFontWeight(int refPackedFontWeight, int relFontWeight) {
        if (relFontWeight == 512) {
            this.setMarker(0x800000);
            this.clearMarker(0x1000000);
            switch (refPackedFontWeight) {
                case 0: {
                    return 0x6000000;
                }
                case 0x2000000: {
                    return 0x8000000;
                }
                case 0x4000000: {
                    return 0xA000000;
                }
                case 0x6000000: {
                    return 0xC000000;
                }
                case 0x8000000: {
                    return 0xE000000;
                }
            }
            return 0x10000000;
        }
        if (relFontWeight == 1024) {
            this.setMarker(0x1000000);
            this.clearMarker(0x800000);
            switch (refPackedFontWeight) {
                default: {
                    return 0;
                }
                case 0x8000000: {
                    return 0x2000000;
                }
                case 0xA000000: {
                    return 0x4000000;
                }
                case 0xC000000: {
                    return 0x6000000;
                }
                case 0xE000000: {
                    return 0x8000000;
                }
                case 0x10000000: 
            }
            return 0xA000000;
        }
        this.clearMarker(0x800000);
        this.clearMarker(0x1000000);
        switch (relFontWeight) {
            default: {
                return 0;
            }
            case 2: {
                return 0x2000000;
            }
            case 4: {
                return 0x4000000;
            }
            case 8: {
                return 0x6000000;
            }
            case 16: {
                return 0x8000000;
            }
            case 32: {
                return 0xA000000;
            }
            case 64: {
                return 0xC000000;
            }
            case 128: {
                return 0xE000000;
            }
            case 256: 
        }
        return 0x10000000;
    }

    public static void getFittingTransform(float ix, float iy, float iw, float ih, float ox, float oy, float ow, float oh, int align, Transform result) {
        float inAR = iw / ih;
        float outAR = ow / oh;
        result.mTranslate(ox, oy);
        if (align == 0) {
            result.mScale(ow / iw, oh / ih);
            result.mTranslate(-ix, -iy);
        } else if (inAR < outAR) {
            float sf = oh / ih;
            result.mScale(sf);
            result.mTranslate(-ix - (iw - ow * ih / oh) / 2.0f, -iy);
        } else {
            float sf = ow / iw;
            result.mScale(sf);
            result.mTranslate(-ix, -iy - (ih - oh * iw / ow) / 2.0f);
        }
    }

    ElementNodeProxy buildProxy() {
        return new StructureNodeProxy(this);
    }

    public void paint(RenderGraphics rg) {
        if (this.canRenderState != 0) {
            return;
        }
        StructureNode.paint(this.getFirstChildNode(), rg);
    }

    boolean supportsTrait(String traitName) {
        if ("font-family" == traitName || "font-size" == traitName || "font-style" == traitName || "font-weight" == traitName || "text-anchor" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    String getSpecifiedTraitImpl(String name) throws DOMException {
        if ("font-family" == name && this.isInherited(65536) || "font-size" == name && this.isInherited(131072) || "font-style" == name && this.isInherited(262144) || "font-weight" == name && this.isInherited(524288) || "text-anchor" == name && this.isInherited(0x100000)) {
            return "inherit";
        }
        return super.getSpecifiedTraitImpl(name);
    }

    String fontWeightToStringTrait(int fontWeight) {
        switch (fontWeight) {
            case 0: {
                return "100";
            }
            case 0x2000000: {
                return "200";
            }
            case 0x4000000: {
                return "300";
            }
            case 0x6000000: {
                return "400";
            }
            case 0x8000000: {
                return "500";
            }
            case 0xA000000: {
                return "600";
            }
            case 0xC000000: {
                return "700";
            }
            case 0xE000000: {
                return "800";
            }
        }
        return "900";
    }

    String textAnchorToStringTrait(int textAnchor) {
        switch (textAnchor) {
            case 0x800000: {
                return "start";
            }
            case 0: {
                return "middle";
            }
            case 0x1000000: {
                return "end";
            }
        }
        throw new Error();
    }

    String fontStyleToStringTrait(int fontStyle) {
        switch (fontStyle) {
            case 0: {
                return "normal";
            }
            case 0x60000000: {
                return "oblique";
            }
        }
        return "italic";
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("font-family" == name) {
            return this.toStringTraitQuote(this.getFontFamily());
        }
        if ("font-size" == name) {
            return Float.toString(this.getFontSize());
        }
        if ("font-style" == name) {
            return this.fontStyleToStringTrait(this.pack & 0x60000000);
        }
        if ("font-weight" == name) {
            return this.fontWeightToStringTrait(this.pack & 0x1E000000);
        }
        if ("text-anchor" == name) {
            return this.textAnchorToStringTrait(this.pack & 0x1800000);
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("font-size" == name) {
            return this.getFontSize();
        }
        return super.getFloatTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("font-size" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("font-family" == traitName || "font-style" == traitName || "font-weight" == traitName || "text-anchor" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("font-size" == name) {
            this.checkPositive(name, value[0][0]);
            this.setFontSize(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("font-size" == traitName) {
            return new float[][]{{this.parsePositiveFloatTrait(traitName, value)}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null && namespaceURI != "#!null/ns@!") {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("font-size" == traitName) {
            throw this.unsupportedTraitType(traitName, "float");
        }
        if ("font-family" == traitName) {
            if ("inherit".equals(value)) {
                return this.toStringTraitQuote((String[])this.getInheritedPropertyState(65536));
            }
            return value;
        }
        if ("font-style" == traitName) {
            if ("inherit".equals(value)) {
                return this.fontStyleToStringTrait(this.getInheritedPackedPropertyState(262144));
            }
            if (!("normal".equals(value) || "italic".equals(value) || "oblique".equals(value))) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        if ("font-weight" == traitName) {
            if ("inherit".equals(value)) {
                return this.fontWeightToStringTrait(this.getInheritedPackedPropertyState(524288));
            }
            if ("normal".equals(value)) {
                return "400";
            }
            if ("bold".equals(value)) {
                return "700";
            }
            if ("bolder".equals(value)) {
                int packedFontWeight = this.getInheritedPackedPropertyState(524288);
                int fontWeight = this.computeFontWeight(packedFontWeight, 512);
                return this.fontWeightToStringTrait(fontWeight);
            }
            if ("lighter".equals(value)) {
                int packedFontWeight = this.getInheritedPackedPropertyState(524288);
                int fontWeight = this.computeFontWeight(packedFontWeight, 1024);
                return this.fontWeightToStringTrait(fontWeight);
            }
            if (!("100".equals(value) || "200".equals(value) || "300".equals(value) || "400".equals(value) || "normal".equals(value) || "500".equals(value) || "600".equals(value) || "700".equals(value) || "800".equals(value) || "900".equals(value))) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        if ("text-anchor" == traitName) {
            if ("inherit".equals(value)) {
                return this.textAnchorToStringTrait(this.getInheritedPackedPropertyState(0x100000));
            }
            if (!("start".equals(value) || "middle".equals(value) || "end".equals(value))) {
                throw this.illegalTraitValue(traitName, value);
            }
            return value;
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("font-family" == name) {
            if ("inherit".equals(value)) {
                this.setInherited(65536, true);
                return;
            } else {
                this.setFontFamily(this.parseFontFamilyTrait(name, value));
            }
            return;
        } else if ("font-size" == name) {
            if ("inherit".equals(value)) {
                this.setFloatInherited(131072, true);
                return;
            } else {
                this.setFontSize(this.parsePositiveFloatTrait(name, value));
            }
            return;
        } else if ("font-style" == name) {
            if ("normal".equals(value)) {
                this.setFontStyle(1);
                return;
            } else if ("italic".equals(value)) {
                this.setFontStyle(4);
                return;
            } else if ("oblique".equals(value)) {
                this.setFontStyle(2);
                return;
            } else {
                if (!"inherit".equals(value)) throw this.illegalTraitValue(name, value);
                this.setPackedInherited(262144, true);
            }
            return;
        } else if ("font-weight" == name) {
            if ("100".equals(value)) {
                this.setFontWeight(1);
                return;
            } else if ("200".equals(value)) {
                this.setFontWeight(2);
                return;
            } else if ("300".equals(value)) {
                this.setFontWeight(4);
                return;
            } else if ("400".equals(value)) {
                this.setFontWeight(8);
                return;
            } else if ("normal".equals(value)) {
                this.setFontWeight(8);
                return;
            } else if ("500".equals(value)) {
                this.setFontWeight(16);
                return;
            } else if ("600".equals(value)) {
                this.setFontWeight(32);
                return;
            } else if ("700".equals(value)) {
                this.setFontWeight(64);
                return;
            } else if ("bold".equals(value)) {
                this.setFontWeight(64);
                return;
            } else if ("800".equals(value)) {
                this.setFontWeight(128);
                return;
            } else if ("900".equals(value)) {
                this.setFontWeight(256);
                return;
            } else if ("bolder".equals(value)) {
                this.setFontWeight(512);
                return;
            } else if ("lighter".equals(value)) {
                this.setFontWeight(1024);
                return;
            } else {
                if (!"inherit".equals(value)) throw this.illegalTraitValue(name, value);
                this.setPackedInherited(524288, true);
                this.clearMarker(0x800000);
                this.clearMarker(0x1000000);
            }
            return;
        } else if ("text-anchor" == name) {
            if ("start".equals(value)) {
                this.setTextAnchor(0);
                return;
            } else if ("middle".equals(value)) {
                this.setTextAnchor(1);
                return;
            } else if ("end".equals(value)) {
                this.setTextAnchor(2);
                return;
            } else {
                if (!"inherit".equals(value)) throw this.illegalTraitValue(name, value);
                this.setPackedInherited(0x100000, true);
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("font-size" == name) {
            return Float.toString(value[0][0]);
        }
        return super.toStringTrait(name, value);
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("font-size" == name) {
            this.checkPositive(name, value);
            this.setFontSize(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }
}

