/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Box;
import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Tile;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.DirtyAreaManager;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.GlyphLayout;
import com.sun.perseus.model.RenderingManager;
import com.sun.perseus.model.StructureNodeProxy;
import com.sun.perseus.model.Text;
import org.w3c.dom.svg.SVGRect;

public class TextProxy
extends StructureNodeProxy {
    protected RenderingManager renderingManager;
    protected GlyphLayout firstChunk;
    protected GlyphLayout lastChunk;

    public TextProxy(Text proxiedText) {
        super(proxiedText);
        if (DirtyAreaManager.ON) {
            this.renderingManager = new RenderingManager(this);
        }
    }

    public SVGRect getBBox() {
        return this.addNodeBBox(null, null);
    }

    Box addNodeBBox(Box bbox, Transform t) {
        this.checkLayout();
        return ((Text)this.proxied).addNodeBBox(bbox, t, this.firstChunk);
    }

    final void renderingDirty() {
        if (DirtyAreaManager.ON) {
            this.renderingManager.dirty();
        }
    }

    public boolean hasNodeRendering() {
        return true;
    }

    public void paint(RenderGraphics rg) {
        this.checkLayout();
        if (this.canRenderState != 0) {
            return;
        }
        if (DirtyAreaManager.ON) {
            Tile primitiveTile = this.getRenderingTile();
            if (primitiveTile == null || rg.getRenderingTile().isHit(primitiveTile)) {
                ((Text)this.proxied).paintRendered(rg, this, this.txf, this.firstChunk);
                this.nodeRendered();
            }
        } else {
            ((Text)this.proxied).paintRendered(rg, this, this.txf, this.firstChunk);
        }
    }

    void checkLayout() {
        if (this.firstChunk == null) {
            GlyphLayout cur = this.firstChunk = ((Text)this.proxied).layoutText(this);
            while (cur.nextSibling != null) {
                cur = cur.nextSibling;
            }
            this.lastChunk = cur;
        }
    }

    protected void computeRenderingTile(Tile tile) {
        this.checkLayout();
        ((Text)this.proxied).computeRenderingTile(tile, this.txf, this, this.firstChunk);
    }

    protected void setProxied(ElementNode newProxied) {
        if (newProxied != null && !(newProxied instanceof Text)) {
            throw new IllegalArgumentException();
        }
        super.setProxied(newProxied);
        this.clearLayoutsQuiet();
    }

    public void clearLayouts() {
        this.modifyingNode();
        this.clearLayoutsQuiet();
        super.clearLayouts();
        this.modifiedNode();
    }

    public void clearLayoutsQuiet() {
        this.firstChunk = null;
        this.lastChunk = null;
    }

    public void setDisplay(boolean newDisplay) {
        super.setDisplay(newDisplay);
        this.renderingDirty();
    }

    public void setVisibility(boolean newVisibility) {
        super.setVisibility(newVisibility);
        this.renderingDirty();
    }

    public void setFill(PaintServer newFill) {
        this.fill = newFill;
        this.renderingDirty();
    }

    public void setStroke(PaintServer newStroke) {
        this.stroke = newStroke;
        this.renderingDirty();
    }

    public void setStrokeWidth(float newStrokeWidth) {
        this.strokeWidth = newStrokeWidth;
        if (this.stroke != null) {
            this.renderingDirty();
        }
    }

    public void setStrokeLineJoin(int newStrokeLineJoin) {
        super.setStrokeLineJoin(newStrokeLineJoin);
        if (this.stroke != null) {
            this.renderingDirty();
        }
    }

    public void setStrokeLineCap(int newStrokeLineCap) {
        super.setStrokeLineCap(newStrokeLineCap);
        if (this.stroke != null) {
            this.renderingDirty();
        }
    }

    public void setStrokeMiterLimit(float newStrokeMiterLimit) {
        this.strokeMiterLimit = newStrokeMiterLimit;
        if (this.stroke != null && this.getStrokeLineJoin() == 0) {
            this.renderingDirty();
        }
    }

    public void setStrokeDashArray(float[] newStrokeDashArray) {
        this.strokeDashArray = newStrokeDashArray;
        if (this.stroke != null) {
            this.renderingDirty();
        }
    }

    public void setStrokeDashOffset(float newStrokeDashOffset) {
        this.strokeDashOffset = newStrokeDashOffset;
        if (this.stroke != null && this.strokeDashArray != null) {
            this.renderingDirty();
        }
    }

    public void setFillOpacity(float newFillOpacity) {
        super.setFillOpacity(newFillOpacity);
        if (this.fill != null) {
            this.renderingDirty();
        }
    }

    public void setStrokeOpacity(float newStrokeOpacity) {
        super.setStrokeOpacity(newStrokeOpacity);
        if (this.stroke != null) {
            this.renderingDirty();
        }
    }

    public void setFontSize(float newFontSize) {
        this.fontSize = newFontSize;
        if (this.stroke != null || this.fill != null) {
            this.renderingDirty();
        }
        this.computeCanRenderFontSizeBit(newFontSize);
    }

    public void setFontFamily(String[] newFontFamily) {
        this.fontFamily = newFontFamily;
        this.clearLayoutsQuiet();
        if (this.stroke != null || this.fill != null) {
            this.renderingDirty();
        }
    }

    public void setTextAnchor(int newTextAnchor) {
        super.setTextAnchor(newTextAnchor);
        if (this.stroke != null || this.fill != null) {
            this.renderingDirty();
        }
    }

    public void setFontWeight(int newFontWeight) {
        super.setFontWeight(newFontWeight);
        if (this.stroke != null || this.fill != null) {
            this.renderingDirty();
        }
        this.clearLayoutsQuiet();
    }

    public void setFontStyle(int newFontStyle) {
        super.setFontStyle(newFontStyle);
        if (this.stroke != null || this.fill != null) {
            this.renderingDirty();
        }
        this.clearLayoutsQuiet();
    }
}

