/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeCondition;
import com.sun.perseus.model.TimeContainerNode;
import com.sun.perseus.model.TimedElementSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimationElement;

public class TimedElementNode
extends ElementNode
implements SVGAnimationElement {
    protected TimedElementSupport timedElementSupport;
    protected String localName;

    public TimedElementNode(DocumentNode ownerDocument, String localName) {
        this(ownerDocument, new TimedElementSupport(), localName);
    }

    public TimedElementNode(DocumentNode ownerDocument) {
        this(ownerDocument, new TimedElementSupport());
    }

    protected TimedElementNode(DocumentNode ownerDocument, TimedElementSupport timedElementSupport) {
        this(ownerDocument, timedElementSupport, "set");
    }

    protected TimedElementNode(DocumentNode ownerDocument, TimedElementSupport timedElementSupport, String localName) {
        super(ownerDocument);
        if (timedElementSupport == null) {
            throw new IllegalArgumentException();
        }
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        this.timedElementSupport = timedElementSupport;
        this.localName = localName;
        timedElementSupport.animationElement = this;
    }

    void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
        ModelNode p = this.parent;
        while (p != this.ownerDocument && p != null) {
            if (p instanceof TimeContainerNode) {
                this.timedElementSupport.setTimeContainer(((TimeContainerNode)p).timeContainerSupport);
                break;
            }
            p = p.parent;
        }
        if (p == this.ownerDocument) {
            this.timedElementSupport.setTimeContainer(this.ownerDocument.timeContainerRootSupport);
        }
    }

    void nodeUnhookedFromDocumentTree() {
        this.timedElementSupport.setTimeContainer(null);
        this.timedElementSupport.reset();
    }

    public String getLocalName() {
        return this.localName;
    }

    public String[][] getDefaultTraits() {
        return new String[][]{{"begin", "0s"}};
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new TimedElementNode(doc, new TimedElementSupport(), this.localName);
    }

    public TimedElementSupport getTimedElementSupport() {
        return this.timedElementSupport;
    }

    public void beginElementAt(float offset) {
        this.timedElementSupport.beginAt((long)(offset * 1000.0f));
    }

    public void beginElement() {
        this.timedElementSupport.beginAt(0L);
    }

    public void endElementAt(float offset) {
        this.timedElementSupport.endAt((long)(offset * 1000.0f));
    }

    public void endElement() {
        this.timedElementSupport.endAt(0L);
    }

    public void pauseElement() {
        throw new Error("NOT IMPLEMENTED");
    }

    public void unpauseElement() {
        throw new Error("NOT IMPLEMENTED");
    }

    public boolean getElementPaused() {
        throw new Error("NOT IMPLEMENTED");
    }

    boolean supportsTrait(String traitName) {
        if ("begin" == traitName || "end" == traitName || "dur" == traitName || "min" == traitName || "max" == traitName || "restart" == traitName || "repeatCount" == traitName || "repeatDur" == traitName || "fill" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("begin" == name) {
            if (this.timedElementSupport.beginConditions.size() == 0) {
                return "0s";
            }
            return TimeCondition.toStringTrait(this.timedElementSupport.beginConditions);
        }
        if ("end" == name) {
            if (this.timedElementSupport.endConditions.size() == 0) {
                return "indefinite";
            }
            return TimeCondition.toStringTrait(this.timedElementSupport.endConditions);
        }
        if ("dur" == name) {
            return Time.toStringTrait(this.timedElementSupport.dur);
        }
        if ("min" == name) {
            return Time.toStringTrait(this.timedElementSupport.min);
        }
        if ("max" == name) {
            return Time.toStringTrait(this.timedElementSupport.max);
        }
        if ("restart" == name) {
            switch (this.timedElementSupport.restart) {
                case 1: {
                    return "always";
                }
                case 2: {
                    return "whenNotActive";
                }
                case 3: {
                    return "never";
                }
            }
            throw new IllegalStateException();
        }
        if ("repeatCount" == name) {
            if (Float.isNaN(this.timedElementSupport.repeatCount)) {
                return null;
            }
            if (this.timedElementSupport.repeatCount == Float.MAX_VALUE) {
                return "indefinite";
            }
            return Float.toString(this.timedElementSupport.repeatCount);
        }
        if ("repeatDur" == name) {
            return Time.toStringTrait(this.timedElementSupport.repeatDur);
        }
        if ("fill" == name) {
            switch (this.timedElementSupport.fillBehavior) {
                case 1: {
                    return "remove";
                }
                case 2: {
                    return "freeze";
                }
            }
            throw new IllegalStateException();
        }
        return super.getTraitImpl(name);
    }

    protected void parseTimeConditionsTrait(String traitName, String value, boolean isBegin) throws DOMException {
        try {
            this.ownerDocument.timeConditionParser.parseBeginEndAttribute(value, this, isBegin);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw this.illegalTraitValue(traitName, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("begin" == name) {
            this.checkWriteLoading(name);
            this.timedElementSupport.beginConditions.removeAllElements();
            this.parseTimeConditionsTrait(name, value, true);
            return;
        } else if ("end" == name) {
            this.checkWriteLoading(name);
            this.timedElementSupport.endConditions.removeAllElements();
            this.parseTimeConditionsTrait(name, value, false);
            return;
        } else if ("dur" == name) {
            this.checkWriteLoading(name);
            if ("media".equals(value)) {
                return;
            }
            this.timedElementSupport.setDur(this.parseClockTrait(name, value));
            return;
        } else if ("min" == name) {
            this.checkWriteLoading(name);
            if ("media".equals(value)) {
                return;
            }
            this.timedElementSupport.setMin(this.parseMinMaxClock(name, value, true));
            return;
        } else if ("max" == name) {
            this.checkWriteLoading(name);
            if ("media".equals(value)) {
                return;
            }
            this.timedElementSupport.setMax(this.parseMinMaxClock(name, value, false));
            return;
        } else if ("restart" == name) {
            this.checkWriteLoading(name);
            if ("always".equals(value)) {
                this.timedElementSupport.restart = 1;
                return;
            } else if ("whenNotActive".equals(value)) {
                this.timedElementSupport.restart = 2;
                return;
            } else {
                if (!"never".equals(value)) throw this.illegalTraitValue(name, value);
                this.timedElementSupport.restart = 3;
            }
            return;
        } else if ("repeatCount" == name) {
            this.checkWriteLoading(name);
            this.timedElementSupport.repeatCount = "indefinite".equals(value) ? Float.MAX_VALUE : this.parseFloatTrait(name, value);
            return;
        } else if ("repeatDur" == name) {
            this.checkWriteLoading(name);
            if ("indefinite".equals(value)) {
                this.timedElementSupport.repeatDur = Time.INDEFINITE;
                return;
            } else {
                this.timedElementSupport.setRepeatDur(this.parseClockTrait(name, value));
            }
            return;
        } else if ("fill" == name) {
            this.checkWriteLoading(name);
            if ("remove".equals(value)) {
                this.timedElementSupport.fillBehavior = 1;
                return;
            } else {
                if (!"freeze".equals(value)) throw this.illegalTraitValue(name, value);
                this.timedElementSupport.fillBehavior = 2;
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }
}

