/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Animation;
import com.sun.perseus.model.Segment;
import com.sun.perseus.platform.MathSupport;

public class TransformSegment
implements Segment {
    float[] start;
    float[] end;
    int type;

    public Object[] getStart() {
        float[][] v = new float[6][1];
        this.compute(0.0f, v);
        return v;
    }

    public Object[] getEnd() {
        float[][] v = new float[6][1];
        this.compute(1.0f, v);
        return v;
    }

    public void setZeroStart() {
        switch (this.type) {
            case 2: {
                this.start[0] = 0.0f;
                this.start[1] = 0.0f;
                break;
            }
            case 3: {
                this.start[0] = 1.0f;
                this.start[1] = 1.0f;
                break;
            }
            case 4: {
                this.start[0] = 0.0f;
                break;
            }
            default: {
                this.start[0] = 0.0f;
            }
        }
    }

    public void setStart(Object[] newStart) {
        float[][] ns = (float[][])newStart;
        switch (this.type) {
            case 2: {
                this.start[0] = ns[4][0];
                this.start[1] = ns[5][0];
                break;
            }
            case 3: {
                this.start[0] = ns[0][0];
                this.start[1] = ns[3][0];
                break;
            }
            case 4: {
                this.start[0] = MathSupport.atan2(ns[1][0], ns[0][0]);
                break;
            }
            case 5: {
                this.start[0] = MathSupport.atan(ns[2][0]);
                break;
            }
            default: {
                this.start[0] = MathSupport.atan(ns[1][0]);
            }
        }
    }

    public void collapse(Segment seg, Animation anim) {
        TransformSegment mseg = (TransformSegment)seg;
        if (mseg.end.length != this.end.length) {
            throw new IllegalArgumentException();
        }
        this.end = mseg.end;
    }

    public void addToEnd(Object[] by) {
        float[][] ns = (float[][])by;
        switch (this.type) {
            case 2: {
                this.end[0] = this.end[0] + ns[4][0];
                this.end[1] = this.end[1] + ns[5][0];
                break;
            }
            case 3: {
                this.end[0] = this.end[0] + ns[0][0];
                this.end[1] = this.end[1] + ns[3][0];
                break;
            }
            case 4: {
                float div;
                float cos = ns[0][0];
                float sin = ns[1][0];
                this.end[0] = this.end[0] + MathSupport.atan2(ns[1][0], ns[0][0]);
                float a = ns[4][0];
                float b = ns[5][0];
                if (a == 0.0f || b == 0.0f || (div = 2.0f * (1.0f - cos)) == 0.0f) break;
                float y = (a * sin + b * (1.0f - cos)) / div;
                float x = (a - y * sin) / (1.0f - cos);
                this.end[1] = this.end[1] + x;
                this.end[2] = this.end[2] + y;
                break;
            }
            case 5: {
                this.end[0] = this.end[0] + MathSupport.atan(ns[2][0]);
                break;
            }
            default: {
                this.end[0] = this.end[0] + MathSupport.atan(ns[1][0]);
            }
        }
    }

    public boolean isAdditive() {
        return true;
    }

    public float getLength() {
        float length = 0.0f;
        switch (this.type) {
            case 2: {
                length = this.end[0] > this.start[0] ? (length += this.end[0] - this.start[0]) : (length += this.start[0] - this.end[0]);
                length = this.end[1] > this.start[1] ? (length += this.end[1] - this.start[1]) : (length += this.start[1] - this.end[1]);
                return length;
            }
            case 3: {
                length = this.end[0] > this.start[0] ? (length += this.end[0] - this.start[0]) : (length += this.start[0] - this.end[0]);
                length = this.end[1] > this.start[1] ? (length += this.end[1] - this.start[1]) : (length += this.start[1] - this.end[1]);
                return length;
            }
            case 4: {
                length = this.end[0] > this.start[0] ? (length += this.end[0] - this.start[0]) : (length += this.start[0] - this.end[0]);
                length = this.end[1] > this.start[1] ? (length += this.end[1] - this.start[1]) : (length += this.start[1] - this.end[1]);
                length = this.end[2] > this.start[2] ? (length += this.end[2] - this.start[2]) : (length += this.start[2] - this.end[2]);
                return length;
            }
            case 5: {
                length = this.end[0] > this.start[0] ? (length += this.end[0] - this.start[0]) : (length += this.start[0] - this.end[0]);
                return length;
            }
        }
        length = this.end[0] > this.start[0] ? (length += this.end[0] - this.start[0]) : (length += this.start[0] - this.end[0]);
        return length;
    }

    public Object[] compute(float p, float[][] w) {
        switch (this.type) {
            case 2: {
                w[0][0] = 1.0f;
                w[1][0] = 0.0f;
                w[2][0] = 0.0f;
                w[3][0] = 1.0f;
                w[4][0] = (1.0f - p) * this.start[0] + p * this.end[0];
                w[5][0] = (1.0f - p) * this.start[1] + p * this.end[1];
                break;
            }
            case 3: {
                w[0][0] = (1.0f - p) * this.start[0] + p * this.end[0];
                w[1][0] = 0.0f;
                w[2][0] = 0.0f;
                w[3][0] = (1.0f - p) * this.start[1] + p * this.end[1];
                w[4][0] = 0.0f;
                w[5][0] = 0.0f;
                break;
            }
            case 4: {
                float cos;
                float x = (1.0f - p) * this.start[1] + p * this.end[1];
                float y = (1.0f - p) * this.start[2] + p * this.end[2];
                float theta = (1.0f - p) * this.start[0] + p * this.end[0];
                float sin = MathSupport.sin(theta);
                w[0][0] = cos = MathSupport.cos(theta);
                w[1][0] = sin;
                w[2][0] = -sin;
                w[3][0] = cos;
                w[4][0] = x - x * cos + y * sin;
                w[5][0] = y - x * sin - y * cos;
                break;
            }
            case 5: {
                float theta = (1.0f - p) * this.start[0] + p * this.end[0];
                w[0][0] = 1.0f;
                w[1][0] = 0.0f;
                w[2][0] = MathSupport.tan(theta);
                w[3][0] = 1.0f;
                w[4][0] = 0.0f;
                w[5][0] = 0.0f;
                break;
            }
            default: {
                float theta = (1.0f - p) * this.start[0] + p * this.end[0];
                w[0][0] = 1.0f;
                w[1][0] = MathSupport.tan(theta);
                w[2][0] = 0.0f;
                w[3][0] = 1.0f;
                w[4][0] = 0.0f;
                w[5][0] = 0.0f;
            }
        }
        return w;
    }

    public void initialize() {
    }
}

