/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.platform;

import com.sun.perseus.platform.BufferedInputStream;
import com.sun.perseus.platform.GZIPInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.InputConnection;

public class GZIPSupport {
    public static final String HTTP_ACCEPT_ENCODING = "Accept-Encoding";
    static final String HTTP_GZIP_ENCODING = "gzip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream openHandleGZIP(String svgURI) throws IOException {
        InputConnection svgURLConnection = (InputConnection)Connector.open((String)svgURI, (int)1);
        try {
            if (svgURLConnection instanceof HttpConnection) {
                GZIPSupport.setupHttpEncoding((HttpConnection)svgURLConnection);
            }
            InputStream inputStream = svgURLConnection.openInputStream();
            return inputStream;
        }
        finally {
            svgURLConnection.close();
        }
    }

    static void setupHttpEncoding(HttpConnection httpC) throws IOException {
        String encodings = httpC.getRequestProperty(HTTP_ACCEPT_ENCODING);
        if (encodings == null) {
            encodings = "";
        }
        if (encodings.trim().length() > 0) {
            encodings = encodings + ",";
        }
        encodings = encodings + HTTP_GZIP_ENCODING;
        httpC.setRequestProperty(HTTP_ACCEPT_ENCODING, encodings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream handleGZIP(InputStream is) throws IOException {
        is = new BufferedInputStream(is);
        int magicIn = 0;
        try {
            is.mark(2);
            magicIn = 0xFFFF & (is.read() | is.read() << 8);
        }
        catch (IOException ex) {
            is.reset();
            InputStream inputStream = is;
            return inputStream;
        }
        finally {
            try {
                is.reset();
            }
            catch (IOException ioe) {
                throw new Error();
            }
        }
        if (magicIn == 35615) {
            return new GZIPInputStream(is);
        }
        return is;
    }
}

