/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.platform;

public final class MathSupport {
    public static final float PI = (float)Math.PI;

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static int round(float a) {
        return (int)Math.floor(a + 0.5f);
    }

    public static float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static float atan2(float y, float x) {
        if (y == 0.0f && x == 0.0f) {
            return 0.0f;
        }
        if (x > 0.0f) {
            return MathSupport.atan(y / x);
        }
        if (x < 0.0f) {
            if (y < 0.0f) {
                return (float)(-(Math.PI - (double)MathSupport.atan(y / x)));
            }
            return (float)(Math.PI - (double)MathSupport.atan(-y / x));
        }
        if (y < 0.0f) {
            return -1.5707964f;
        }
        return 1.5707964f;
    }

    public static float atan(float a) {
        if (MathSupport.abs(a) <= 1.0f) {
            return a / (1.0f + 0.28f * (a * a));
        }
        float retval = 1.5707964f - a / (a * a + 0.28f);
        if (a < -1.0f) {
            return retval - (float)Math.PI;
        }
        return retval;
    }

    public static int abs(int a) {
        return a < 0 ? -a : a;
    }

    public static float abs(float a) {
        return a <= 0.0f ? 0.0f - a : a;
    }

    public static float toRadians(float angdeg) {
        return angdeg / 180.0f * (float)Math.PI;
    }

    public static float toDegrees(float angrad) {
        return angrad * 180.0f / (float)Math.PI;
    }
}

