/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.platform;

import com.sun.perseus.platform.PURLStreamHandler;

public final class PURL {
    static final long serialVersionUID = -7627629688361524110L;
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private String protocol;
    private String host;
    private int port = -1;
    private String file;
    private transient String query;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private String ref;
    transient Object hostAddress;
    private int hashCode = -1;

    public PURL(String spec) throws Error {
        this(null, spec);
    }

    public PURL(PURL context, String spec) throws Error {
        this(context, spec, null);
    }

    public PURL(PURL context, String spec, Object handler) throws Error {
        String original = spec;
        int start = 0;
        String newProtocol = null;
        boolean aRef = false;
        boolean isRelative = false;
        if (handler != null) {
            // empty if block
        }
        try {
            char c;
            int i;
            int limit;
            for (limit = spec.length(); limit > 0 && spec.charAt(limit - 1) <= ' '; --limit) {
            }
            while (start < limit && spec.charAt(start) <= ' ') {
                ++start;
            }
            if (spec.regionMatches(true, start, "url:", 0, 4)) {
                start += 4;
            }
            if (start < spec.length() && spec.charAt(start) == '#') {
                aRef = true;
            }
            for (i = start; !aRef && i < limit && (c = spec.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                String s = spec.substring(start, i).toLowerCase();
                if (!this.isValidProtocol(s)) break;
                newProtocol = s;
                start = i + 1;
                break;
            }
            this.protocol = newProtocol;
            if (context != null && (newProtocol == null || newProtocol.equalsIgnoreCase(context.protocol))) {
                if (context.path != null && context.path.startsWith("/")) {
                    newProtocol = null;
                }
                if (newProtocol == null) {
                    this.protocol = context.protocol;
                    this.authority = context.authority;
                    this.userInfo = context.userInfo;
                    this.host = context.host;
                    this.port = context.port;
                    this.file = context.file;
                    this.path = context.path;
                    isRelative = true;
                }
            }
            if (this.protocol == null) {
                throw new Error("no protocol: " + original);
            }
            i = spec.indexOf(35, start);
            if (i >= 0) {
                this.ref = spec.substring(i + 1, limit);
                limit = i;
            }
            if (isRelative && start == limit) {
                this.query = context.query;
                if (this.ref == null) {
                    this.ref = context.ref;
                }
            }
            PURLStreamHandler.parseURL(this, spec, start, limit);
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(e.getMessage());
        }
    }

    private boolean isValidProtocol(String protocol) {
        int len = protocol.length();
        if (len < 1) {
            return false;
        }
        char c = protocol.charAt(0);
        if (!Character.isLowerCase(c) && !Character.isUpperCase(c)) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            c = protocol.charAt(i);
            if (Character.isLowerCase(c) || Character.isUpperCase(c) || Character.isDigit(c) || c == '.' || c == '+' || c == '-') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String protocol, String host, int port, String file, String ref) {
        PURL pURL = this;
        synchronized (pURL) {
            this.protocol = protocol;
            this.host = host;
            this.authority = port == -1 ? host : host + ":" + port;
            this.port = port;
            this.file = file;
            this.ref = ref;
            this.hashCode = -1;
            this.hostAddress = null;
            int q = file.lastIndexOf(63);
            if (q != -1) {
                this.query = file.substring(q + 1);
                this.path = file.substring(0, q);
            } else {
                this.path = file;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        PURL pURL = this;
        synchronized (pURL) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
            this.file = query == null ? path : path + "?" + query;
            this.userInfo = userInfo;
            this.path = path;
            this.ref = ref;
            this.hashCode = -1;
            this.hostAddress = null;
            this.query = query;
            this.authority = authority;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getAuthority() {
        return this.authority;
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return -1;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFile() {
        return this.file;
    }

    public String getRef() {
        return this.ref;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        return PURLStreamHandler.toExternalForm(this);
    }
}

