/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.platform;

import com.sun.perseus.platform.PURL;

class PURLStreamHandler {
    PURLStreamHandler() {
    }

    protected static String toExternalForm(PURL u) {
        int len = u.getProtocol().length() + 1;
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            len += 2 + u.getAuthority().length();
        }
        if (u.getPath() != null) {
            len += u.getPath().length();
        }
        if (u.getQuery() != null) {
            len += 1 + u.getQuery().length();
        }
        if (u.getRef() != null) {
            len += 1 + u.getRef().length();
        }
        StringBuffer result = new StringBuffer(len);
        result.append(u.getProtocol());
        result.append(":");
        if (u.getAuthority() != null && u.getAuthority().length() > 0) {
            result.append("//");
            result.append(u.getAuthority());
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        return result.toString();
    }

    protected static void setURL(PURL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        u.set(u.getProtocol(), host, port, authority, userInfo, path, query, ref);
    }

    public static void parseURL(PURL u, String spec, int start, int limit) {
        int ind;
        String protocol = u.getProtocol();
        String authority = u.getAuthority();
        String userInfo = u.getUserInfo();
        String host = u.getHost();
        int port = u.getPort();
        String path = u.getPath();
        String query = u.getQuery();
        String ref = u.getRef();
        boolean isRelPath = false;
        boolean queryOnly = false;
        if (start < limit) {
            int queryStart = spec.indexOf(63);
            boolean bl = queryOnly = queryStart == start;
            if (queryStart != -1 && queryStart < limit) {
                query = spec.substring(queryStart + 1, limit);
                if (limit > queryStart) {
                    limit = queryStart;
                }
                spec = spec.substring(0, queryStart);
            }
        }
        int i = 0;
        if (start <= limit - 2 && spec.charAt(start) == '/' && spec.charAt(start + 1) == '/') {
            i = spec.indexOf(47, start += 2);
            if (i < 0 && (i = spec.indexOf(63, start)) < 0) {
                i = limit;
            }
            host = authority = spec.substring(start, i);
            ind = authority.indexOf(64);
            if (ind != -1) {
                userInfo = authority.substring(0, ind);
                host = authority.substring(ind + 1);
            } else {
                userInfo = null;
            }
            if (host != null) {
                if (host.length() > 0 && host.charAt(0) == '[') {
                    throw new Error("Can't handle IPv6 addresses!");
                }
                ind = host.indexOf(58);
                port = -1;
                if (ind >= 0) {
                    if (host.length() > ind + 1) {
                        port = Integer.parseInt(host.substring(ind + 1));
                    }
                    host = host.substring(0, ind);
                }
            } else {
                host = "";
            }
            if (port < -1) {
                throw new IllegalArgumentException("Invalid port number :" + port);
            }
            start = i;
            if (authority != null && authority.length() > 0) {
                path = "";
            }
        }
        if (host == null) {
            host = "";
        }
        if (start < limit) {
            if (spec.charAt(start) == '/') {
                path = spec.substring(start, limit);
            } else if (path != null && path.length() > 0) {
                isRelPath = true;
                ind = path.lastIndexOf(47);
                String seperator = "";
                if (ind == -1 && authority != null) {
                    seperator = "/";
                }
                path = path.substring(0, ind + 1) + seperator + spec.substring(start, limit);
            } else {
                String seperator = authority != null ? "/" : "";
                path = seperator + spec.substring(start, limit);
            }
        } else if (queryOnly && path != null) {
            ind = path.lastIndexOf(47);
            if (ind < 0) {
                ind = 0;
            }
            path = path.substring(0, ind) + "/";
        }
        if (path == null) {
            path = "";
        }
        if (isRelPath) {
            while ((i = path.indexOf("/./")) >= 0) {
                path = path.substring(0, i) + path.substring(i + 2);
            }
            i = 0;
            while ((i = path.indexOf("/../", i)) > 0) {
                limit = path.lastIndexOf(47, i - 1);
                if (limit >= 0) {
                    path = path.substring(0, limit) + path.substring(i + 3);
                    i = 0;
                    continue;
                }
                i += 3;
            }
            while (path.endsWith("/..") && (limit = path.lastIndexOf(47, (i = path.indexOf("/..")) - 1)) >= 0) {
                path = path.substring(0, limit + 1);
            }
            if (path.startsWith("./") && path.length() > 2) {
                path = path.substring(2);
            }
            if (path.endsWith("/.")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        PURLStreamHandler.setURL(u, protocol, host, port, authority, userInfo, path, query, ref);
    }
}

