/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.GZIPInputStream;
import com.sun.pisces.PathStore;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class Face {
    PathStore[] paths = new PathStore[256];
    int[] minX = new int[256];
    int[] minY = new int[256];
    int[] width = new int[256];
    int[] height = new int[256];
    double scale;

    public Face(InputStream in) throws IOException {
        GZIPInputStream gin = new GZIPInputStream(in);
        DataInputStream dis = new DataInputStream(gin);
        String name = dis.readUTF();
        String style = dis.readUTF();
        this.scale = 65536.0 / dis.readDouble();
        while (true) {
            char glyph;
            try {
                glyph = dis.readChar();
            }
            catch (EOFException eof) {
                return;
            }
            int gx = dis.readInt();
            int gy = dis.readInt();
            int gwidth = dis.readInt();
            int gheight = dis.readInt();
            int numEntries = dis.readInt();
            PathStore ps = new PathStore(numEntries);
            int[] x = new int[4];
            int[] y = new int[4];
            int sx0 = 0;
            int sy0 = 0;
            int xp = 0;
            int yp = 0;
            boolean prevIsQuad = false;
            boolean prevIsCubic = false;
            while (true) {
                char tok;
                if ((tok = dis.readChar()) == 'Z') {
                    ps.close();
                    ps.end();
                    break;
                }
                if (tok == 'E') {
                    ps.end();
                    break;
                }
                int x0 = x[0];
                int y0 = y[0];
                switch (tok) {
                    case 'M': {
                        x[0] = dis.readInt();
                        y[0] = dis.readInt();
                        break;
                    }
                    case 'm': {
                        x[0] = x[0] + dis.readShort();
                        y[0] = y[0] + dis.readShort();
                        break;
                    }
                    case 'n': {
                        x[0] = x[0] + dis.readByte();
                        y[0] = y[0] + dis.readByte();
                        break;
                    }
                    case 'H': {
                        x[0] = dis.readInt();
                        break;
                    }
                    case 'h': {
                        x[0] = x[0] + dis.readShort();
                        break;
                    }
                    case 'i': {
                        x[0] = x[0] + dis.readByte();
                        break;
                    }
                    case 'V': {
                        y[0] = dis.readInt();
                        break;
                    }
                    case 'v': {
                        y[0] = y[0] + dis.readShort();
                        break;
                    }
                    case 'w': {
                        y[0] = y[0] + dis.readByte();
                        break;
                    }
                    case 'L': {
                        x[0] = dis.readInt();
                        y[0] = dis.readInt();
                        break;
                    }
                    case 'l': {
                        x[0] = x[0] + dis.readShort();
                        y[0] = y[0] + dis.readShort();
                        break;
                    }
                    case 'k': {
                        x[0] = x[0] + dis.readByte();
                        y[0] = y[0] + dis.readByte();
                        break;
                    }
                    case 'Q': {
                        x[0] = dis.readInt();
                        y[0] = dis.readInt();
                        x[1] = dis.readInt();
                        y[1] = dis.readInt();
                        break;
                    }
                    case 'q': {
                        x[0] = x0 + dis.readShort();
                        y[0] = y0 + dis.readShort();
                        x[1] = x0 + dis.readShort();
                        y[1] = y0 + dis.readShort();
                        break;
                    }
                    case 'r': {
                        x[0] = x0 + dis.readByte();
                        y[0] = y0 + dis.readByte();
                        x[1] = x0 + dis.readByte();
                        y[1] = y0 + dis.readByte();
                        break;
                    }
                    case 'T': {
                        x[0] = x0 + (prevIsQuad ? x0 - xp : 0);
                        y[0] = y0 + (prevIsQuad ? y0 - yp : 0);
                        x[1] = dis.readInt();
                        y[1] = dis.readInt();
                        break;
                    }
                    case 't': {
                        x[0] = x0 + (prevIsQuad ? x0 - xp : 0);
                        y[0] = y0 + (prevIsQuad ? y0 - yp : 0);
                        x[1] = x0 + dis.readShort();
                        y[1] = y0 + dis.readShort();
                        break;
                    }
                    case 'u': {
                        x[0] = x0 + (prevIsQuad ? x0 - xp : 0);
                        y[0] = y0 + (prevIsQuad ? y0 - yp : 0);
                        x[1] = x0 + dis.readByte();
                        y[1] = y0 + dis.readByte();
                        break;
                    }
                    case 'C': {
                        x[0] = dis.readInt();
                        y[0] = dis.readInt();
                        x[1] = dis.readInt();
                        y[1] = dis.readInt();
                        x[2] = dis.readInt();
                        y[2] = dis.readInt();
                        break;
                    }
                    case 'c': {
                        x[0] = x0 + dis.readShort();
                        y[0] = y0 + dis.readShort();
                        x[1] = x0 + dis.readShort();
                        y[1] = y0 + dis.readShort();
                        x[2] = x0 + dis.readShort();
                        y[2] = y0 + dis.readShort();
                        break;
                    }
                    case 'd': {
                        x[0] = x0 + dis.readByte();
                        y[0] = y0 + dis.readByte();
                        x[1] = x0 + dis.readByte();
                        y[1] = y0 + dis.readByte();
                        x[2] = x0 + dis.readByte();
                        y[2] = y0 + dis.readByte();
                        break;
                    }
                    case 'S': {
                        x[0] = x0 + (prevIsCubic ? x0 - xp : 0);
                        y[0] = y0 + (prevIsCubic ? y0 - yp : 0);
                        x[1] = dis.readInt();
                        y[1] = dis.readInt();
                        x[2] = dis.readInt();
                        y[2] = dis.readInt();
                        break;
                    }
                    case 's': {
                        x[0] = x0 + (prevIsCubic ? x0 - xp : 0);
                        y[0] = y0 + (prevIsCubic ? y0 - yp : 0);
                        x[1] = x0 + dis.readShort();
                        y[1] = y0 + dis.readShort();
                        x[2] = x0 + dis.readShort();
                        y[2] = y0 + dis.readShort();
                        break;
                    }
                    case 'p': {
                        x[0] = x0 + (prevIsCubic ? x0 - xp : 0);
                        y[0] = y0 + (prevIsCubic ? y0 - yp : 0);
                        x[1] = x0 + dis.readByte();
                        y[1] = y0 + dis.readByte();
                        x[2] = x0 + dis.readByte();
                        y[2] = y0 + dis.readByte();
                    }
                }
                switch (tok) {
                    case 'M': 
                    case 'm': 
                    case 'n': {
                        ps.moveTo(x[0], y[0]);
                        sx0 = x[0];
                        sy0 = y[0];
                        prevIsCubic = false;
                        prevIsQuad = false;
                        break;
                    }
                    case 'H': 
                    case 'L': 
                    case 'V': 
                    case 'h': 
                    case 'i': 
                    case 'k': 
                    case 'l': 
                    case 'v': 
                    case 'w': {
                        ps.lineTo(x[0], y[0]);
                        prevIsCubic = false;
                        prevIsQuad = false;
                        break;
                    }
                    case 'Q': 
                    case 'T': 
                    case 'q': 
                    case 'r': 
                    case 't': 
                    case 'u': {
                        ps.quadTo(x[0], y[0], x[1], y[1]);
                        xp = x[0];
                        yp = y[0];
                        x[0] = x[1];
                        y[0] = y[1];
                        prevIsQuad = true;
                        prevIsCubic = false;
                        break;
                    }
                    case 'C': 
                    case 'S': 
                    case 'c': 
                    case 'd': 
                    case 'p': 
                    case 's': {
                        ps.cubicTo(x[0], y[0], x[1], y[1], x[2], y[2]);
                        xp = x[1];
                        yp = y[1];
                        x[0] = x[2];
                        y[0] = y[2];
                        prevIsQuad = false;
                        prevIsCubic = true;
                        break;
                    }
                    case 'z': {
                        ps.close();
                        x[0] = sx0;
                        y[0] = sy0;
                        prevIsCubic = false;
                        prevIsQuad = false;
                    }
                }
            }
            char idx = glyph;
            this.paths[idx] = ps;
            this.minX[idx] = gx;
            this.minY[idx] = gy;
            this.width[idx] = gwidth;
            this.height[idx] = gheight;
        }
    }
}

