/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.LineSink;
import com.sun.pisces.PathSink;

public class Flattener
extends PathSink {
    public static final long MAX_CHORD_LENGTH_SQ = 0x10000000000L;
    public static final long MIN_CHORD_LENGTH_SQ = 0x40000000L;
    public static final int LG_FLATNESS = 0;
    public static final int FLATNESS_SQ_SHIFT = 0;
    LineSink output;
    int flatness;
    int flatnessSq;
    int x0;
    int y0;

    public Flattener() {
    }

    public Flattener(LineSink output, int flatness) {
        this.setOutput(output);
        this.setFlatness(flatness);
    }

    public void setOutput(LineSink output) {
        this.output = output;
    }

    public void setFlatness(int flatness) {
        this.flatness = flatness;
        this.flatnessSq = (int)((long)flatness * (long)flatness >> 16);
    }

    public void moveTo(int x0, int y0) {
        this.output.moveTo(x0, y0);
        this.x0 = x0;
        this.y0 = y0;
    }

    public void lineJoin() {
        this.output.lineJoin();
    }

    public void lineTo(int x1, int y1) {
        this.output.lineJoin();
        this.output.lineTo(x1, y1);
        this.x0 = x1;
        this.y0 = y1;
    }

    public void quadTo(int x1, int y1, int x2, int y2) {
        this.output.lineJoin();
        this.quadToHelper(x1, y1, x2, y2);
    }

    private boolean flatEnough(int x0, int y0, int x1, int y1, int x2, int y2) {
        long numsq;
        long dx = (long)x2 - (long)x0;
        long dy = (long)y2 - (long)y0;
        long denom2 = dx * dx + dy * dy;
        if (denom2 > 0x10000000000L) {
            return false;
        }
        if (denom2 < 0x40000000L) {
            int maxy;
            long dy1;
            int minx = Math.min(Math.min(x0, x1), x2);
            int miny = Math.min(Math.min(y0, y1), y2);
            int maxx = Math.max(Math.max(x0, x1), x2);
            long dx1 = (long)maxx - (long)minx;
            long l2 = dx1 * dx1 + (dy1 = (long)(maxy = Math.max(Math.max(y0, y1), y2)) - (long)miny) * dy1;
            if (l2 < 0x40000000L) {
                return true;
            }
        }
        long num = -dy * (long)x1 + dx * (long)y1 + ((long)x0 * (long)y2 - (long)x2 * (long)y0);
        long df2 = denom2 * (long)this.flatnessSq >> 16;
        return (numsq = (num >>= 16) * num) < df2;
    }

    private void quadToHelper(int x1, int y1, int x2, int y2) {
        if (this.flatEnough(this.x0, this.y0, x1, y1, x2, y2)) {
            this.output.lineTo(x1, y1);
            this.output.lineTo(x2, y2);
        } else {
            long lx1 = x1;
            long ly1 = y1;
            long x01 = (long)this.x0 + lx1;
            long y01 = (long)this.y0 + ly1;
            long x12 = lx1 + (long)x2;
            long y12 = ly1 + (long)y2;
            long x012 = x01 + x12;
            long y012 = y01 + y12;
            this.quadToHelper((int)(x01 >> 1), (int)(y01 >> 1), (int)(x012 >> 2), (int)(y012 >> 2));
            this.quadToHelper((int)(x12 >> 1), (int)(y12 >> 1), x2, y2);
        }
        this.x0 = x2;
        this.y0 = y2;
    }

    public void cubicTo(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.output.lineJoin();
        this.cubicToHelper(x1, y1, x2, y2, x3, y3);
    }

    private boolean flatEnough(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3) {
        long num2sq;
        long num1sq;
        long dx = (long)x3 - (long)x0;
        long dy = (long)y3 - (long)y0;
        long denom2 = dx * dx + dy * dy;
        if (denom2 > 0x10000000000L) {
            return false;
        }
        if (denom2 < 0x40000000L) {
            int maxy;
            long dy1;
            int minx = Math.min(Math.min(Math.min(x0, x1), x2), x3);
            int miny = Math.min(Math.min(Math.min(y0, y1), y2), y3);
            int maxx = Math.max(Math.max(Math.max(x0, x1), x2), x3);
            long dx1 = (long)maxx - (long)minx;
            long l2 = dx1 * dx1 + (dy1 = (long)(maxy = Math.max(Math.max(Math.max(y0, y1), y2), y3)) - (long)miny) * dy1;
            if (l2 < 0x40000000L) {
                return true;
            }
        }
        long df2 = denom2 * (long)this.flatnessSq >> 16;
        long cross = (long)x0 * (long)y3 - (long)x3 * (long)y0;
        long num1 = dx * (long)y1 - dy * (long)x1 + cross;
        if ((num1sq = (num1 >>= 16) * num1) > df2) {
            return false;
        }
        long num2 = dx * (long)y2 - dy * (long)x2 + cross;
        return (num2sq = (num2 >>= 16) * num2) < df2;
    }

    private void cubicToHelper(int x1, int y1, int x2, int y2, int x3, int y3) {
        if (this.flatEnough(this.x0, this.y0, x1, y1, x2, y2, x3, y3)) {
            this.output.lineTo(x1, y1);
            this.output.lineTo(x2, y2);
            this.output.lineTo(x3, y3);
        } else {
            long lx1 = x1;
            long ly1 = y1;
            long lx2 = x2;
            long ly2 = y2;
            long x01 = (long)this.x0 + lx1;
            long y01 = (long)this.y0 + ly1;
            long x12 = lx1 + lx2;
            long y12 = ly1 + ly2;
            long x23 = lx2 + (long)x3;
            long y23 = ly2 + (long)y3;
            long x012 = x01 + x12;
            long y012 = y01 + y12;
            long x123 = x12 + x23;
            long y123 = y12 + y23;
            long x0123 = x012 + x123;
            long y0123 = y012 + y123;
            this.cubicToHelper((int)(x01 >> 1), (int)(y01 >> 1), (int)(x012 >> 2), (int)(y012 >> 2), (int)(x0123 >> 3), (int)(y0123 >> 3));
            this.cubicToHelper((int)(x123 >> 2), (int)(y123 >> 2), (int)(x23 >> 1), (int)(y23 >> 1), x3, y3);
        }
        this.x0 = x3;
        this.y0 = y3;
    }

    public void close() {
        this.output.lineJoin();
        this.output.close();
    }

    public void end() {
        this.output.end();
    }
}

