/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.HuffmanTable;
import java.io.IOException;
import java.io.InputStream;

class GZIPInputStream
extends InputStream {
    private static final int[] perm;
    private static final int[] lengthsTable;
    private static final int[] lengthExtraBitsTable;
    private static final int[] distancesTable;
    private static final int[] distanceExtraBitsTable;
    InputStream in;
    byte[] data = new byte[100];
    int count = 0;
    int idx = 0;
    int curByte;
    int curPos = 8;

    public GZIPInputStream(InputStream in) throws IOException {
        this.in = in;
        this.readGZIPHeader();
        while (!this.readBlock()) {
        }
    }

    private void readGZIPHeader() throws IOException {
        int id1 = this.in.read();
        int id2 = this.in.read();
        int cm = this.in.read();
        int flg = this.in.read();
        int ftext = flg & 1;
        int fhcrc = flg >> 1 & 1;
        int fextra = flg >> 2 & 1;
        int fname = flg >> 3 & 1;
        int fcomment = flg >> 4 & 1;
        int mtime0 = this.in.read();
        int mtime1 = this.in.read();
        int mtime2 = this.in.read();
        int mtime3 = this.in.read();
        long mtime = (long)mtime3 << 24 | (long)mtime2 << 16 | (long)mtime1 << 8 | (long)mtime0;
        int xfl = this.in.read();
        int os = this.in.read();
        if (fextra == 1) {
            int xlen = this.in.read() << 8 | this.in.read();
            for (int i = 0; i < xlen; ++i) {
                this.in.read();
            }
        }
        if (fname == 1) {
            while (this.in.read() != 0) {
            }
        }
        if (fcomment == 1) {
            while (this.in.read() != 0) {
            }
        }
        if (fhcrc == 1) {
            int crc = this.in.read() << 8 | this.in.read();
        }
    }

    int readBit() throws IOException {
        if (this.curPos == 8) {
            this.curByte = this.in.read();
            this.curPos = 0;
        }
        int bit = this.curByte >> this.curPos++ & 1;
        return bit;
    }

    int readBits(int numBits) throws IOException {
        int val = 0;
        for (int i = 0; i < numBits; ++i) {
            val |= this.readBit() << i;
        }
        return val;
    }

    int readHuffmanBits(int numBits) throws IOException {
        int val = 0;
        for (int i = 0; i < numBits; ++i) {
            val <<= 1;
            val |= this.readBit();
        }
        return val;
    }

    private void emit(int b) {
        if (this.count >= this.data.length) {
            byte[] tmp = new byte[this.data.length + 512];
            System.arraycopy(this.data, 0, tmp, 0, this.data.length);
            this.data = tmp;
        }
        this.data[this.count++] = (byte)b;
    }

    /*
     * Unable to fully structure code
     */
    private boolean readBlock() throws IOException {
        bfinal = this.readBits(1);
        btype = this.readBits(2);
        if (btype == 0) {
            this.readBits(5);
            len = this.in.read() << 8 | this.in.read();
            this.in.read();
            this.in.read();
            for (i = 0; i < len; ++i) {
                this.emit(this.in.read());
            }
        } else if (btype == 1 || btype == 2) {
            lltable = null;
            dtable = null;
            if (btype == 2) {
                hlit = this.readBits(5) + 257;
                hdist = this.readBits(5) + 1;
                hclen = this.readBits(4) + 4;
                hlengths = new int[19];
                for (i = 0; i < hclen; ++i) {
                    hlengths[GZIPInputStream.perm[i]] = len = this.readBits(3);
                }
                htable = new HuffmanTable(this, hlengths);
                lengths = new int[hlit + hdist];
                idx = 0;
                do {
                    if ((sym = htable.readSymbol()) <= 15) {
                        lengths[idx++] = sym;
                        continue;
                    }
                    if (sym == 16) {
                        repeat = this.readBits(2) + 3;
                        prev = lengths[idx - 1];
                        for (i = 0; i < repeat; ++i) {
                            lengths[idx++] = prev;
                        }
                    } else {
                        bits = sym == 17 ? 3 : 7;
                        repeat = this.readBits(bits);
                        repeat += sym == 17 ? 3 : 11;
                        for (i = 0; i < repeat; ++i) {
                            lengths[idx++] = 0;
                        }
                    }
                } while (idx < hlit + hdist);
                hlitlengths = new int[hlit];
                System.arraycopy(lengths, 0, hlitlengths, 0, hlit);
                lltable = new HuffmanTable(this, hlitlengths);
                hdistlengths = new int[hdist];
                System.arraycopy(lengths, hlit, hdistlengths, 0, hdist);
                dtable = new HuffmanTable(this, hdistlengths);
            }
            block5: while (true) {
                llcode = -1;
                if (btype == 1) {
                    code = this.readHuffmanBits(7);
                    if (code <= 23) {
                        llcode = 256 + code;
                    } else {
                        code <<= 1;
                        if ((code |= this.readBit()) < 192) {
                            llcode = code - 48;
                        } else if (code < 200) {
                            llcode = 280 + code - 192;
                        } else {
                            code <<= 1;
                            llcode = 144 + (code |= this.readBit()) - 400;
                        }
                    }
                } else if (btype == 2) {
                    llcode = lltable.readSymbol();
                }
                if (llcode < 256) {
                    this.emit(llcode);
                    continue;
                }
                if (llcode == 256) break;
                if (llcode > 285) continue;
                length = GZIPInputStream.lengthsTable[llcode - 257];
                extraLengthBits = GZIPInputStream.lengthExtraBitsTable[llcode - 257];
                if (extraLengthBits > 0) {
                    extra = this.readBits(extraLengthBits);
                    length += extra;
                }
                distanceCode = -1;
                if (btype == 1) {
                    distanceCode = this.readHuffmanBits(5);
                } else if (btype == 2) {
                    distanceCode = dtable.readSymbol();
                }
                distance = GZIPInputStream.distancesTable[distanceCode];
                extraDistBits = GZIPInputStream.distanceExtraBitsTable[distanceCode];
                if (extraDistBits > 0) {
                    extra = this.readBits(extraDistBits);
                    distance += extra;
                }
                i = 0;
                while (true) {
                    if (i < length) ** break;
                    continue block5;
                    this.emit(this.data[this.count - distance]);
                    ++i;
                }
                break;
            }
        }
        return bfinal == 1;
    }

    public int available() throws IOException {
        return this.count - this.idx;
    }

    public int read() throws IOException {
        if (this.idx == this.count) {
            return -1;
        }
        return this.data[this.idx++] & 0xFF;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            if (this.idx == this.count) {
                return i - off;
            }
            buf[i] = this.data[this.idx++];
        }
        return len;
    }

    public long skip(long n) throws IOException {
        int saveIdx = this.idx;
        this.idx = Math.min((int)((long)this.idx + n), this.count);
        return this.idx - saveIdx;
    }

    public void close() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    static {
        int i;
        perm = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
        lengthExtraBitsTable = new int[29];
        lengthsTable = new int[29];
        distanceExtraBitsTable = new int[30];
        distancesTable = new int[30];
        int idx = 0;
        for (int i2 = 4; i2 < 29; ++i2) {
            GZIPInputStream.lengthExtraBitsTable[i2] = idx++;
            if (i2 % 4 != 3) continue;
        }
        int len = 3;
        for (i = 0; i < lengthExtraBitsTable.length; ++i) {
            GZIPInputStream.lengthsTable[i] = len;
            len += 1 << lengthExtraBitsTable[i];
        }
        GZIPInputStream.lengthsTable[28] = 258;
        idx = 0;
        for (i = 2; i < 30; ++i) {
            GZIPInputStream.distanceExtraBitsTable[i] = idx++;
            if (i % 2 != 1) continue;
        }
        int code = 1;
        for (int i3 = 0; i3 < distancesTable.length; ++i3) {
            GZIPInputStream.distancesTable[i3] = code;
            code += 1 << distanceExtraBitsTable[i3];
        }
    }
}

