/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.NativeSurface;
import com.sun.pisces.Surface;
import com.sun.pisces.SurfaceDestination;
import javax.microedition.lcdui.Graphics;

public final class GraphicsSurfaceDestination
implements SurfaceDestination {
    private final Graphics g;

    public GraphicsSurfaceDestination(Graphics g) {
        this.g = g;
        this.initialize();
    }

    public void drawSurface(Surface ps, int srcX, int srcY, int dstX, int dstY, int width, int height, float opacity) {
        if (ps instanceof NativeSurface) {
            GraphicsSurfaceDestination.drawSurfaceImpl(this.g, (NativeSurface)ps, srcX, srcY, dstX, dstY, width, height, opacity);
            return;
        }
        int srcW = ps.getWidth();
        int srcH = ps.getHeight();
        if (srcX < 0) {
            dstX -= srcX;
            width += srcX;
            srcX = 0;
        }
        if (srcY < 0) {
            dstY -= srcY;
            height += srcY;
            srcY = 0;
        }
        if (srcX + width > srcW) {
            width = srcW - srcX;
        }
        if (srcY + height > srcH) {
            height = srcH - srcY;
        }
        if (width > 0 && height > 0 && opacity > 0.0f) {
            int size = width * height;
            int[] srcRGB = new int[size];
            ps.getRGB(srcRGB, 0, width, srcX, srcY, width, height);
            GraphicsSurfaceDestination.drawRGBImpl(this.g, srcRGB, 0, width, dstX, dstY, width, height, opacity);
        }
    }

    public void drawRGB(int[] argb, int offset, int scanLength, int x, int y, int width, int height, float opacity) {
        GraphicsSurfaceDestination.drawRGBImpl(this.g, argb, offset, scanLength, x, y, width, height, opacity);
    }

    private native void initialize();

    private static native void drawSurfaceImpl(Graphics var0, NativeSurface var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    private static native void drawRGBImpl(Graphics var0, int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);
}

