/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.GZIPInputStream;
import java.io.IOException;
import java.util.Hashtable;

class HuffmanTable {
    GZIPInputStream in;
    Hashtable codeTable;
    int minLen;

    public HuffmanTable(GZIPInputStream in, int[] lengths) {
        this.in = in;
        this.codeTable = HuffmanTable.buildHuffman(lengths);
        this.minLen = Integer.MAX_VALUE;
        for (int i = 0; i < lengths.length; ++i) {
            if (lengths[i] >= this.minLen) continue;
            this.minLen = lengths[i];
        }
    }

    private static Integer getKey(int code, int len) {
        return new Integer(code << 8 | len);
    }

    private static Hashtable buildHuffman(int[] tlen) {
        int len = tlen.length;
        int[] bl_count = new int[33];
        int[] next_code = new int[33];
        int maxlen = -1;
        for (int i = 0; i < len; ++i) {
            if (tlen[i] > maxlen) {
                maxlen = tlen[i];
            }
            int n = tlen[i];
            bl_count[n] = bl_count[n] + 1;
        }
        int code = 0;
        bl_count[0] = 0;
        for (int bits = 1; bits <= maxlen; ++bits) {
            next_code[bits] = code = code + bl_count[bits - 1] << 1;
        }
        Hashtable<Integer, Integer> codeTable = new Hashtable<Integer, Integer>(len);
        for (int n = 0; n < len; ++n) {
            int l = tlen[n];
            if (l == 0) continue;
            codeTable.put(HuffmanTable.getKey(next_code[l], l), new Integer(n));
            int n2 = l;
            next_code[n2] = next_code[n2] + 1;
        }
        return codeTable;
    }

    private int getVal(int code, int len) {
        Object o = this.codeTable.get(HuffmanTable.getKey(code, len));
        if (o != null) {
            return (Integer)o;
        }
        return -1;
    }

    public int readSymbol() throws IOException {
        int code = this.in.readHuffmanBits(this.minLen);
        int len = this.minLen;
        int val;
        while ((val = this.getVal(code, len)) == -1) {
            code = code << 1 | this.in.readBit();
            ++len;
        }
        return val;
    }
}

