/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.Surface;
import com.sun.pisces.SurfaceDestination;

public final class NativeSurface
implements Surface {
    private long nativePtr = 0L;

    public NativeSurface(int width, int height) {
        this.initialize(width, height);
    }

    public SurfaceDestination createSurfaceDestination() {
        return new NativeSurfaceDestination();
    }

    public native int getWidth();

    public native int getHeight();

    public native void getRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public native void setRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native void initialize(int var1, int var2);

    private native void drawSurfaceImpl(NativeSurface var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    private native void drawRGBImpl(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    private native void finalize();

    private class NativeSurfaceDestination
    implements SurfaceDestination {
        private NativeSurfaceDestination() {
        }

        public void drawSurface(Surface ps, int srcX, int srcY, int dstX, int dstY, int width, int height, float opacity) {
            if (ps instanceof NativeSurface) {
                NativeSurface.this.drawSurfaceImpl((NativeSurface)ps, srcX, srcY, dstX, dstY, width, height, opacity);
                return;
            }
            int srcW = ps.getWidth();
            int srcH = ps.getHeight();
            int dstW = NativeSurface.this.getWidth();
            int dstH = NativeSurface.this.getHeight();
            if (srcX < 0) {
                dstX -= srcX;
                width += srcX;
                srcX = 0;
            }
            if (srcY < 0) {
                dstY -= srcY;
                height += srcY;
                srcY = 0;
            }
            if (dstX < 0) {
                srcX -= dstX;
                width += dstX;
                dstX = 0;
            }
            if (dstY < 0) {
                srcY -= dstY;
                height += dstY;
                dstY = 0;
            }
            if (srcX + width > srcW) {
                width = srcW - srcX;
            }
            if (srcY + height > srcH) {
                height = srcH - srcY;
            }
            if (dstX + width > dstW) {
                width = dstW - dstX;
            }
            if (dstY + height > dstH) {
                height = dstH - dstY;
            }
            if (width > 0 && height > 0 && opacity > 0.0f) {
                int size = width * height;
                int[] srcRGB = new int[size];
                ps.getRGB(srcRGB, 0, width, srcX, srcY, width, height);
                NativeSurface.this.drawRGBImpl(srcRGB, 0, width, dstX, dstY, width, height, opacity);
            }
        }

        public void drawRGB(int[] argb, int offset, int scanLength, int x, int y, int width, int height, float opacity) {
            NativeSurface.this.drawRGBImpl(argb, offset, scanLength, x, y, width, height, opacity);
        }
    }
}

