/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.PathSink;
import com.sun.pisces.PathSource;

public class PathStore
extends PathSink
implements PathSource {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    static final byte MOVE_TO = 77;
    static final byte LINE_JOIN = 74;
    static final byte ABS_LINE_TO = 76;
    static final byte REL_LINE_TO_SHORT = 108;
    static final byte ABS_QUAD_TO = 81;
    static final byte REL_QUAD_TO_SHORT = 113;
    static final byte CUBIC_TO = 67;
    static final byte CLOSE = 122;
    static final byte END = 69;
    int numSegments = 0;
    int[] pathData;
    int dindex = 0;
    byte[] pathTypes;
    int tindex = 0;
    int x0;
    int y0;
    int sx0;
    int sy0;
    int xp;
    int yp;

    public PathStore() {
        this(1000);
    }

    public PathStore(int initialCapacity) {
        this.pathData = new int[initialCapacity];
        this.pathTypes = new byte[initialCapacity];
    }

    private void ensureCapacity(int elements) {
        if (this.dindex + elements > this.pathData.length) {
            int[] newPathData = new int[this.pathData.length + 512];
            System.arraycopy(this.pathData, 0, newPathData, 0, this.pathData.length);
            this.pathData = newPathData;
        }
        if (this.tindex + 1 > this.pathTypes.length) {
            byte[] newPathTypes = new byte[this.pathTypes.length + 512];
            System.arraycopy(this.pathTypes, 0, newPathTypes, 0, this.pathTypes.length);
            this.pathTypes = newPathTypes;
        }
    }

    private static boolean isShort(int x) {
        return x >= Short.MIN_VALUE && x <= Short.MAX_VALUE;
    }

    public void moveTo(int x0, int y0) {
        this.ensureCapacity(2);
        this.pathTypes[this.tindex++] = 77;
        this.pathData[this.dindex++] = x0;
        this.pathData[this.dindex++] = y0;
        this.sx0 = this.x0 = x0;
        this.sy0 = this.y0 = y0;
    }

    private int packShorts(int hi, int lo) {
        return hi << 16 | lo & 0xFFFF;
    }

    public void lineJoin() {
        this.ensureCapacity(0);
        this.pathTypes[this.tindex++] = 74;
    }

    public void lineTo(int x1, int y1) {
        int dx = x1 - this.x0;
        int dy = y1 - this.y0;
        if (PathStore.isShort(dx) && PathStore.isShort(dy)) {
            this.ensureCapacity(1);
            this.pathTypes[this.tindex++] = 108;
            this.pathData[this.dindex++] = this.packShorts(dx, dy);
        } else {
            this.ensureCapacity(2);
            this.pathTypes[this.tindex++] = 76;
            this.pathData[this.dindex++] = x1;
            this.pathData[this.dindex++] = y1;
        }
        this.x0 = x1;
        this.y0 = y1;
    }

    public void quadTo(int x1, int y1, int x2, int y2) {
        int dx1 = x1 - this.x0;
        int dy1 = y1 - this.y0;
        int dx2 = x2 - this.x0;
        int dy2 = y2 - this.y0;
        if (PathStore.isShort(dx1) && PathStore.isShort(dy1) && PathStore.isShort(dx2) && PathStore.isShort(dy2)) {
            this.ensureCapacity(2);
            this.pathTypes[this.tindex++] = 113;
            this.pathData[this.dindex++] = this.packShorts(dx1, dy1);
            this.pathData[this.dindex++] = this.packShorts(dx2, dy2);
        } else {
            this.ensureCapacity(4);
            this.pathTypes[this.tindex++] = 81;
            this.pathData[this.dindex++] = x1;
            this.pathData[this.dindex++] = y1;
            this.pathData[this.dindex++] = x2;
            this.pathData[this.dindex++] = y2;
        }
        this.xp = x1;
        this.yp = y1;
        this.x0 = x2;
        this.y0 = y2;
    }

    public void cubicTo(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.ensureCapacity(6);
        this.pathTypes[this.tindex++] = 67;
        this.pathData[this.dindex++] = x1;
        this.pathData[this.dindex++] = y1;
        this.pathData[this.dindex++] = x2;
        this.pathData[this.dindex++] = y2;
        this.pathData[this.dindex++] = x3;
        this.pathData[this.dindex++] = y3;
        this.x0 = x3;
        this.y0 = y3;
    }

    public void close() {
        this.ensureCapacity(0);
        this.pathTypes[this.tindex++] = 122;
        this.x0 = this.sx0;
        this.y0 = this.sy0;
    }

    public void end() {
        this.ensureCapacity(0);
        this.pathTypes[this.tindex++] = 69;
        this.x0 = 0;
        this.y0 = 0;
    }

    public void produce(PathSink consumer) {
        int tidx = 0;
        int didx = 0;
        int x0 = 0;
        int y0 = 0;
        int sx0 = 0;
        int sy0 = 0;
        while (tidx < this.tindex) {
            switch (this.pathTypes[tidx++]) {
                case 77: {
                    sx0 = x0 = this.pathData[didx++];
                    sy0 = y0 = this.pathData[didx++];
                    consumer.moveTo(x0, y0);
                    break;
                }
                case 74: {
                    consumer.lineJoin();
                    break;
                }
                case 76: {
                    x0 = this.pathData[didx++];
                    y0 = this.pathData[didx++];
                    consumer.lineTo(x0, y0);
                    break;
                }
                case 108: {
                    int dxdy = this.pathData[didx++];
                    consumer.lineTo(x0 += dxdy >> 16, y0 += dxdy << 16 >> 16);
                    break;
                }
                case 81: {
                    int n = didx++;
                    int n2 = didx++;
                    x0 = this.pathData[didx++];
                    y0 = this.pathData[didx++];
                    consumer.quadTo(this.pathData[n], this.pathData[n2], x0, y0);
                    break;
                }
                case 113: {
                    int dxdy1 = this.pathData[didx++];
                    int dxdy2 = this.pathData[didx++];
                    int x1 = x0 + (dxdy1 >> 16);
                    int y1 = y0 + (dxdy1 << 16 >> 16);
                    int x2 = x0 + (dxdy2 >> 16);
                    int y2 = y0 + (dxdy2 << 16 >> 16);
                    consumer.quadTo(x1, y1, x2, y2);
                    x0 = x2;
                    y0 = y2;
                    break;
                }
                case 67: {
                    int n = didx++;
                    int n3 = didx++;
                    int n4 = didx++;
                    int n5 = didx++;
                    x0 = this.pathData[didx++];
                    y0 = this.pathData[didx++];
                    consumer.cubicTo(this.pathData[n], this.pathData[n3], this.pathData[n4], this.pathData[n5], x0, y0);
                    break;
                }
                case 122: {
                    consumer.close();
                    x0 = sx0;
                    y0 = sy0;
                    break;
                }
                case 69: {
                    consumer.end();
                    x0 = 0;
                    y0 = 0;
                }
            }
        }
    }
}

