/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

public class PiscesMath {
    private static final int SINTAB_LG_ENTRIES = 10;
    private static final int SINTAB_ENTRIES = 1024;
    private static int[] sintab = new int[1025];
    public static final int PI = 205887;
    public static final int TWO_PI = 411774;
    public static final int PI_OVER_TWO = 102943;

    private PiscesMath() {
    }

    public static int sin(int theta) {
        int sign = 1;
        if (theta < 0) {
            theta = -theta;
            sign = -1;
        }
        while (theta >= 411774) {
            theta -= 411774;
        }
        if (theta >= 205887) {
            theta = 411774 - theta;
            sign = -sign;
        }
        if (theta > 102943) {
            theta = 205887 - theta;
        }
        int itheta = (int)((long)theta * 1024L / 102943L);
        return sign * sintab[itheta];
    }

    public static int cos(int theta) {
        return PiscesMath.sin(102943 - theta);
    }

    public static int isqrt(int x) {
        int fracbits = 16;
        int root = 0;
        int remHi = 0;
        int remLo = x;
        int count = 15 + fracbits / 2;
        do {
            remHi = remHi << 2 | remLo >>> 30;
            remLo <<= 2;
            int testdiv = ((root <<= 1) << 1) + 1;
            if (remHi < testdiv) continue;
            remHi -= testdiv;
            ++root;
        } while (count-- != 0);
        return root;
    }

    public static long lsqrt(long x) {
        int fracbits = 16;
        long root = 0L;
        long remHi = 0L;
        long remLo = x;
        int count = 31 + fracbits / 2;
        do {
            remHi = remHi << 2 | remLo >>> 62;
            remLo <<= 2;
            long testDiv = ((root <<= 1) << 1) + 1L;
            if (remHi < testDiv) continue;
            remHi -= testDiv;
            ++root;
        } while (count-- != 0);
        return root;
    }

    public static double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static int hypot(int x, int y) {
        return (int)(PiscesMath.lsqrt((long)x * (long)x + (long)y * (long)y) + 128L >> 8);
    }

    public static long hypot(long x, long y) {
        return PiscesMath.lsqrt(x * x + y * y) + 128L >> 8;
    }

    static {
        for (int i = 0; i < 1025; ++i) {
            double theta = (double)i * 1.5707963267948966 / 1024.0;
            PiscesMath.sintab[i] = (int)(Math.sin(theta) * 65536.0);
        }
    }
}

