/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.midp.main.Configuration;
import com.sun.pisces.GradientColorMap;
import com.sun.pisces.NativeSurface;
import com.sun.pisces.PathSink;
import com.sun.pisces.Transform6;

public final class PiscesRenderer
extends PathSink {
    private static boolean messageShown = false;
    public static final int ARC_OPEN = 0;
    public static final int ARC_CHORD = 1;
    public static final int ARC_PIE = 2;
    long nativePtr = 0L;
    int[] gcm_fractions = null;
    int[] gcm_rgba = null;
    int gcm_cycleMethod = -1;
    GradientColorMap gradientColorMap = null;

    private void notImplemented() {
        new RuntimeException().printStackTrace();
        System.out.println("not implemented");
    }

    public PiscesRenderer(Object data, int width, int height, int offset, int scanlineStride, int pixelStride, int type) {
        if (!messageShown) {
            System.out.println("Using Pisces Renderer (native version)");
        }
        if (!(data instanceof NativeSurface)) {
            throw new IllegalArgumentException();
        }
        this.initialize((NativeSurface)data, type);
        messageShown = true;
    }

    private static native void staticInitialize(int var0, int var1);

    private native void initialize(NativeSurface var1, int var2);

    public native void setAntialiasing(boolean var1);

    public native boolean getAntialiasing();

    public native void setColor(int var1, int var2, int var3, int var4);

    public void setColor(int red, int green, int blue) {
        this.setColor(red, green, blue, 255);
    }

    private boolean arraysDiffer(int[] a, int[] b) {
        if (a == null) {
            return true;
        }
        int len = b.length;
        if (a.length != len) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (a[i] == b[i]) continue;
            return true;
        }
        return false;
    }

    private int[] cloneArray(int[] src) {
        int len = src.length;
        int[] dst = new int[len];
        System.arraycopy(src, 0, dst, 0, len);
        return dst;
    }

    private void setGradientColorMap(int[] fractions, int[] rgba, int cycleMethod) {
        if (fractions.length != rgba.length) {
            throw new IllegalArgumentException("fractions.length != rgba.length!");
        }
        if (this.gradientColorMap == null || this.gcm_cycleMethod != cycleMethod || this.arraysDiffer(this.gcm_fractions, fractions) || this.arraysDiffer(this.gcm_rgba, rgba)) {
            this.gradientColorMap = new GradientColorMap(fractions, rgba, cycleMethod);
            this.gcm_cycleMethod = cycleMethod;
            this.gcm_fractions = this.cloneArray(fractions);
            this.gcm_rgba = this.cloneArray(rgba);
        }
    }

    private native void setLinearGradientImpl(int var1, int var2, int var3, int var4, int[] var5, int var6, Transform6 var7);

    public void setLinearGradient(int x0, int y0, int x1, int y1, int[] fractions, int[] rgba, int cycleMethod, Transform6 gradientTransform) {
        this.setGradientColorMap(fractions, rgba, cycleMethod);
        this.setLinearGradientImpl(x0, y0, x1, y1, this.gradientColorMap.colors, cycleMethod, gradientTransform);
    }

    private native void setRadialGradientImpl(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7, Transform6 var8);

    public void setRadialGradient(int cx, int cy, int fx, int fy, int radius, int[] fractions, int[] rgba, int cycleMethod, Transform6 gradientTransform) {
        this.setGradientColorMap(fractions, rgba, cycleMethod);
        this.setRadialGradientImpl(cx, cy, fx, fy, radius, this.gradientColorMap.colors, cycleMethod, gradientTransform);
    }

    public void setTexture(int imageType, Object imageData, int width, int height, int offset, int stride, Transform6 textureTransform, boolean repeat) {
        if (imageData instanceof int[]) {
            this.setTextureImpl(imageType, (int[])imageData, width, height, offset, stride, textureTransform, repeat);
        }
    }

    private native void setTextureImpl(int var1, int[] var2, int var3, int var4, int var5, int var6, Transform6 var7, boolean var8);

    public PathSink getStroker() {
        this.notImplemented();
        return null;
    }

    public PathSink getFiller() {
        this.notImplemented();
        return null;
    }

    public PathSink getTextFiller() {
        this.notImplemented();
        return null;
    }

    public native void setStroke(int var1, int var2, int var3, int var4, int[] var5, int var6);

    public native void setTransform(Transform6 var1);

    public Transform6 getTransform() {
        Transform6 transform = new Transform6();
        this.getTransformImpl(transform);
        return transform;
    }

    private native void getTransformImpl(Transform6 var1);

    public native void setClip(int var1, int var2, int var3, int var4);

    public native void resetClip();

    public native void beginRendering(int var1);

    public native void beginRendering(int var1, int var2, int var3, int var4, int var5);

    public native void endRendering();

    public native void getBoundingBox(int[] var1);

    public native void setStroke();

    public native void setFill();

    public void setTextFill() {
        this.notImplemented();
    }

    public native void moveTo(int var1, int var2);

    public native void lineTo(int var1, int var2);

    public native void lineJoin();

    public native void quadTo(int var1, int var2, int var3, int var4);

    public native void cubicTo(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void close();

    public native void end();

    public native void drawLine(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void getImageData() {
        this.notImplemented();
    }

    public native void clearRect(int var1, int var2, int var3, int var4);

    private native void finalize();

    public native void setPathData(float[] var1, byte[] var2, int var3);

    static {
        int strokeXBias = 0;
        int strokeYBias = 0;
        String strValue = Configuration.getProperty("pisces.stroke.xbias");
        if (strValue != null) {
            try {
                strokeXBias = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((strValue = Configuration.getProperty("pisces.stroke.ybias")) != null) {
            try {
                strokeYBias = Integer.parseInt(strValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        PiscesRenderer.staticInitialize(strokeXBias, strokeYBias);
    }
}

