/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.PathSink;
import com.sun.pisces.Transform6;

public class Transformer
extends PathSink {
    PathSink output;
    long m00;
    long m01;
    long m02;
    long m10;
    long m11;
    long m12;
    boolean scaleAndTranslate;

    public Transformer() {
    }

    public Transformer(PathSink output, Transform6 transform) {
        if (output instanceof Transformer) {
            Transformer t = (Transformer)output;
            this.output = t.output;
            this.m00 = (long)transform.m00 * t.m00 + (long)transform.m10 * t.m01 >> 16;
            this.m01 = (long)transform.m01 * t.m00 + (long)transform.m11 * t.m01 >> 16;
            this.m10 = (long)transform.m00 * t.m10 + (long)transform.m10 * t.m11 >> 16;
            this.m11 = (long)transform.m01 * t.m10 + (long)transform.m11 * t.m11 >> 16;
            this.m02 = (long)transform.m02 * t.m00 + (long)transform.m12 * t.m01 + t.m02;
            this.m12 = (long)transform.m02 * t.m10 + (long)transform.m12 * t.m11 + t.m12;
        } else {
            this.output = output;
            this.setTransform(transform);
        }
        this.classify();
    }

    public void setTransform(Transform6 transform) {
        this.m00 = transform.m00;
        this.m01 = transform.m01;
        this.m02 = (long)transform.m02 << 16;
        this.m10 = transform.m10;
        this.m11 = transform.m11;
        this.m12 = (long)transform.m12 << 16;
        this.classify();
    }

    private void classify() {
        this.scaleAndTranslate = this.m01 == 0L && this.m10 == 0L;
    }

    public void setOutput(PathSink output) {
        this.output = output;
    }

    public void moveTo(int x0, int y0) {
        long ty0;
        long tx0;
        if (this.scaleAndTranslate) {
            tx0 = this.m00 * (long)x0 + this.m02;
            ty0 = this.m11 * (long)y0 + this.m12;
        } else {
            tx0 = this.m00 * (long)x0 + this.m01 * (long)y0 + this.m02;
            ty0 = this.m10 * (long)x0 + this.m11 * (long)y0 + this.m12;
        }
        this.output.moveTo((int)(tx0 >> 16), (int)(ty0 >> 16));
    }

    public void lineJoin() {
        this.output.lineJoin();
    }

    public void lineTo(int x1, int y1) {
        long ty1;
        long tx1;
        if (this.scaleAndTranslate) {
            tx1 = this.m00 * (long)x1 + this.m02;
            ty1 = this.m11 * (long)y1 + this.m12;
        } else {
            tx1 = this.m00 * (long)x1 + this.m01 * (long)y1 + this.m02;
            ty1 = this.m10 * (long)x1 + this.m11 * (long)y1 + this.m12;
        }
        this.output.lineTo((int)(tx1 >> 16), (int)(ty1 >> 16));
    }

    public void quadTo(int x1, int y1, int x2, int y2) {
        long ty2;
        long tx2;
        long ty1;
        long tx1;
        if (this.scaleAndTranslate) {
            tx1 = this.m00 * (long)x1 + this.m02;
            ty1 = this.m11 * (long)y1 + this.m12;
            tx2 = this.m00 * (long)x2 + this.m02;
            ty2 = this.m11 * (long)y2 + this.m12;
        } else {
            tx1 = this.m00 * (long)x1 + this.m01 * (long)y1 + this.m02;
            ty1 = this.m10 * (long)x1 + this.m11 * (long)y1 + this.m12;
            tx2 = this.m00 * (long)x2 + this.m01 * (long)y2 + this.m02;
            ty2 = this.m10 * (long)x2 + this.m11 * (long)y2 + this.m12;
        }
        this.output.quadTo((int)(tx1 >> 16), (int)(ty1 >> 16), (int)(tx2 >> 16), (int)(ty2 >> 16));
    }

    public void cubicTo(int x1, int y1, int x2, int y2, int x3, int y3) {
        long ty3;
        long tx3;
        long ty2;
        long tx2;
        long ty1;
        long tx1;
        if (this.scaleAndTranslate) {
            tx1 = this.m00 * (long)x1 + this.m02;
            ty1 = this.m11 * (long)y1 + this.m12;
            tx2 = this.m00 * (long)x2 + this.m02;
            ty2 = this.m11 * (long)y2 + this.m12;
            tx3 = this.m00 * (long)x3 + this.m02;
            ty3 = this.m11 * (long)y3 + this.m12;
        } else {
            tx1 = this.m00 * (long)x1 + this.m01 * (long)y1 + this.m02;
            ty1 = this.m10 * (long)x1 + this.m11 * (long)y1 + this.m12;
            tx2 = this.m00 * (long)x2 + this.m01 * (long)y2 + this.m02;
            ty2 = this.m10 * (long)x2 + this.m11 * (long)y2 + this.m12;
            tx3 = this.m00 * (long)x3 + this.m01 * (long)y3 + this.m02;
            ty3 = this.m10 * (long)x3 + this.m11 * (long)y3 + this.m12;
        }
        this.output.cubicTo((int)(tx1 >> 16), (int)(ty1 >> 16), (int)(tx2 >> 16), (int)(ty2 >> 16), (int)(tx3 >> 16), (int)(ty3 >> 16));
    }

    public void close() {
        this.output.close();
    }

    public void end() {
        this.output.end();
    }
}

