/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.siplite.parser.Lexer;

public class Host {
    protected static final int HOSTNAME = 1;
    protected static final int IPV4ADDRESS = 2;
    protected static final int IPV6ADDRESS = 3;
    protected String hostname;
    protected int addressType;

    public Host() {
        this.addressType = 1;
    }

    public Host(String newHostName) throws IllegalArgumentException {
        this.setHostname(newHostName);
    }

    public String encode() {
        if (this.addressType == 3 && '[' != this.hostname.charAt(0)) {
            return "[" + this.hostname + "]";
        }
        return this.hostname;
    }

    public boolean equals(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Host otherHost = (Host)obj;
        return otherHost.hostname.equals(this.hostname);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getAddress() {
        return this.hostname;
    }

    public void setHostname(String h) throws IllegalArgumentException {
        if (h == null) {
            throw new IllegalArgumentException("Null address");
        }
        if (Lexer.isValidIpv4Address(h = h.trim().toLowerCase())) {
            this.addressType = 2;
        } else if (Lexer.isValidHostname(h)) {
            this.addressType = 1;
        } else {
            String addr = h;
            if (h.charAt(0) == '[' && h.charAt(h.length() - 1) == ']') {
                addr = h.substring(1, h.length() - 1);
            }
            if (!Lexer.isValidIpv6Address(addr)) {
                throw new IllegalArgumentException("Illegal hostname " + addr);
            }
        }
        this.hostname = h;
    }

    public void setAddress(String address) throws IllegalArgumentException {
        this.setHostname(address);
    }

    public boolean isHostname() {
        return this.addressType == 1;
    }

    public boolean isIPAddress() {
        return this.addressType != 1;
    }

    public Object clone() {
        Host retval = new Host();
        retval.addressType = this.addressType;
        retval.hostname = new String(this.hostname);
        return retval;
    }
}

