/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LexerCore;
import gov.nist.core.ParseException;
import gov.nist.core.ParserCore;
import gov.nist.core.StringTokenizer;

public class HostNameParser
extends ParserCore {
    public HostNameParser(LexerCore lexer) {
        this.lexer = lexer;
        lexer.selectLexer("charLexer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String domainLabel() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            if (LexerCore.isAlpha(la)) {
                this.lexer.consume(1);
                retval.append(la);
                continue;
            }
            if (LexerCore.isDigit(la)) {
                this.lexer.consume(1);
                retval.append(la);
                continue;
            }
            if (la != '-') break;
            this.lexer.consume(1);
            retval.append(la);
        }
        if (retval.length() == 0) {
            throw new ParseException("Error parsing domain label  " + this.lexer.getBuffer(), this.lexer.getPtr());
        }
        String string = retval.toString();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String ipv6Reference() throws ParseException {
        char la;
        StringBuffer retval;
        block5: {
            retval = new StringBuffer();
            while (this.lexer.hasMoreChars()) {
                la = this.lexer.lookAhead(0);
                if (LexerCore.isHexDigit(la)) {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                if (la == '.' || la == ':' || la == '[') {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                break block5;
            }
            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        }
        if (la != ']') throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        this.lexer.consume(1);
        retval.append(la);
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hostName() throws ParseException {
        StringBuffer hname = new StringBuffer();
        if (this.lexer.lookAhead(0) == '[') {
            hname.append(this.ipv6Reference());
        } else {
            String nextTok = this.domainLabel();
            hname.append(nextTok);
            while (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == '.') {
                this.lexer.consume(1);
                nextTok = this.domainLabel();
                hname.append(".");
                hname.append(nextTok);
            }
        }
        String string = hname.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPort hostPort() throws ParseException {
        int m = this.lexer.markInputPosition();
        String hostName = this.hostName();
        Host host = new Host();
        HostPort hp = new HostPort();
        boolean parsePort = false;
        if (StringTokenizer.isDigitString(hostName)) {
            this.lexer.rewindInputPosition(m);
            parsePort = true;
        } else {
            host.setHostname(hostName);
        }
        hp.setHost(host);
        this.lexer.SPorHT();
        if (!parsePort && this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == ':') {
            this.lexer.consume(1);
            this.lexer.SPorHT();
            parsePort = true;
        }
        if (parsePort) {
            HostNameParser.parsePort(this.lexer, hp);
        }
        HostPort hostPort = hp;
        return hostPort;
    }

    public static void parsePort(LexerCore lexer, HostPort hp) throws ParseException {
        try {
            String port = lexer.number();
            if (port.length() == 0) {
                throw new ParseException("Port format error", lexer.getPtr());
            }
            hp.setPort(Integer.parseInt(port));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(lexer.getBuffer() + " :Error parsing port ", lexer.getPtr());
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException(iae.getMessage(), lexer.getPtr());
        }
    }
}

