/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;

public class NameValue
extends GenericObject {
    protected boolean isQuotedString;
    protected String separator;
    protected String quotes;
    protected String name;
    protected Object value;

    public NameValue() {
        this.name = null;
        this.value = null;
        this.separator = "=";
        this.quotes = "";
    }

    public NameValue(String n, Object v) {
        this.name = n;
        this.separator = "=";
        this.quotes = "";
        this.setValue(v);
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public void setQuotedValue() {
        this.isQuotedString = true;
        this.quotes = "\"";
    }

    public boolean isValueQuoted() {
        return this.isQuotedString;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.isValueQuoted()) {
            return "\"" + this.value + "\"";
        }
        return this.value;
    }

    public Object getUnquotedValue() {
        return this.value;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setValue(Object v) {
        String str;
        this.value = v;
        if (this.value != null && this.value instanceof String && (str = (String)this.value).startsWith("\"") && str.endsWith("\"")) {
            this.setQuotedValue();
            str = str.substring(1, str.length() - 1);
            this.value = str;
        }
    }

    public String encode() {
        if (this.name != null && this.value != null) {
            return this.name + this.separator + this.quotes + this.value.toString() + this.quotes;
        }
        if (this.name == null && this.value != null) {
            return this.quotes + this.value.toString() + this.quotes;
        }
        if (this.name != null && this.value == null) {
            return this.name;
        }
        return "";
    }

    public Object clone() {
        NameValue retval = new NameValue();
        retval.separator = this.separator;
        retval.isQuotedString = this.isQuotedString;
        retval.quotes = this.quotes;
        retval.name = this.name;
        retval.value = this.value != null && this.value instanceof GenericObject ? ((GenericObject)this.value).clone() : this.value;
        return retval;
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        NameValue that = (NameValue)other;
        if (this == that) {
            return true;
        }
        if (this.name == null && that.name != null || this.name != null && that.name == null) {
            return false;
        }
        if (this.name != null && that.name != null && this.name.toLowerCase().compareTo(that.name.toLowerCase()) != 0) {
            return false;
        }
        if (this.value != null && that.value == null || this.value == null && that.value != null) {
            return false;
        }
        if (this.value == that.value) {
            return true;
        }
        if (this.value instanceof String) {
            if (this.isQuotedString) {
                return this.value.equals(that.value);
            }
            String val = (String)this.value;
            String val1 = (String)that.value;
            return val.toLowerCase().equals(val1.toLowerCase());
        }
        return this.value.equals(that.value);
    }

    public String toString() {
        return this.encode();
    }
}

