/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.GenericObject;
import gov.nist.core.NameValue;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NameValueList
extends GenericObject {
    private Hashtable nvList = new Hashtable();
    private String separator = ";";

    public NameValueList(String listName) {
    }

    public Vector getNames() {
        Vector names = new Vector();
        Enumeration enumNames = this.nvList.keys();
        while (enumNames.hasMoreElements()) {
            names.addElement(enumNames.nextElement());
        }
        return names;
    }

    public Enumeration getKeys() {
        return this.nvList.keys();
    }

    public void add(NameValue nv) {
        if (nv == null) {
            throw new NullPointerException("null nv");
        }
        this.nvList.put(nv.getName(), nv.getValue());
    }

    public void set(NameValue nv) {
        this.add(nv);
    }

    public void set(String name, Object value) {
        NameValue nv = new NameValue(name, value);
        this.set(nv);
    }

    public void add(String name, Object obj) {
        if (name == null) {
            throw new NullPointerException("name in null ! ");
        }
        NameValue nv = new NameValue(name, obj);
        this.add(nv);
    }

    public boolean equals(Object otherObject) {
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        NameValueList other = (NameValueList)otherObject;
        if (this.nvList.size() != other.nvList.size()) {
            return false;
        }
        Enumeration enumNames = this.nvList.keys();
        while (enumNames.hasMoreElements()) {
            String currKey = (String)enumNames.nextElement();
            Object currValue = this.nvList.get(currKey);
            Object currValueOther = other.nvList.get(currKey);
            if (currValueOther != null && currValue.equals(currValueOther)) continue;
            return false;
        }
        return true;
    }

    public Object getValue(String name) {
        return this.nvList.get(name.toLowerCase());
    }

    public String getValueDefault(String name, String nameDefault) {
        String returnValue = (String)this.nvList.get(name.toLowerCase());
        if (returnValue == null) {
            returnValue = nameDefault;
        }
        return returnValue;
    }

    public NameValue getNameValue(String name) {
        if (name == null) {
            throw new NullPointerException("null arg!");
        }
        String name1 = name.toLowerCase();
        NameValue returnValue = null;
        Object value = this.getValue(name1);
        if (value != null) {
            returnValue = new NameValue(name1, value);
        }
        return returnValue;
    }

    public boolean hasNameValue(String name) {
        return this.nvList.containsKey(name.toLowerCase());
    }

    public boolean delete(String name) {
        if (name == null) {
            return true;
        }
        String name1 = name.toLowerCase();
        this.nvList.remove(name1);
        return true;
    }

    public NameValueList() {
    }

    public Object clone() {
        NameValueList retval = new NameValueList();
        retval.separator = this.separator;
        Enumeration enumNames = this.nvList.keys();
        while (enumNames.hasMoreElements()) {
            String currKey = (String)enumNames.nextElement();
            retval.add(currKey, this.nvList.get(currKey));
        }
        return retval;
    }

    public String getParameter(String name) {
        Object val = this.getValue(name);
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public String encode() {
        if (this.nvList.size() == 0) {
            return "";
        }
        StringBuffer encoding = new StringBuffer();
        Enumeration enumNames = this.nvList.keys();
        while (enumNames.hasMoreElements()) {
            String currKey = (String)enumNames.nextElement();
            encoding.append(currKey);
            Object currValue = this.nvList.get(currKey);
            if (currValue != null) {
                if (currValue instanceof GenericObject) {
                    GenericObject gobj = (GenericObject)currValue;
                    encoding.append("=" + gobj.encode());
                } else {
                    String s = currValue.toString();
                    if (s.length() > 0) {
                        encoding.append("=" + s);
                    }
                }
            }
            if (!enumNames.hasMoreElements()) continue;
            encoding.append(this.separator);
        }
        return encoding.toString();
    }

    public String toString() {
        return this.encode();
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isEmpty() {
        return this.nvList.size() == 0;
    }

    public int size() {
        return this.nvList.size();
    }
}

