/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.ParseException;
import java.util.Vector;

public class StringTokenizer {
    protected String buffer;
    protected int ptr;
    protected int savedPtr;
    char delimiter;

    public StringTokenizer() {
        this.delimiter = (char)10;
        this.ptr = 0;
    }

    public StringTokenizer(String buffer) {
        this.buffer = buffer;
        this.ptr = 0;
        this.delimiter = (char)10;
    }

    public StringTokenizer(String buffer, char delimiter) {
        this.buffer = buffer;
        this.delimiter = delimiter;
        this.ptr = 0;
    }

    public String nextToken() {
        StringBuffer retval = new StringBuffer();
        while (this.ptr < this.buffer.length()) {
            if (this.buffer.charAt(this.ptr) == this.delimiter) {
                retval.append(this.buffer.charAt(this.ptr));
                ++this.ptr;
                break;
            }
            retval.append(this.buffer.charAt(this.ptr));
            ++this.ptr;
        }
        return retval.toString();
    }

    public boolean hasMoreChars() {
        return this.ptr < this.buffer.length();
    }

    public static boolean isHexDigit(char ch) {
        if (StringTokenizer.isDigit(ch)) {
            return true;
        }
        char ch1 = Character.toUpperCase(ch);
        return ch1 == 'A' || ch1 == 'B' || ch1 == 'C' || ch1 == 'D' || ch1 == 'E' || ch1 == 'F';
    }

    public static boolean isAlpha(char ch) {
        boolean retval = Character.isUpperCase(ch) || Character.isLowerCase(ch);
        return retval;
    }

    public static boolean isDigit(char ch) {
        boolean retval = Character.isDigit(ch);
        return retval;
    }

    public static boolean isDigitString(String str) {
        int len = str.length();
        if (len == 0) {
            return false;
        }
        boolean retval = true;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            retval = false;
            break;
        }
        return retval;
    }

    public static boolean isValidChar(char ch) {
        String validChars = "-.!%*_+`'~";
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || validChars.indexOf(ch) != -1;
    }

    public static boolean isEscaped(String name, int index) {
        return name.charAt(index) == '%' && name.length() - index - 2 >= 0 && StringTokenizer.isHexDigit(name.charAt(index + 1)) && StringTokenizer.isHexDigit(name.charAt(index + 2));
    }

    public static boolean isQuotedPair(String name, int offset) {
        if (name.charAt(offset) != '\\' || name.length() - offset - 1 <= 0) {
            return false;
        }
        char ch = name.charAt(offset + 1);
        return ch != '\n' && ch != '\r' && ch <= '\u007f';
    }

    public String getLine() {
        StringBuffer retval = new StringBuffer();
        while (this.ptr < this.buffer.length() && this.buffer.charAt(this.ptr) != '\n') {
            retval.append(this.buffer.charAt(this.ptr));
            ++this.ptr;
        }
        if (this.ptr < this.buffer.length() && this.buffer.charAt(this.ptr) == '\n') {
            retval.append('\n');
            ++this.ptr;
        }
        return retval.toString();
    }

    public String peekLine() {
        int curPos = this.ptr;
        String retval = this.getLine();
        this.ptr = curPos;
        return retval;
    }

    public char lookAhead() throws ParseException {
        return this.lookAhead(0);
    }

    public char lookAhead(int k) throws ParseException {
        if (this.ptr + k < this.buffer.length()) {
            return this.buffer.charAt(this.ptr + k);
        }
        return '\u0000';
    }

    public char getNextChar() throws ParseException {
        if (this.ptr >= this.buffer.length()) {
            throw new ParseException(this.buffer + " getNextChar: End of buffer", this.ptr);
        }
        return this.buffer.charAt(this.ptr++);
    }

    public void consume() {
        this.ptr = this.savedPtr;
    }

    public void consume(int k) {
        this.ptr += k;
    }

    public Vector getLines() {
        Vector<String> result = new Vector<String>();
        while (this.hasMoreChars()) {
            String line = this.getLine();
            result.addElement(line);
        }
        return result;
    }

    public String getNextToken(char delim) throws ParseException {
        char la;
        StringBuffer retval = new StringBuffer();
        while ((la = this.lookAhead(0)) != delim) {
            if (la == '\u0000') {
                throw new ParseException("EOL reached", 0);
            }
            retval.append(this.buffer.charAt(this.ptr));
            this.consume(1);
        }
        return retval.toString();
    }

    public static String getSDPFieldName(String line) {
        if (line == null) {
            return null;
        }
        String fieldName = null;
        try {
            int begin = line.indexOf("=");
            fieldName = line.substring(0, begin);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return fieldName;
    }

    public static String convertNewLines(String s) {
        String result = "";
        if (s.length() == 0) {
            return result;
        }
        int i = 0;
        for (i = StringTokenizer.skipWhiteSpace(s, i); i < s.length(); ++i) {
            char chCurr = s.charAt(i);
            if (chCurr == '\n' || chCurr == '\r') {
                if (i >= s.length() - 1 || s.charAt(i + 1) != '\t' && s.charAt(i + 1) != ' ') continue;
                result = result + ' ';
                ++i;
                continue;
            }
            result = result + chCurr;
        }
        return result;
    }

    private static int skipWhiteSpace(String s, int i) {
        int len = s.length();
        if (i >= len) {
            return i;
        }
        char chCurr = s.charAt(i);
        while ((chCurr == '\n' || chCurr == '\r' || chCurr == '\t' || chCurr == ' ') && ++i < len) {
            chCurr = s.charAt(i);
        }
        return i;
    }
}

