/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import gov.nist.microedition.sip.RefreshTask;
import gov.nist.siplite.message.Request;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.sip.SipClientConnection;
import javax.microedition.sip.SipConnectionNotifier;
import javax.microedition.sip.SipRefreshListener;

public class RefreshManager {
    private static RefreshManager instance = null;
    private Hashtable refreshTable = new Hashtable();
    private int idGenerator = 0;

    private RefreshManager() {
    }

    public static synchronized RefreshManager getInstance() {
        if (instance == null) {
            instance = new RefreshManager();
        }
        return instance;
    }

    public int createRefreshTask(Request request, SipConnectionNotifier sipConnectionNotifier, SipRefreshListener sipRefreshListener, SipClientConnection sipClientConnection) {
        int taskId = ++this.idGenerator;
        RefreshTask refreshTask = new RefreshTask(String.valueOf(taskId), request, sipConnectionNotifier, sipRefreshListener, sipClientConnection);
        this.refreshTable.put(String.valueOf(taskId), refreshTask);
        return taskId;
    }

    public void scheduleTask(String taskId, int expires) {
        RefreshTask refreshTask = (RefreshTask)this.refreshTable.get(taskId);
        if (refreshTask == null) {
            return;
        }
        if (expires == -1) {
            return;
        }
        if (expires >= 0) {
            Timer timer = new Timer();
            refreshTask = new RefreshTask(refreshTask.getTaskId(), refreshTask.getRequest(), refreshTask.getSipConnectionNotifier(), refreshTask.getSipRefreshListener(), refreshTask.getSipClientConnection());
            this.refreshTable.put(taskId, refreshTask);
            timer.schedule((TimerTask)refreshTask, expires * 1000);
        }
    }

    public RefreshTask getTask(String taskId) {
        return (RefreshTask)this.refreshTable.get(taskId);
    }

    public void removeTask(String taskId) {
        this.refreshTable.remove(taskId);
    }
}

