/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import gov.nist.core.ParseException;
import gov.nist.microedition.sip.SipClientConnectionImpl;
import gov.nist.microedition.sip.SipConnectionNotifierImpl;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.message.Request;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.sip.SipClientConnection;
import javax.microedition.sip.SipConnectionNotifier;
import javax.microedition.sip.SipException;
import javax.microedition.sip.SipRefreshListener;

public class RefreshTask
extends TimerTask {
    private Request request = null;
    private SipClientConnection sipClientConnection = null;
    private SipConnectionNotifier sipConnectionNotifier = null;
    private SipRefreshListener sipRefreshListener;
    private String taskId;

    public RefreshTask(String id, Request rq, SipConnectionNotifier scn, SipRefreshListener listener, SipClientConnection scc) {
        this.taskId = id;
        this.request = rq;
        this.sipConnectionNotifier = scn;
        this.sipRefreshListener = listener;
        this.sipClientConnection = scc;
    }

    public void run() {
        Request clonedRequest = (Request)this.request.clone();
        this.request = null;
        try {
            this.updateAndSendRequest(clonedRequest);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setRequestHeaders(Request clonedRequest) {
        CSeqHeader cseq = clonedRequest.getCSeqHeader();
        if (cseq != null) {
            cseq.setSequenceNumber(cseq.getSequenceNumber() + 1);
        }
        clonedRequest.removeHeader("Via");
        Vector<ViaHeader> viaHeaders = new Vector<ViaHeader>();
        try {
            ViaHeader viaHeader = StackConnector.headerFactory.createViaHeader(this.sipConnectionNotifier.getLocalAddress(), this.sipConnectionNotifier.getLocalPort(), ((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getListeningPoint().getTransport(), null);
            viaHeaders.addElement(viaHeader);
        }
        catch (ParseException ex) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            clonedRequest.setVia(viaHeaders);
        }
        catch (SipException ex) {
            // empty catch block
        }
    }

    public SipRefreshListener getSipRefreshListener() {
        return this.sipRefreshListener;
    }

    public SipConnectionNotifier getSipConnectionNotifier() {
        return this.sipConnectionNotifier;
    }

    public SipClientConnection getSipClientConnection() {
        return this.sipClientConnection;
    }

    public synchronized void updateAndSendRequest(Request updatedRequest) throws IOException, InterruptedIOException, SipException {
        this.request = updatedRequest;
        this.setRequestHeaders(this.request);
        ((SipClientConnectionImpl)this.sipClientConnection).updateAndSendRequestFromRefresh(this.request);
    }

    public synchronized OutputStream updateRequestAndOpenOutputStream(Request updatedRequest) throws IOException, SipException {
        this.request = updatedRequest;
        this.setRequestHeaders(this.request);
        return ((SipClientConnectionImpl)this.sipClientConnection).updateRequestAndOpenOutputStream(this.request);
    }

    public CallIdHeader getNewCallId() {
        return ((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getNewCallId();
    }

    public synchronized Request getRequest() {
        return this.request;
    }

    public String getTaskId() {
        return this.taskId;
    }
}

