/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import gov.nist.microedition.sip.SipClientConnectionImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.sip.SipConnection;

public class SDPOutputStream
extends OutputStream {
    private SipConnection connection = null;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private boolean isOpen;

    public SDPOutputStream(SipConnection connection) {
        this.connection = connection;
        this.setOpen(true);
    }

    public String toString() {
        return super.toString() + " isOpen=" + this.isOpen;
    }

    protected ByteArrayOutputStream getByteArrayOutputStream() {
        return this.outputStream;
    }

    private void checkOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("the output stream has been closed");
        }
    }

    public void write(int b) throws IOException {
        this.checkOpen();
        this.outputStream.write(b);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void write(byte[] b) throws IOException {
        this.checkOpen();
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        this.outputStream.write(b, off, len);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected void setOpen(boolean newOpenState) {
        this.isOpen = newOpenState;
    }

    public void close() throws IOException {
        if (!this.isOpen) {
            throw new IOException("stream already closed");
        }
        this.setOpen(false);
        this.outputStream.close();
        if (this.connection instanceof SipClientConnectionImpl) {
            SipClientConnectionImpl sipClientConnection = (SipClientConnectionImpl)this.connection;
            if (sipClientConnection.state == 3 && sipClientConnection.getMethod().equals("ACK")) {
                sipClientConnection.state = 6;
                try {
                    super.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                return;
            }
        }
        try {
            this.connection.send();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        try {
            super.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

