/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import com.sun.kvem.netmon.NetMonProxy;
import com.sun.midp.security.SecurityToken;
import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.microedition.sip.IncomingQueueElement;
import gov.nist.microedition.sip.RefreshManager;
import gov.nist.microedition.sip.SDPOutputStream;
import gov.nist.microedition.sip.SipConnectionNotifierImpl;
import gov.nist.microedition.sip.SipDialogImpl;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.SIPUtils;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.TransactionUnavailableException;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.header.ContentLengthHeader;
import gov.nist.siplite.header.ContentTypeHeader;
import gov.nist.siplite.header.ExpiresHeader;
import gov.nist.siplite.header.FromHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.HeaderList;
import gov.nist.siplite.header.MaxForwardsHeader;
import gov.nist.siplite.header.ParameterLessHeader;
import gov.nist.siplite.header.SubscriptionStateHeader;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.stack.ClientTransaction;
import gov.nist.siplite.stack.Subscription;
import gov.nist.siplite.stack.authentication.Credentials;
import gov.nist.siplite.stack.authentication.DigestClientAuthentication;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.sip.SipClientConnection;
import javax.microedition.sip.SipClientConnectionListener;
import javax.microedition.sip.SipConnection;
import javax.microedition.sip.SipConnectionNotifier;
import javax.microedition.sip.SipDialog;
import javax.microedition.sip.SipException;
import javax.microedition.sip.SipRefreshListener;

public class SipClientConnectionImpl
implements SipClientConnection {
    private SecurityToken classSecurityToken;
    private int md;
    public static final int TERMINATED = 0;
    public static final int CREATED = 1;
    public static final int INITIALIZED = 2;
    public static final int STREAM_OPEN = 3;
    public static final int PROCEEDING = 4;
    public static final int UNAUTHORIZED = 5;
    public static final int COMPLETED = 6;
    private static final int MAX_NUM_RESPONSES = 10;
    private SipDialog sipDialog = null;
    private SipClientConnectionListener sipClientConnectionListener = null;
    private SipConnectionNotifier sipConnectionNotifier = null;
    private SipRefreshListener sipRefreshListener = null;
    private String refreshID = null;
    protected int state;
    private boolean connectionOpen;
    private Vector credentials;
    private Request request = null;
    private Request requestSavedBeforeACK = null;
    private Response response = null;
    private Vector responses = new Vector();
    private Response responseReceived = null;
    private SDPOutputStream contentOutputStream = null;
    private InputStream contentInputStream = null;
    private URI requestURI = null;
    private String scheme = null;
    private String user = null;
    private String host = null;
    private int port = -1;
    private NameValueList parameters = null;
    private String userSipURI = "sip:anonymous@anonymous.invalid";
    private ClientTransaction clientTransaction = null;
    private Thread listeningThread = null;
    private StackConnector stackConnector = null;
    private boolean isNotifierCreated = false;
    private boolean useRequest;
    protected boolean enableInitCancel = false;
    private int countReoriginateRequest = 1;
    private static final String DELIMITER = "@#$";

    public void setMd(int md) {
        this.md = md;
    }

    public int getMd() {
        return this.md;
    }

    protected SipClientConnectionImpl(SipURI inputURI, SecurityToken classSecurityToken) throws IllegalArgumentException {
        this.user = inputURI.getUser();
        this.host = inputURI.getHost();
        this.port = inputURI.getPort();
        this.parameters = inputURI.getUriParms();
        this.classSecurityToken = classSecurityToken;
        this.scheme = inputURI.getScheme();
        this.connectionOpen = true;
        this.credentials = new Vector();
        try {
            this.stackConnector = StackConnector.getInstance(classSecurityToken);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this.requestURI = StackConnector.addressFactory.createURI(this.scheme + ":" + (this.user == null ? "" : this.user + "@") + this.host);
            if (this.port != -1) {
                ((SipURI)this.requestURI).setPort(this.port);
            }
            if (this.parameters != null) {
                Enumeration parNames = this.parameters.getKeys();
                while (parNames.hasMoreElements()) {
                    String name = (String)parNames.nextElement();
                    String value = (String)this.parameters.getValue(name);
                    ((SipURI)this.requestURI).setParameter(name, value);
                }
            }
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The request URI can not be created, check the URI syntax");
        }
        this.state = 1;
        this.useRequest = true;
    }

    protected SipClientConnectionImpl(URI requestURI, SipDialog sipDialog) throws IllegalArgumentException {
        if (!requestURI.isSipURI()) {
            throw new IllegalArgumentException("URI is not correct");
        }
        SipURI sipURI = (SipURI)requestURI;
        SipDialogImpl sipDialogImpl = (SipDialogImpl)sipDialog;
        this.user = sipURI.getUser();
        this.host = sipURI.getHost();
        this.port = sipURI.getPort();
        this.parameters = sipURI.getUriParms();
        this.classSecurityToken = sipDialogImpl.getSecurityToken();
        this.scheme = requestURI.getScheme();
        this.connectionOpen = true;
        this.credentials = new Vector();
        this.requestURI = requestURI;
        this.sipDialog = sipDialog;
        this.refreshID = sipDialogImpl.getRefreshID();
        try {
            this.stackConnector = StackConnector.getInstance(this.classSecurityToken);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        sipDialogImpl.dialog.setStack(this.stackConnector.getSipStack());
        this.state = 1;
        this.useRequest = true;
    }

    private SipClientConnectionImpl(Request request, SipConnectionNotifier sipConnectionNotifier, String sipUserURI) throws IllegalArgumentException {
        this.connectionOpen = true;
        this.credentials = new Vector();
        this.request = request;
        this.userSipURI = sipUserURI;
        this.requestURI = request.getRequestURI();
        this.sipConnectionNotifier = sipConnectionNotifier;
        try {
            this.stackConnector = StackConnector.getInstance(this.classSecurityToken);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.state = request.getMethod().equals("CANCEL") ? 2 : 1;
        this.useRequest = true;
    }

    public void initRequest(String method, SipConnectionNotifier scn) throws IllegalArgumentException, SipException {
        String viaTransport;
        int viaLocalPort;
        String viaLocalAddress;
        byte dialogState;
        if (method == null) {
            throw new IllegalArgumentException("The method can not be null");
        }
        if (this.state != 1) {
            throw new SipException("the request can not be initialized, because of wrong state.", 5);
        }
        if (this.state == 1 && (method.equals("ACK") || method.equals("CANCEL"))) {
            throw new SipException("the request can not be initialized, because of wrong state.", 5);
        }
        if (!Lexer.isValidName(method)) {
            throw new IllegalArgumentException("Invalid method: '" + method + "'");
        }
        if (scn != null) {
            this.sipConnectionNotifier = scn;
        } else {
            String transport = this.parameters.getValueDefault("transport", "UDP");
            int localPort = transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
            Vector connectionNotifiersList = this.stackConnector.getConnectionNotifiersList();
            try {
                for (int i = 0; i < connectionNotifiersList.size(); ++i) {
                    SipConnectionNotifier currNotifier = (SipConnectionNotifier)connectionNotifiersList.elementAt(i);
                    if (currNotifier.getLocalPort() != localPort || !((SipConnectionNotifierImpl)currNotifier).getSipProvider().getListeningPoint().getTransport().equalsIgnoreCase(transport)) continue;
                    this.sipConnectionNotifier = currNotifier;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new SipException(ioe.getMessage(), 0);
            }
            if (this.sipConnectionNotifier == null) {
                try {
                    this.sipConnectionNotifier = this.stackConnector.createSipConnectionNotifier(localPort, this.scheme.equals("SIP"), transport, null);
                }
                catch (IOException ioe) {
                    throw new SipException(ioe.getMessage(), 0);
                }
                this.isNotifierCreated = true;
            }
        }
        if (method.equals("ACK")) {
            this.initAck();
        }
        if (method.equals("BYE") && this.sipDialog != null) {
            this.initBye();
            this.state = 2;
            this.useRequest = true;
            return;
        }
        if (method.equals("NOTIFY") && this.sipDialog != null) {
            this.initNotify();
            this.state = 2;
            this.useRequest = true;
            return;
        }
        if (this.sipDialog != null && ((dialogState = this.sipDialog.getState()) == 1 || dialogState == 2)) {
            if (method.equals("PRACK") && !((SipDialogImpl)this.sipDialog).isReliableProvReceived) {
                return;
            }
            this.request = ((SipDialogImpl)this.sipDialog).dialog.createRequest(method);
            this.state = 2;
            this.useRequest = true;
            return;
        }
        String sipURI = null;
        try {
            RecordStore rs = RecordStore.openRecordStore("UserSipUri", false);
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            if (re.hasNextElement()) {
                int recordID = re.nextRecordId();
                sipURI = new String(rs.getRecord(recordID));
            }
        }
        catch (RecordStoreException rse) {
            // empty catch block
        }
        if (sipURI != null) {
            this.userSipURI = sipURI;
        }
        Address userAddress = null;
        try {
            userAddress = StackConnector.addressFactory.createAddress(this.userSipURI);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The system property UserSipUrican not be parsed, check the syntax");
        }
        CallIdHeader callIdHeader = null;
        String callId = SIPUtils.generateCallIdentifier(this.stackConnector.getSipStack().getIPAddress());
        callIdHeader = new CallIdHeader();
        callIdHeader.setCallId(callId);
        CSeqHeader cSeqHeader = null;
        try {
            cSeqHeader = StackConnector.headerFactory.createCSeqHeader(1, method);
        }
        catch (ParseException pe) {
            throw new SipException("Problem during the creation of the CSeqHeader", 0);
        }
        FromHeader fromHeader = null;
        try {
            fromHeader = StackConnector.headerFactory.createFromHeader(userAddress, StackConnector.generateTag());
        }
        catch (ParseException ex) {
            throw new SipException("Problem during the creation of the FromHeader", 0);
        }
        Address toAddress = StackConnector.addressFactory.createAddress(this.requestURI);
        ToHeader toHeader = null;
        try {
            toHeader = StackConnector.headerFactory.createToHeader(toAddress, null);
        }
        catch (ParseException ex) {
            throw new SipException("Problem during the creation of the ToHeader", 0);
        }
        Vector<ViaHeader> viaHeaders = new Vector<ViaHeader>();
        try {
            viaLocalAddress = this.sipConnectionNotifier.getLocalAddress();
            viaLocalPort = this.sipConnectionNotifier.getLocalPort();
            viaTransport = ((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getListeningPoint().getTransport();
        }
        catch (IOException ioe) {
            throw new SipException("Internal Error, cannot get the local port or address", 0);
        }
        try {
            ViaHeader viaHeader = StackConnector.headerFactory.createViaHeader(viaLocalAddress, viaLocalPort, viaTransport, SIPUtils.generateBranchId());
            viaHeaders.addElement(viaHeader);
        }
        catch (ParseException ex) {
            throw new SipException("Problem during the creation of the ViaHeaders", 0);
        }
        MaxForwardsHeader maxForwardsHeader = StackConnector.headerFactory.createMaxForwardsHeader(70);
        try {
            this.request = StackConnector.messageFactory.createRequest(this.requestURI, method, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader);
        }
        catch (ParseException ex) {
            throw new SipException("Problem during the creation  of the Request " + method, 0);
        }
        if (!method.equals("MESSAGE") && !method.equals("PUBLISH")) {
            ContactHeader contactHeader = null;
            try {
                if (this.isNotifierCreated) {
                    SipURI contactURI = StackConnector.addressFactory.createSipURI("anonymous", viaLocalAddress);
                    contactURI.setTransportParam(viaTransport);
                    contactURI.setPort(viaLocalPort);
                    contactHeader = StackConnector.headerFactory.createContactHeader(StackConnector.addressFactory.createAddress(contactURI));
                } else {
                    SipURI contactURI = StackConnector.addressFactory.createSipURI(this.userSipURI.substring(this.scheme.length() + 1, this.userSipURI.indexOf("@")), this.sipConnectionNotifier.getLocalAddress());
                    contactURI.setTransportParam(((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getListeningPoint().getTransport());
                    contactHeader = StackConnector.headerFactory.createContactHeader(StackConnector.addressFactory.createAddress(contactURI));
                    contactURI.setPort(this.sipConnectionNotifier.getLocalPort());
                }
            }
            catch (IOException ioe) {
                throw new SipException("Internal Error, cannot get the local port or address", 0);
            }
            catch (ParseException ex) {
                throw new SipException("Problem during the creation of the Contact Header", 0);
            }
            this.request.addHeader(contactHeader);
        }
        this.state = 2;
        this.useRequest = true;
    }

    public void setRequestURI(String newUri) throws IllegalArgumentException, SipException {
        if (this.state != 2) {
            throw new SipException("the request URI can not be set,  because of wrong state.", 5);
        }
        if (newUri == null) {
            throw new IllegalArgumentException("Invalid URI");
        }
        URI uri = null;
        try {
            uri = StackConnector.addressFactory.createURI(newUri);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Invalid URI");
        }
        this.request.setRequestURI(uri);
        this.requestURI = uri;
    }

    public void initAck() throws SipException {
        if (this.state != 6) {
            throw new SipException("the ACK request can not be initialized, because of wrong state.", 5);
        }
        if (this.requestSavedBeforeACK != null) {
            this.request = this.requestSavedBeforeACK;
        }
        if (!this.request.getMethod().equals("INVITE")) {
            throw new SipException("Original request is non-INVITE", 6);
        }
        int statusCode = 0;
        if (this.response != null) {
            statusCode = this.response.getStatusCode() / 100;
        } else if (this.responseReceived != null) {
            statusCode = this.responseReceived.getStatusCode() / 100;
        }
        if (this.responseReceived.getStatusCode() / 100 > 2) {
            throw new SipException("ACK request was already sent", 6);
        }
        this.requestSavedBeforeACK = this.request;
        this.request = this.clientTransaction.createAck();
        this.state = 2;
        this.useRequest = true;
    }

    protected void initBye() {
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        try {
            this.request = sipDialogImpl.dialog.createRequest("BYE");
            if (this.parameters != null) {
                Enumeration parNames = this.parameters.getKeys();
                while (parNames.hasMoreElements()) {
                    String name = (String)parNames.nextElement();
                    String value = (String)this.parameters.getValue(name);
                    ((SipURI)this.requestURI).setParameter(name, value);
                }
            }
        }
        catch (SipException ex) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected void initNotify() {
        if (this.sipDialog == null) {
            throw new IllegalArgumentException("Initialization NOTIFY request out of dialog");
        }
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        try {
            this.request = sipDialogImpl.dialog.createRequest("NOTIFY");
            if (this.parameters != null) {
                Enumeration parNames = this.parameters.getKeys();
                while (parNames.hasMoreElements()) {
                    String name = (String)parNames.nextElement();
                    String value = (String)this.parameters.getValue(name);
                    ((SipURI)this.requestURI).setParameter(name, value);
                }
            }
        }
        catch (SipException ex) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public SipClientConnection initCancel() throws SipException {
        if (this.state != 4 || !this.enableInitCancel) {
            throw new SipException("the CANCEL request can not be initialized, because of wrong state.", 5);
        }
        if (!this.request.getMethod().equals("INVITE")) {
            throw new SipException("The method of original request is not INVITE", 6);
        }
        Request cancelRequest = this.clientTransaction.createCancel();
        SipClientConnectionImpl sipClientConnectionCancel = new SipClientConnectionImpl(cancelRequest, this.sipConnectionNotifier, this.userSipURI);
        return sipClientConnectionCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receive(long timeout) throws SipException, IOException {
        if (this.state != 4 && this.state != 6) {
            throw new SipException(5);
        }
        if (this.responses.isEmpty() && timeout != 0L) {
            SipClientConnectionImpl sipClientConnectionImpl = this;
            synchronized (sipClientConnectionImpl) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        if (this.responses.isEmpty()) {
            return false;
        }
        IncomingQueueElement incomingElement = (IncomingQueueElement)this.responses.firstElement();
        this.responseReceived = incomingElement.getResponse();
        this.responses.removeElementAt(0);
        this.useRequest = false;
        if (incomingElement.containsClientTransaction()) {
            this.clientTransaction = incomingElement.getClientTransaction();
        }
        if (this.responseReceived.getStatusCode() / 100 == 2 && this.state == 6) {
            this.sipDialog = new SipDialogImpl(this.clientTransaction.getDialog(), this.sipConnectionNotifier, this.classSecurityToken);
            ((SipDialogImpl)this.sipDialog).setWaitForBye(true);
            ((SipDialogImpl)this.sipDialog).setState((byte)2);
        }
        this.changeDialogState();
        this.changeClientConnectionState();
        if (NetMonProxy.isNetworkMonitorActive0()) {
            this.responseReceived0(this.md, this.response.getFromHeader().getAddress().getURI().toString(), SipClientConnectionImpl.serializeHeader((SipConnection)this), this.getStatusCode(), Response.getReasonPhrase(this.getStatusCode()));
        }
        return true;
    }

    public native void send0(int var1, String var2, String var3, String var4);

    public native void responseReceived0(int var1, String var2, String var3, int var4, String var5);

    private static String serializeHeader(SipConnection conn) {
        String[] keys = new String[]{"Call-ID", "Contact", "Content-Encoding", "Content-Type", "From", "To", "Subject", "Via"};
        String header = new String();
        for (int iKey = 0; iKey < keys.length; ++iKey) {
            String[] vals = null;
            try {
                vals = conn.getHeaders(keys[iKey]);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                System.out.println("Reason: " + e.getMessage());
                continue;
            }
            if (vals == null || vals.length == 0 || vals[0] == null) {
                header = header + keys[iKey] + DELIMITER + DELIMITER;
                continue;
            }
            for (int iVal = 0; iVal < vals.length; ++iVal) {
                header = header + keys[iKey] + DELIMITER + vals[iVal] + DELIMITER;
            }
        }
        return header;
    }

    public void setListener(SipClientConnectionListener sccl) throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        this.sipClientConnectionListener = sccl;
    }

    public int enableRefresh(SipRefreshListener srl) throws SipException {
        if (this.state != 2) {
            throw new SipException("can not enable the refresh, because of wrong state.", 5);
        }
        if (srl == null) {
            return 0;
        }
        String method = this.request.getMethod();
        if (!(method.equals("REGISTER") || method.equals("SUBSCRIBE") || method.equals("PUBLISH"))) {
            return 0;
        }
        this.sipRefreshListener = srl;
        int taskID = RefreshManager.getInstance().createRefreshTask(this.request, this.sipConnectionNotifier, this.sipRefreshListener, this);
        this.refreshID = String.valueOf(taskID);
        return taskID;
    }

    public void setCredentials(String username, String password, String realm) throws SipException {
        if (this.state != 2 && this.state != 5) {
            throw new SipException("can not set the credentials, because of wrong state.", 5);
        }
        if (username == null || password == null || realm == null) {
            throw new NullPointerException();
        }
        Credentials credential = new Credentials(username, password, realm);
        this.credentials.addElement(credential);
        if (this.state == 5) {
            this.reoriginateRequest();
        }
    }

    public void send() throws IOException, InterruptedIOException, SipException {
        this.sendRequestImpl(false);
    }

    private void sendRequestImpl(boolean isRefreshRequest) throws IOException, InterruptedIOException, SipException {
        if (this.state != 3 && this.state != 2) {
            throw new SipException("can not send the request, because of wrong state.", 5);
        }
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        if (this.contentOutputStream != null) {
            this.contentOutputStream.setOpen(false);
            this.request.setContent(this.contentOutputStream.getByteArrayOutputStream().toByteArray(), (ContentTypeHeader)this.request.getHeader("Content-Type"));
            this.contentOutputStream = null;
        }
        String[] mandatoryHeaders = new String[]{"To", "From", "CSeq", "Call-ID", "Max-Forwards", "Via"};
        Vector<String> mandatoryList = new Vector<String>();
        for (int i = 0; i < mandatoryHeaders.length; ++i) {
            mandatoryList.addElement(mandatoryHeaders[i]);
        }
        String method = this.request.getMethod();
        if (method.equals("REFER")) {
            mandatoryList.addElement("Refer-To");
        }
        if (method.equals("NOTIFY")) {
            mandatoryList.addElement("Subscription-State");
        }
        for (int i = 0; i < mandatoryList.size(); ++i) {
            if (this.request.getHeader((String)mandatoryList.elementAt(i)) != null) continue;
            throw new SipException("Header " + (String)mandatoryList.elementAt(i) + " is missed", 5);
        }
        FromHeader fromHeader = (FromHeader)this.request.getHeader("From");
        if (!fromHeader.hasTag()) {
            fromHeader.setTag(StackConnector.generateTag());
        }
        if (method.equals("REGISTER")) {
            Address reqUriAddress = null;
            try {
                reqUriAddress = StackConnector.addressFactory.createAddress(this.requestURI.toString());
                if (reqUriAddress.isSIPAddress()) {
                    ((SipURI)reqUriAddress.getURI()).removeUser();
                    this.requestURI = reqUriAddress.getURI();
                }
                this.request.setRequestURI(this.requestURI);
            }
            catch (ParseException pe) {
                throw new SipException("The system property UserSipUri can not be parsed, check the syntax", 6);
            }
        }
        ViaHeader requestViaHeader = (ViaHeader)this.request.getViaHeaders().getFirst();
        int viaPort = requestViaHeader.getPort();
        int localPort = this.sipConnectionNotifier.getLocalPort();
        String transport = requestViaHeader.getTransport();
        if (localPort != viaPort) {
            throw new IOException("Via port (" + viaPort + ") doesn't " + "match the listener's port (" + localPort + ")!");
        }
        SipConnectionNotifierImpl notifierImpl = (SipConnectionNotifierImpl)this.sipConnectionNotifier;
        if (!notifierImpl.getSipProvider().getListeningPoint().getTransport().equalsIgnoreCase(transport)) {
            throw new IOException("Via transport doesn't match the listener's transport!");
        }
        if (method.equals("PUBLISH")) {
            this.request.removeHeader("Record-Route");
        }
        try {
            this.clientTransaction = ((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getNewClientTransaction(this.request);
        }
        catch (TransactionUnavailableException tue) {
            throw new SipException("Cannot create a new Client  Transaction for this request", 7);
        }
        catch (IllegalArgumentException iae) {
            throw new SipException("SCC.send(): IAE occured (1): " + iae.getMessage(), 0);
        }
        catch (NullPointerException npe) {
            throw new SipException("SCC.send(): NPE occured (1): " + npe.getMessage(), 0);
        }
        this.clientTransaction.setApplicationData(this);
        if (method.equals("ACK")) {
            try {
                this.clientTransaction.getDialog().sendAck(this.request);
            }
            catch (IllegalArgumentException iae) {
                throw new SipException("SCC.send(): can't send ACK: " + iae, 0);
            }
            this.state = 6;
            if (NetMonProxy.isNetworkMonitorActive0()) {
                String message = this.request.getMessageContent();
                this.send0(this.md, this.request.getMethod(), SipClientConnectionImpl.serializeHeader((SipConnection)this), message == null ? "" : message);
            }
            return;
        }
        if (this.sipDialog != null && !isRefreshRequest) {
            SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
            if (method.equals("SUBSCRIBE") || method.equals("REFER")) {
                sipDialogImpl.addSubscription(new Subscription(sipDialogImpl.getDialog(), this.request));
            } else if (method.equals("INVITE")) {
                sipDialogImpl.setWaitForBye(true);
            }
            sipDialogImpl.dialog.sendRequest(this.clientTransaction);
            this.state = 4;
            if (NetMonProxy.isNetworkMonitorActive0()) {
                String message = this.request.getMessageContent();
                this.send0(this.md, this.request.getMethod(), SipClientConnectionImpl.serializeHeader((SipConnection)this), message == null ? "" : message);
            }
            return;
        }
        this.clientTransaction.sendRequest();
        if (this.stackConnector.getSipStack().isDialogCreated(method) && !isRefreshRequest) {
            this.sipDialog = new SipDialogImpl(this.clientTransaction.getDialog(), this.sipConnectionNotifier, this.classSecurityToken);
            SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
            sipDialogImpl.setRefreshID(this.refreshID);
            sipDialogImpl.setSipClientConnectionListener(this.sipClientConnectionListener);
            this.stackConnector.sipDialogList.addElement(this.sipDialog);
            if (!method.equals("INVITE")) {
                sipDialogImpl.addSubscription(new Subscription(sipDialogImpl.getDialog(), this.request));
            } else {
                sipDialogImpl.setWaitForBye(true);
            }
        }
        if (this.request.getMethod().equals("REGISTER")) {
            String requestTransport;
            SipURI sipURI = (SipURI)this.request.getRequestURI();
            int requestPort = sipURI.getPort();
            if (requestPort == -1) {
                requestPort = this.sipConnectionNotifier.getLocalPort();
            }
            if ((requestTransport = sipURI.getTransportParam()) == null || requestTransport.length() < 1) {
                requestTransport = ((SipConnectionNotifierImpl)this.sipConnectionNotifier).getSipProvider().getListeningPoint().getTransport();
            }
            this.stackConnector.sipStack.getRouter().setOutboundProxy(sipURI.getHost() + ":" + requestPort + "/" + requestTransport);
        }
        this.state = 4;
        if (NetMonProxy.isNetworkMonitorActive0()) {
            String message = this.request.getMessageContent();
            this.send0(this.md, this.request.getMethod(), SipClientConnectionImpl.serializeHeader((SipConnection)this), message == null ? "" : message);
        }
    }

    public void setHeader(String name, String value) throws SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new SipException("the Header can not be set, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        this.request.attachHeader(header, true, true);
    }

    public void addHeader(String name, String value) throws SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new SipException("the Header can not be add, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The header can not be created, check if it is correct");
        }
        this.request.addHeader(header);
    }

    public void removeHeader(String name) throws SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new SipException("the Header can not be removed, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        this.request.removeHeader(name, true);
    }

    public String[] getHeaders(String name) {
        Message currentMessage;
        Message message = currentMessage = this.useRequest ? this.request : this.responseReceived;
        if (currentMessage == null) {
            return null;
        }
        HeaderList nameList = currentMessage.getHeaderList(name);
        if (nameList == null) {
            return null;
        }
        int size = nameList.size();
        if (size < 1) {
            return null;
        }
        String[] headerValues = new String[size];
        for (int count = 0; count < size; ++count) {
            headerValues[count] = ((Header)nameList.elementAt(count)).getHeaderValue();
        }
        return headerValues;
    }

    public String getHeader(String name) {
        Message currentMessage;
        Message message = currentMessage = this.useRequest ? this.request : this.responseReceived;
        if (currentMessage == null) {
            return null;
        }
        Header nameHeader = currentMessage.getHeader(name);
        if (nameHeader == null) {
            return null;
        }
        return nameHeader.getHeaderValue();
    }

    public String getMethod() {
        if (null == this.request || 0 == this.state) {
            return null;
        }
        return this.request.getMethod();
    }

    public String getRequestURI() {
        if (this.state != 2 || this.request == null) {
            return null;
        }
        return this.request.getRequestURI().toString();
    }

    public int getStatusCode() {
        if (this.responseReceived == null) {
            return 0;
        }
        return this.responseReceived.getStatusCode();
    }

    public String getReasonPhrase() {
        if (this.state != 4 && this.state != 6 && this.state != 5 || this.responseReceived == null) {
            return null;
        }
        return this.responseReceived.getReasonPhrase();
    }

    public SipDialog getDialog() {
        byte dialogState;
        if (this.sipDialog != null && (dialogState = this.sipDialog.getState()) != 1 && dialogState != 2) {
            return null;
        }
        return this.sipDialog;
    }

    public InputStream openContentInputStream() throws IOException, SipException {
        String errStateMsg = "the content input stream can not be open, because of wrong state.";
        if (this.state != 6 && this.state != 4) {
            throw new SipException(errStateMsg, 5);
        }
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        if (this.responseReceived == null) {
            throw new SipException(errStateMsg, 5);
        }
        ContentLengthHeader contentLengthHeader = this.responseReceived.getContentLengthHeader();
        if (contentLengthHeader == null) {
            throw new IOException("Response contains no content length header.");
        }
        int bodyLength = contentLengthHeader.getContentLength();
        if (bodyLength == 0) {
            throw new IOException("Response's body has zero length.");
        }
        byte[] buf = this.responseReceived.getRawContent();
        if (buf == null) {
            throw new IOException("Body of SIP response is empty.");
        }
        this.contentInputStream = new ByteArrayInputStream(buf);
        return this.contentInputStream;
    }

    public OutputStream openContentOutputStream() throws IOException, SipException {
        if (this.state != 2) {
            throw new SipException("the content output stream can not be open, because of wrong state.", 5);
        }
        if (this.request.getHeader("Content-Type") == null) {
            throw new SipException("Content-Type unknown, set the content-type header first", 3);
        }
        if (this.request.getHeader("Content-Length") == null) {
            throw new SipException("Content-Length unknown, set the content-length header first", 4);
        }
        if (!this.connectionOpen) {
            throw new IOException("The Connection has been closed!");
        }
        this.contentOutputStream = new SDPOutputStream((SipConnection)this);
        this.state = 3;
        return this.contentOutputStream;
    }

    public void close() throws IOException {
        this.responses.removeAllElements();
        if (this.isNotifierCreated && this.sipConnectionNotifier != null) {
            this.sipConnectionNotifier.close();
        }
        this.connectionOpen = false;
        this.listeningThread = null;
        this.state = 0;
    }

    private void reoriginateRequest() {
        DigestClientAuthentication authentication;
        Request newRequest;
        if (this.sipDialog != null && this.sipDialog.getState() == 0) {
            this.sipDialog = null;
        }
        if ((newRequest = (authentication = new DigestClientAuthentication(this.credentials)).createNewRequest(this.stackConnector.sipStack, this.request, this.responseReceived, this.countReoriginateRequest)) != null) {
            ++this.countReoriginateRequest;
            this.request = newRequest;
            this.state = 2;
            this.useRequest = true;
            try {
                this.send();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void changeClientConnectionState() {
        this.state = this.responseReceived.getStatusCode() / 100 == 1 && this.state == 4 ? 4 : (this.state == 4 && (this.responseReceived.getStatusCode() == 401 || this.responseReceived.getStatusCode() == 407) ? 5 : 6);
    }

    private void changeDialogState() {
        if (this.sipDialog == null) {
            return;
        }
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        String method = this.responseReceived.getCSeqHeader().getMethod();
        if (!this.stackConnector.getSipStack().allowDialogStateChange(method)) {
            return;
        }
        int statusCode = this.responseReceived.getStatusCode();
        if (statusCode / 100 == 2) {
            sipDialogImpl.setState((byte)2);
            sipDialogImpl.setDialogID(this.responseReceived.getDialogId(false));
            if (statusCode == 200) {
                if (method.equals("NOTIFY")) {
                    sipDialogImpl.handleNotify(this.request, null, this.responseReceived.getDialogId(false));
                    return;
                }
                if (method.equals("SUBSCRIBE")) {
                    ExpiresHeader expiresHeader = (ExpiresHeader)this.responseReceived.getHeader("Expires");
                    if (expiresHeader != null && expiresHeader.getExpires() == 0) {
                        sipDialogImpl.terminateIfNoSubscriptions();
                    } else {
                        sipDialogImpl.setState((byte)2);
                        sipDialogImpl.setDialogID(this.responseReceived.getDialogId(false));
                    }
                } else if (method.equals("BYE")) {
                    sipDialogImpl.setWaitForBye(false);
                    sipDialogImpl.terminateIfNoSubscriptions();
                }
            }
        } else if (statusCode / 100 == 1) {
            if (statusCode != 100) {
                ParameterLessHeader requireHeader;
                if (this.sipDialog.getState() == -1) {
                    sipDialogImpl.setState((byte)1);
                }
                if ((requireHeader = (ParameterLessHeader)this.responseReceived.getHeader("Require")) != null) {
                    sipDialogImpl.isReliableProvReceived = Header.isReliableTagPresent(requireHeader.getHeaderValue());
                }
                sipDialogImpl.setDialogID(this.responseReceived.getDialogId(false));
            }
        } else {
            sipDialogImpl.removeSubscription(this.response);
            if (this.sipDialog.getState() != 2) {
                if (method.equals("INVITE")) {
                    sipDialogImpl.setWaitForBye(false);
                }
                sipDialogImpl.terminateIfNoSubscriptions();
            }
        }
    }

    protected void updateAndSendRequestFromRefresh(Request updatedRequest) throws IOException, InterruptedIOException, SipException {
        this.request = updatedRequest;
        this.state = 2;
        this.sendRequestImpl(true);
    }

    protected OutputStream updateRequestAndOpenOutputStream(Request updatedRequest) throws IOException, SipException {
        this.request = updatedRequest;
        this.state = 2;
        return this.openContentOutputStream();
    }

    public Request getRequest() {
        return this.request;
    }

    protected String getCallIdentifier() {
        if (this.request == null) {
            return "";
        }
        return this.request.getCallIdentifier();
    }

    public void handleMatchingNotify(Request notifyRequest) {
        boolean isUnsubscribe;
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        byte state = sipDialogImpl.getState();
        SubscriptionStateHeader ssh = (SubscriptionStateHeader)notifyRequest.getHeader("Subscription-State");
        boolean bl = isUnsubscribe = ssh != null && ssh.isTerminated();
        if (state == -1 || state == 2 && isUnsubscribe) {
            String dialogId = notifyRequest.getDialogId(false);
            sipDialogImpl.setDialogID(dialogId);
            sipDialogImpl.handleNotify(notifyRequest, null, dialogId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void notifyResponseReceived(Response response, ClientTransaction inputClientTransaction) {
        Header hEtag;
        String method;
        int statusCode = response.getStatusCode();
        int statusGroup = statusCode / 100;
        boolean ignoreResponse = false;
        if (this.state == 6) {
            if (statusGroup != 2) {
                ignoreResponse = true;
            }
        } else if (this.state == 4) {
            if (this.credentials.size() > 0 && (statusCode == 401 || statusCode == 407)) {
                this.responseReceived = response;
                if (this.sipDialog != null) {
                    ((SipDialogImpl)this.sipDialog).setState((byte)0);
                }
                this.reoriginateRequest();
                ignoreResponse = true;
            }
        } else {
            ignoreResponse = true;
        }
        if (this.responses.size() > 10) {
            return;
        }
        if (ignoreResponse) {
            return;
        }
        IncomingQueueElement incomingElement = new IncomingQueueElement(response, inputClientTransaction);
        this.responses.addElement(incomingElement);
        this.response = response;
        if (this.state == 4) {
            this.enableInitCancel = statusGroup == 1;
        }
        if (response.getCSeqHeaderNumber() == this.request.getCSeqHeaderNumber()) {
            SipClientConnectionImpl sipClientConnectionImpl = this;
            // MONITORENTER : sipClientConnectionImpl
            this.notify();
            // MONITOREXIT : sipClientConnectionImpl
            if (this.sipClientConnectionListener != null) {
                this.sipClientConnectionListener.notifyResponse((SipClientConnection)this);
            }
        }
        if ((method = response.getCSeqHeader().getMethod()).equals("PUBLISH") && (hEtag = response.getHeader("SIP-ETag")) != null) {
            Header hIfMatch = this.request.getHeader("SIP-If-Match");
            if (hIfMatch == null) {
                Throwable ex = null;
                try {
                    hIfMatch = StackConnector.headerFactory.createHeader("SIP-If-Match", hEtag.getHeaderValue());
                    this.request.addHeader(hIfMatch);
                }
                catch (NullPointerException npe) {
                    ex = npe;
                }
                catch (ParseException pe) {
                    ex = pe;
                }
                catch (SipException se) {
                    ex = se;
                }
                if (ex == null) {
                    // empty if block
                }
            } else {
                hIfMatch.setHeaderValue(hEtag.getHeaderValue());
            }
            this.request.removeHeader("SIP-ETag");
        }
        if (statusCode == 200) {
            this.scheduleRefresh(method);
        }
        if (this.refreshID == null) return;
        this.sipRefreshListener.refreshEvent(Integer.parseInt(this.refreshID), statusCode, response.getReasonPhrase());
    }

    public int getState() {
        return this.state;
    }

    protected ClientTransaction getClientTransaction() {
        return this.clientTransaction;
    }

    protected SipStack getSipStack() {
        return this.stackConnector.getSipStack();
    }

    protected SipConnectionNotifier getSipConnectionNotifier() {
        return this.sipConnectionNotifier;
    }

    protected Response getResponse() {
        return this.response;
    }

    protected void clearResponse() {
        this.response = null;
    }

    private void scheduleRefresh(String method) {
        ExpiresHeader expiresHeader;
        int expires;
        ContactList cl;
        if (this.sipRefreshListener == null) {
            return;
        }
        if (!(method.equals("REGISTER") || method.equals("SUBSCRIBE") || method.equals("PUBLISH"))) {
            return;
        }
        if (method.equals("PUBLISH")) {
            this.request.removeContent();
        }
        int minExpires = Integer.MAX_VALUE;
        if (!method.equals("SUBSCRIBE") && (cl = this.response.getContactHeaders()) != null) {
            Enumeration en = cl.getElements();
            while (en.hasMoreElements()) {
                ContactHeader contactHeader = (ContactHeader)en.nextElement();
                if (contactHeader == null) continue;
                try {
                    expires = Integer.parseInt(contactHeader.getExpires());
                    if (expires <= 0 || expires >= minExpires) continue;
                    minExpires = expires;
                }
                catch (NumberFormatException e) {}
            }
        }
        if ((expiresHeader = (ExpiresHeader)this.response.getHeader("Expires")) != null && (expires = expiresHeader.getExpires()) > 0 && expires < minExpires) {
            minExpires = expires;
        }
        if (minExpires == Integer.MAX_VALUE || minExpires < 0) {
            minExpires = 3600;
        }
        if (minExpires != 0) {
            RefreshManager.getInstance().scheduleTask(this.refreshID, minExpires);
        }
    }
}

