/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import com.sun.kvem.netmon.NetMonProxy;
import com.sun.midp.security.SecurityToken;
import gov.nist.microedition.sip.SipDialogImpl;
import gov.nist.microedition.sip.SipServerConnectionImpl;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.ObjectInUseException;
import gov.nist.siplite.SipProvider;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.ServerTransaction;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import javax.microedition.sip.SipConnection;
import javax.microedition.sip.SipConnectionNotifier;
import javax.microedition.sip.SipDialog;
import javax.microedition.sip.SipException;
import javax.microedition.sip.SipServerConnection;
import javax.microedition.sip.SipServerConnectionListener;

public class SipConnectionNotifierImpl
implements SipConnectionNotifier {
    private SecurityToken classSecurityToken;
    private int md;
    private SipServerConnectionListener sipServerConnectionListener = null;
    private Vector messageQueue = null;
    private boolean connectionOpen;
    private String localHost = null;
    private int localPort;
    private SipProvider sipProvider = null;
    private Thread listeningThread = null;
    private StackConnector stackConnector = null;
    private String mimeType = null;
    private boolean waitingForAcceptAndOpen = false;
    boolean sharedMode = false;
    private static final String DELIMITER = "@#$";

    public void setMd(int md) {
        this.md = md;
    }

    public int getMd() {
        return this.md;
    }

    protected SipConnectionNotifierImpl(SipProvider sipProvider, String localAddress, int localPort, SecurityToken classSecurityToken, String mimeType, boolean sharedMode) {
        this.classSecurityToken = classSecurityToken;
        this.sipProvider = sipProvider;
        this.localHost = localAddress;
        this.localPort = localPort;
        this.mimeType = mimeType;
        this.sharedMode = sharedMode;
        this.connectionOpen = true;
        this.messageQueue = new Vector();
        try {
            this.stackConnector = StackConnector.getInstance(classSecurityToken);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipServerConnection acceptAndOpen() throws IOException, InterruptedIOException, SipException {
        if (!this.isConnectionOpen()) {
            throw new InterruptedIOException("Connection was closed!");
        }
        this.waitingForAcceptAndOpen = true;
        if (this.messageQueue == null || this.messageQueue.size() < 1) {
            SipConnectionNotifierImpl sipConnectionNotifierImpl = this;
            synchronized (sipConnectionNotifierImpl) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                }
                catch (IllegalMonitorStateException imse) {
                    // empty catch block
                }
            }
        }
        if (!this.isConnectionOpen()) {
            throw new InterruptedIOException("Connection is interrupted!");
        }
        this.waitingForAcceptAndOpen = false;
        Request request = (Request)this.messageQueue.firstElement();
        SipDialog sipDialog = null;
        ServerTransaction serverTransaction = (ServerTransaction)request.getTransaction();
        Dialog dialog = serverTransaction.getDialog();
        String method = request.getMethod();
        if (this.stackConnector.getSipStack().isDialogCreated(method)) {
            ContactHeader ch;
            Address addr;
            URI reqURI = null;
            ContactList cl = request.getContactHeaders();
            if (cl != null && cl.size() > 0 && (addr = (Address)(ch = (ContactHeader)cl.getFirst()).getValue()) != null) {
                reqURI = addr.getURI();
            }
            if (reqURI == null) {
                reqURI = request.getFromHeader().getAddress().getURI();
            }
            sipDialog = new SipDialogImpl(dialog, this, this.classSecurityToken);
            this.stackConnector.sipDialogList.addElement(sipDialog);
            if (method.equals("INVITE")) {
                ((SipDialogImpl)sipDialog).setWaitForBye(true);
            }
        } else if (dialog != null && !request.getMethod().equals("CANCEL")) {
            sipDialog = this.stackConnector.findDialog(dialog.getDialogId());
        }
        SipServerConnectionImpl sipServerConnection = new SipServerConnectionImpl(request, sipDialog, this);
        this.messageQueue.removeElementAt(0);
        if (NetMonProxy.isNetworkMonitorActive0()) {
            this.acceptAndOpen0(this.md, request.getMethod(), SipConnectionNotifierImpl.serializeHeader((SipConnection)sipServerConnection), request.getMessageContent());
            sipServerConnection.setMd(this.md);
        }
        return sipServerConnection;
    }

    public native void acceptAndOpen0(int var1, String var2, String var3, String var4);

    private static String serializeHeader(SipConnection conn) {
        String[] keys = new String[]{"Call-ID", "Contact", "Content-Encoding", "Content-Type", "From", "To", "Subject", "Via"};
        String header = new String();
        for (int iKey = 0; iKey < keys.length; ++iKey) {
            String[] vals = null;
            try {
                vals = conn.getHeaders(keys[iKey]);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                System.out.println("Reason: " + e.getMessage());
                continue;
            }
            if (vals == null || vals.length == 0 || vals[0] == null) {
                header = header + keys[iKey] + DELIMITER + DELIMITER;
                continue;
            }
            for (int iVal = 0; iVal < vals.length; ++iVal) {
                header = header + keys[iKey] + DELIMITER + vals[iVal] + DELIMITER;
            }
        }
        return header;
    }

    public void setListener(SipServerConnectionListener sscl) throws IOException {
        if (!this.isConnectionOpen()) {
            throw new IOException("Connection was closed!");
        }
        this.sipServerConnectionListener = sscl;
    }

    public String getLocalAddress() throws IOException {
        if (!this.isConnectionOpen()) {
            throw new IOException("Connection was closed!");
        }
        return this.localHost;
    }

    public int getLocalPort() throws IOException {
        if (!this.isConnectionOpen()) {
            throw new IOException("Connection was closed!");
        }
        return this.localPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.sharedMode) {
            this.stackConnector.closeSharedSipConnectionNotifier(this.mimeType);
        } else {
            SipStack sipStack = this.sipProvider.getSipStack();
            ListeningPoint listeningPoint = this.sipProvider.getListeningPoint();
            try {
                sipStack.deleteListeningPoint(listeningPoint);
                sipStack.deleteSipProvider(this.sipProvider);
            }
            catch (ObjectInUseException oiue) {
                throw new IOException(oiue.getMessage());
            }
            if (!sipStack.getListeningPoints().hasMoreElements()) {
                sipStack.stopStack();
            }
        }
        this.stackConnector.connectionNotifiersList.removeElement(this);
        this.connectionOpen = false;
        if (this.waitingForAcceptAndOpen) {
            SipConnectionNotifierImpl sipConnectionNotifierImpl = this;
            synchronized (sipConnectionNotifierImpl) {
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRequestReceived(Request request) {
        this.messageQueue.addElement(request);
        if (this.sipServerConnectionListener != null) {
            this.sipServerConnectionListener.notifyRequest((SipConnectionNotifier)this);
        }
        SipConnectionNotifierImpl sipConnectionNotifierImpl = this;
        synchronized (sipConnectionNotifierImpl) {
            try {
                this.notify();
            }
            catch (IllegalMonitorStateException imse) {
                imse.printStackTrace();
            }
        }
    }

    protected SipProvider getSipProvider() {
        return this.sipProvider;
    }

    protected boolean isConnectionOpen() {
        return this.connectionOpen;
    }

    protected String getMIMEType() {
        return this.mimeType;
    }

    protected StackConnector getStackConnector() {
        return this.stackConnector;
    }
}

