/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import com.sun.midp.security.SecurityToken;
import gov.nist.microedition.sip.SipClientConnectionImpl;
import gov.nist.microedition.sip.SipConnectionNotifierImpl;
import gov.nist.siplite.header.AuthorizationHeader;
import gov.nist.siplite.header.ProxyAuthorizationHeader;
import gov.nist.siplite.header.SubscriptionStateHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.Subscription;
import javax.microedition.sip.SipClientConnection;
import javax.microedition.sip.SipClientConnectionListener;
import javax.microedition.sip.SipConnection;
import javax.microedition.sip.SipConnectionNotifier;
import javax.microedition.sip.SipDialog;
import javax.microedition.sip.SipException;

public class SipDialogImpl
implements SipDialog {
    protected static final int INITIALIZED = -1;
    private byte state = (byte)-1;
    private String dialogID = null;
    protected Dialog dialog = null;
    private SipConnectionNotifier sipConnectionNotifier = null;
    private SipClientConnectionListener sipClientConnectionListener = null;
    protected ProxyAuthorizationHeader proxyAuthorizationHeader = null;
    protected AuthorizationHeader authorizationHeader = null;
    private SecurityToken classSecurityToken;
    private String refreshID = null;
    protected boolean isReliableProvReceived = false;
    private boolean waitForBye = false;

    protected SipDialogImpl(Dialog dialog, SipConnectionNotifier sipConnectionNotifier, SecurityToken classSecurityToken) {
        if (dialog != null) {
            this.dialogID = dialog.getDialogId();
            int underlyingDlgState = dialog.getState();
            if (underlyingDlgState == 2) {
                this.state = (byte)2;
            } else if (underlyingDlgState == 3 || underlyingDlgState == 4) {
                this.state = 0;
            }
        }
        this.dialog = dialog;
        this.sipConnectionNotifier = sipConnectionNotifier;
        this.classSecurityToken = classSecurityToken;
    }

    public SipClientConnection getNewClientConnection(String method) throws IllegalArgumentException, SipException {
        if (this.state != 2 && this.state != 1) {
            throw new SipException("the client connection can not be initialized, because of wrong state.", 5);
        }
        if (!Lexer.isValidName(method)) {
            throw new IllegalArgumentException("Invalid method: '" + method + "'");
        }
        SipClientConnectionImpl sipClientConnection = new SipClientConnectionImpl(this.getDialog().getRemoteTarget().getURI(), this);
        if (this.sipConnectionNotifier != null && !((SipConnectionNotifierImpl)this.sipConnectionNotifier).isConnectionOpen()) {
            this.sipConnectionNotifier = null;
        }
        sipClientConnection.initRequest(method.toUpperCase().trim(), this.sipConnectionNotifier);
        return sipClientConnection;
    }

    public boolean isSameDialog(SipConnection sc) {
        String id;
        if (this.state == 0 || sc == null) {
            return false;
        }
        SipDialog dlg = sc.getDialog();
        return dlg != null && (id = dlg.getDialogID()) != null && id.equals(this.dialogID);
    }

    public byte getState() {
        return this.state;
    }

    public String getDialogID() {
        if (this.state == 0) {
            return null;
        }
        return this.dialogID;
    }

    protected void setDialogID(String newDialogID) {
        this.dialogID = newDialogID;
    }

    protected void setDialog(Dialog newDialog) {
        this.dialog = newDialog;
        this.setDialogID(newDialog.getDialogId());
    }

    protected Dialog getDialog() {
        return this.dialog;
    }

    protected void setSipClientConnectionListener(SipClientConnectionListener newSipClientConnectionListener) {
        this.sipClientConnectionListener = newSipClientConnectionListener;
    }

    protected SipClientConnectionListener getSipClientConnectionListener() {
        return this.sipClientConnectionListener;
    }

    protected void setState(byte newState) {
        this.state = newState;
    }

    protected void terminateIfNoSubscriptions() {
        if (this.dialog == null) {
            this.setState((byte)0);
            return;
        }
        if (this.dialog.subscriptionList.isEmpty() && !this.waitForBye) {
            this.setState((byte)0);
        }
    }

    protected void addSubscription(Subscription s) {
        this.dialog.subscriptionList.addSubscription(s);
    }

    protected void removeSubscription(Message message) {
        Subscription s = this.dialog.subscriptionList.getMatchingSubscription(message);
        if (s != null) {
            this.dialog.subscriptionList.removeSubscription(s);
        }
    }

    protected void setWaitForBye(boolean bye) {
        this.waitForBye = bye;
    }

    protected void handleNotify(Request request, Dialog newDialog, String newDialogId) {
        SubscriptionStateHeader ssh = (SubscriptionStateHeader)request.getHeader("Subscription-State");
        if (ssh != null && ssh.isTerminated()) {
            Subscription s = this.dialog.subscriptionList.getMatchingSubscription(request);
            if (s != null) {
                this.dialog.subscriptionList.removeSubscription(s);
            }
            if (this.dialog.isSubscribeDialog() || this.dialog.isInviteDialog()) {
                this.terminateIfNoSubscriptions();
            }
        } else {
            this.setState((byte)2);
            if (newDialog != null) {
                this.setDialog(newDialog);
            } else {
                this.setDialogID(newDialogId);
            }
        }
    }

    protected SecurityToken getSecurityToken() {
        return this.classSecurityToken;
    }

    protected String getRefreshID() {
        return this.refreshID;
    }

    protected void setRefreshID(String newRefreshID) {
        this.refreshID = newRefreshID;
    }
}

