/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import com.sun.kvem.netmon.NetMonProxy;
import gov.nist.core.HostPort;
import gov.nist.core.ParseException;
import gov.nist.microedition.sip.SDPOutputStream;
import gov.nist.microedition.sip.SipConnectionNotifierImpl;
import gov.nist.microedition.sip.SipDialogImpl;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.SipProvider;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.TransactionAlreadyExistsException;
import gov.nist.siplite.TransactionUnavailableException;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.header.ContactHeader;
import gov.nist.siplite.header.ContactList;
import gov.nist.siplite.header.ContentLengthHeader;
import gov.nist.siplite.header.Header;
import gov.nist.siplite.header.HeaderList;
import gov.nist.siplite.header.ToHeader;
import gov.nist.siplite.message.Message;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.ServerTransaction;
import gov.nist.siplite.stack.Subscription;
import gov.nist.siplite.stack.Transaction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.sip.SipConnection;
import javax.microedition.sip.SipDialog;
import javax.microedition.sip.SipException;
import javax.microedition.sip.SipServerConnection;

public class SipServerConnectionImpl
implements SipServerConnection {
    public static final int TERMINATED = 0;
    public static final int REQUEST_RECEIVED = 1;
    public static final int INITIALIZED = 2;
    public static final int STREAM_OPEN = 3;
    public static final int COMPLETED = 4;
    private int state;
    private SipDialog sipDialog = null;
    private Request request = null;
    private Response response = null;
    private SDPOutputStream contentOutputStream = null;
    private InputStream contentInputStream = null;
    private SipConnectionNotifierImpl sipConnectionNotifierImpl;
    private boolean useResponse = false;
    private boolean resend2xxAllowed = false;
    private int md;
    private static final String DELIMITER = "@#$";

    public void setMd(int md) {
        this.md = md;
    }

    public int getMd() {
        return this.md;
    }

    protected SipServerConnectionImpl(Request request, SipDialog sipDialog, SipConnectionNotifierImpl sipConnectionNotifierImpl) {
        this.request = request;
        this.sipDialog = sipDialog;
        this.sipConnectionNotifierImpl = sipConnectionNotifierImpl;
        this.state = request.getMethod() == "ACK" ? 4 : 1;
    }

    public void initResponse(int code) throws IllegalArgumentException, SipException {
        ContactList contactList;
        if (code < 100 || code > 699) {
            throw new IllegalArgumentException("the response code is out of range.");
        }
        if (this.state != 1) {
            throw new SipException("the response can not be initialized, because of wrong state.", 5);
        }
        try {
            this.response = StackConnector.messageFactory.createResponse(code, this.request);
        }
        catch (ParseException pe) {
            // empty catch block
        }
        ToHeader toHeader = (ToHeader)this.response.getHeader("To");
        if (toHeader.getTag() == null) {
            toHeader.setTag(StackConnector.generateTag());
        }
        if ((contactList = this.response.getContactHeaders()) == null || contactList.isEmpty()) {
            ContactHeader contactHeader = null;
            String transport = this.sipConnectionNotifierImpl.getSipProvider().getListeningPoint().getTransport();
            try {
                Address address = StackConnector.addressFactory.createAddress("<sip:" + this.sipConnectionNotifierImpl.getLocalAddress() + ":" + this.sipConnectionNotifierImpl.getLocalPort() + ";transport=" + transport + ">");
                contactHeader = StackConnector.headerFactory.createContactHeader(address);
                this.response.addHeader(contactHeader);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        }
        this.state = 2;
        this.useResponse = true;
    }

    public void setReasonPhrase(String phrase) throws SipException, IllegalArgumentException {
        if (this.state != 2) {
            throw new SipException("the Reason Phrase can not be set, because of wrong state.", 5);
        }
        if (phrase == null) {
            throw new IllegalArgumentException("The reason phrase can not be null.");
        }
        if (phrase.indexOf("\n") != -1 || phrase.indexOf("\r") != -1) {
            throw new IllegalArgumentException("Invalid reason phrase.");
        }
        this.response.setReasonPhrase(phrase);
    }

    public void send() throws IOException, InterruptedIOException, SipException {
        int responseClass;
        Dialog dialog;
        if (this.state == 1) {
            throw new SipException("can not send response because of wrong state.", 5);
        }
        if (this.state == 4 && !this.resend2xxAllowed) {
            throw new SipException("COMPLETED state allows only resend of 2xx responses", 5);
        }
        if (this.state == 0) {
            throw new SipException("can not send response because SipServerConnection is TERMINATED", 5);
        }
        ServerTransaction serverTransaction = (ServerTransaction)this.request.getTransaction();
        if (this.contentOutputStream != null) {
            this.contentOutputStream.setOpen(false);
            this.response.setContent(this.contentOutputStream.getByteArrayOutputStream().toByteArray());
            this.contentOutputStream = null;
        }
        String method = this.request.getMethod();
        int statusCode = this.response.getStatusCode();
        int statusGroup = statusCode / 100;
        if (!this.resend2xxAllowed) {
            SipStack sipStack = this.sipConnectionNotifierImpl.getStackConnector().getSipStack();
            if (serverTransaction == null || sipStack.isDialogCreated(method)) {
                try {
                    SipProvider sipProvider = this.sipConnectionNotifierImpl.getSipProvider();
                    if (serverTransaction == null) {
                        serverTransaction = sipProvider.getNewServerTransaction(this.request);
                    } else if (statusCode > 100 && statusCode < 300) {
                        boolean equipDialog = false;
                        if (this.sipDialog == null) {
                            equipDialog = true;
                        } else if (this.sipDialog.getState() == -1) {
                            equipDialog = true;
                        }
                        if (equipDialog) {
                            sipProvider.equipADialogForTransaction(serverTransaction, this.request);
                        }
                    } else if (this.sipDialog != null && statusGroup > 2 && statusGroup < 7) {
                        ((SipDialogImpl)this.sipDialog).setState((byte)0);
                    }
                }
                catch (TransactionAlreadyExistsException taee) {
                }
                catch (TransactionUnavailableException tue) {
                    // empty catch block
                }
            }
        }
        SipConnectionNotifierImpl newNotifier = this.sipConnectionNotifierImpl;
        if (this.sipDialog != null && (dialog = ((SipDialogImpl)this.sipDialog).getDialog()) != null && statusCode > 199 && statusCode < 300) {
            if (method.equals("UPDATE")) {
                dialog.addRoute(serverTransaction.getOriginalRequest());
            }
            newNotifier = this.findNotifier();
            Transaction transaction = dialog.getFirstTransaction();
            transaction.setApplicationData(newNotifier);
            if (newNotifier != null) {
                this.sipConnectionNotifierImpl = newNotifier;
            }
        }
        serverTransaction.setApplicationData(newNotifier);
        serverTransaction.sendResponse(this.response);
        if (NetMonProxy.isNetworkMonitorActive0()) {
            String msgContent = this.response.getStatusCode() + ": " + this.response.getReasonPhrase();
            this.send0(this.md, "RESPONSE to " + this.response.getCSeqHeader().getMethod(), this.request.getRequestURI().toString(), SipServerConnectionImpl.serializeHeader((SipConnection)this), msgContent);
        }
        if ((responseClass = this.response.getStatusCode() / 100) == 1) {
            this.state = 1;
        } else {
            this.state = 4;
            if (responseClass == 2) {
                this.resend2xxAllowed = true;
            }
        }
        this.changeDialogState(serverTransaction);
    }

    private SipConnectionNotifierImpl findNotifier() throws SipException {
        int localPort = 5060;
        String localTransport = "UDP";
        ContactList contactList = this.response.getContactHeaders();
        if (contactList != null) {
            URI uri;
            String transport;
            ContactHeader contact = (ContactHeader)contactList.getFirst();
            HostPort hp = contact.getHostPort();
            if (hp != null) {
                localPort = hp.getPort();
            }
            String string = transport = (uri = contact.getAddress().getURI()).isSipURI() ? ((SipURI)uri).getTransportParam() : null;
            if (transport != null) {
                localTransport = transport;
            }
        }
        StackConnector stackConnector = this.sipConnectionNotifierImpl.getStackConnector();
        SipConnectionNotifierImpl newNotifier = (SipConnectionNotifierImpl)stackConnector.getSipConnectionNotifier(localPort, this.sipConnectionNotifierImpl.getMIMEType());
        return newNotifier;
    }

    public native void send0(int var1, String var2, String var3, String var4, String var5);

    private static String serializeHeader(SipConnection conn) {
        String[] keys = new String[]{"Call-ID", "Contact", "Content-Encoding", "Content-Type", "From", "To", "Subject", "Via"};
        String header = new String();
        for (int iKey = 0; iKey < keys.length; ++iKey) {
            String[] vals = null;
            try {
                vals = conn.getHeaders(keys[iKey]);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                System.out.println("Reason: " + e.getMessage());
                continue;
            }
            if (vals == null || vals.length == 0 || vals[0] == null) {
                header = header + keys[iKey] + DELIMITER + DELIMITER;
                continue;
            }
            for (int iVal = 0; iVal < vals.length; ++iVal) {
                header = header + keys[iKey] + DELIMITER + vals[iVal] + DELIMITER;
            }
        }
        return header;
    }

    public void setHeader(String name, String value) throws SipException, IllegalArgumentException {
        Message currentMessage;
        if (this.state != 2) {
            throw new SipException("the Header can not be set, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        Message message = currentMessage = this.useResponse ? this.response : this.request;
        if (currentMessage == null) {
            throw new SipException("Failure in setHeader(), associated request or response is null", 8);
        }
        currentMessage.attachHeader(header, true, true);
    }

    public void addHeader(String name, String value) throws SipException, IllegalArgumentException {
        Message currentMessage;
        if (this.state != 2) {
            throw new SipException("the Header can not be add, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("The header value can not be null");
        }
        Header header = null;
        try {
            header = StackConnector.headerFactory.createHeader(name, value);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("The header can not be created, check if it is correct");
        }
        Message message = currentMessage = this.useResponse ? this.response : this.request;
        if (currentMessage == null) {
            throw new SipException("Failure in addHeader(), associated request or response is null", 8);
        }
        currentMessage.addHeader(header);
    }

    public void removeHeader(String name) throws SipException, IllegalArgumentException {
        Message currentMessage;
        if (this.state != 2) {
            throw new SipException("the Header can not be removed, because of wrong state.", 5);
        }
        if (name == null) {
            throw new IllegalArgumentException("The header name can not be null");
        }
        Message message = currentMessage = this.useResponse ? this.response : this.request;
        if (currentMessage == null) {
            throw new SipException("Failure in removeHeader(), associated request or response is null", 8);
        }
        currentMessage.removeHeader(name, true);
    }

    public String[] getHeaders(String name) {
        Message currentMessage;
        Message message = currentMessage = this.useResponse ? this.response : this.request;
        if (currentMessage == null) {
            return null;
        }
        HeaderList nameList = currentMessage.getHeaderList(name);
        if (nameList == null) {
            return null;
        }
        int size = nameList.size();
        if (size < 1) {
            return null;
        }
        String[] headerValues = new String[size];
        for (int count = 0; count < size; ++count) {
            headerValues[count] = ((Header)nameList.elementAt(count)).getHeaderValue();
        }
        return headerValues;
    }

    public String getHeader(String name) {
        Message currentMessage;
        Message message = currentMessage = this.useResponse ? this.response : this.request;
        if (currentMessage == null) {
            return null;
        }
        Header header = currentMessage.getHeader(name);
        if (header == null) {
            return null;
        }
        return header.getHeaderValue();
    }

    public String getMethod() {
        if (0 == this.state) {
            return null;
        }
        return this.request.getMethod();
    }

    public String getRequestURI() {
        if (1 != this.state) {
            return null;
        }
        return this.request.getRequestURI().toString();
    }

    public int getStatusCode() {
        if (this.state != 2 || this.response == null) {
            return 0;
        }
        return this.response.getStatusCode();
    }

    public String getReasonPhrase() {
        if (this.state != 2 || this.response == null) {
            return null;
        }
        return this.response.getReasonPhrase();
    }

    public SipDialog getDialog() {
        byte dialogState;
        if (this.sipDialog != null && (dialogState = this.sipDialog.getState()) != 1 && dialogState != 2) {
            return null;
        }
        return this.sipDialog;
    }

    public InputStream openContentInputStream() throws IOException, SipException {
        if (this.state != 1) {
            throw new SipException("the content input stream can not be open, because of wrong state: " + this.state, 5);
        }
        if (this.request == null) {
            throw new IOException("Request is null.");
        }
        ContentLengthHeader contentLengthHeader = this.request.getContentLengthHeader();
        if (contentLengthHeader == null) {
            throw new IOException("Request contains no content length header.");
        }
        int bodyLength = contentLengthHeader.getContentLength();
        if (bodyLength == 0) {
            throw new IOException("Request's body has zero length.");
        }
        byte[] buf = this.request.getRawContent();
        if (buf == null) {
            throw new IOException("Body of SIP request is empty.");
        }
        this.contentInputStream = new ByteArrayInputStream(buf);
        return this.contentInputStream;
    }

    public OutputStream openContentOutputStream() throws IOException, SipException {
        if (this.state != 2) {
            throw new SipException("the content output strean can not be open, because of wrong state.", 5);
        }
        if (this.state == 0) {
            throw new IOException("can not open content output stream because SipServerConnection is TERMINATED");
        }
        if (this.response.getHeader("Content-Type") == null) {
            throw new SipException("Content-Type unknown, set the content-type header first", 3);
        }
        if (this.response.getHeader("Content-Length") == null) {
            throw new SipException("Content-Length unknown, set the content-length header first", 4);
        }
        this.contentOutputStream = new SDPOutputStream((SipConnection)this);
        this.state = 3;
        return this.contentOutputStream;
    }

    public void close() throws IOException {
        this.state = 0;
    }

    private void changeDialogState(ServerTransaction serverTransaction) {
        int statusCode = this.response.getStatusCode();
        if (statusCode == 100 || this.sipDialog == null) {
            return;
        }
        String cseqMethod = this.response.getCSeqHeader().getMethod();
        SipDialogImpl sipDialogImpl = (SipDialogImpl)this.sipDialog;
        if (cseqMethod.equals("NOTIFY")) {
            sipDialogImpl.handleNotify(this.request, serverTransaction.getDialog(), null);
            return;
        }
        int statusGroup = statusCode / 100;
        if (this.sipConnectionNotifierImpl.getStackConnector().getSipStack().isDialogCreated(cseqMethod) || cseqMethod.equals("BYE")) {
            byte state;
            if (statusGroup == 2) {
                sipDialogImpl.setDialog(serverTransaction.getDialog());
                sipDialogImpl.setState((byte)2);
                if (statusCode == 200) {
                    if (cseqMethod.equals("SUBSCRIBE") || cseqMethod.equals("REFER")) {
                        sipDialogImpl.addSubscription(new Subscription(sipDialogImpl.getDialog(), this.request));
                    } else if (cseqMethod.equals("BYE")) {
                        sipDialogImpl.setWaitForBye(false);
                        sipDialogImpl.terminateIfNoSubscriptions();
                    }
                }
            } else if (statusGroup == 1) {
                if (this.sipDialog.getState() == -1) {
                    sipDialogImpl.setState((byte)1);
                }
            } else {
                sipDialogImpl.terminateIfNoSubscriptions();
            }
            if (sipDialogImpl.getDialogID() == null && ((state = this.sipDialog.getState()) == 1 || state == 2)) {
                sipDialogImpl.setDialog(serverTransaction.getDialog());
                sipDialogImpl.setDialogID(this.response.getDialogId(true));
            }
        }
    }

    public int getState() {
        return this.state;
    }
}

