/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.microedition.sip;

import com.sun.kvem.netmon.NetMonProxy;
import com.sun.midp.io.j2me.socket.Protocol;
import com.sun.midp.security.SecurityToken;
import gov.nist.microedition.io.j2me.sip.DistributedRandom;
import gov.nist.microedition.sip.SipClientConnectionImpl;
import gov.nist.microedition.sip.SipConnectionNotifierImpl;
import gov.nist.siplite.ConfigurationProperties;
import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.ObjectInUseException;
import gov.nist.siplite.PeerUnavailableException;
import gov.nist.siplite.RequestEvent;
import gov.nist.siplite.ResponseEvent;
import gov.nist.siplite.SipFactory;
import gov.nist.siplite.SipListener;
import gov.nist.siplite.SipProvider;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.TimeoutEvent;
import gov.nist.siplite.TooManyListenersException;
import gov.nist.siplite.TransportNotSupportedException;
import gov.nist.siplite.address.AddressFactory;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.header.AcceptContactHeader;
import gov.nist.siplite.header.HeaderFactory;
import gov.nist.siplite.message.MessageFactory;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.ClientTransaction;
import gov.nist.siplite.stack.ServerTransaction;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.sip.SipClientConnection;
import javax.microedition.sip.SipConnectionNotifier;
import javax.microedition.sip.SipDialog;

public class StackConnector
implements SipListener {
    private SecurityToken classSecurityToken;
    private static StackConnector instance = null;
    protected SipStack sipStack = null;
    private String localAddress = null;
    private ListeningPoint tempListeningPoint = null;
    private SipProvider tempSipProvider = null;
    protected Vector connectionNotifiersList = new Vector();
    protected Vector sipDialogList = new Vector();
    public static AddressFactory addressFactory = null;
    public static MessageFactory messageFactory = null;
    public static HeaderFactory headerFactory = null;
    private ListeningPoint sharedListeningPoint = null;
    private SipProvider sharedSipProvider = null;
    int sharedPortNumber = -1;
    Vector sharedMimeTypes = null;
    private int md = -1;

    public native int openServerConn0(String var1, int var2);

    public native int openClientConn0(String var1, String var2, int var3);

    private StackConnector(SecurityToken classSecurityToken) throws IOException {
        SipFactory sipFactory = SipFactory.getInstance();
        ConfigurationProperties properties = new ConfigurationProperties();
        int randomPort = new DistributedRandom().nextInt(60000) + 1024;
        Protocol conn = new Protocol();
        ServerSocketConnection serverSoc = (ServerSocketConnection)conn.openPrim(classSecurityToken, "//:" + randomPort);
        this.localAddress = serverSoc.getLocalAddress();
        properties.setProperty("javax.sip.IP_ADDRESS", this.localAddress);
        properties.setProperty("javax.sip.STACK_NAME", "shootme");
        properties.setProperty("gov.nist.javax.sip.LOG_FILE_NAME", "/tmp/jsr180-log");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "0");
        serverSoc.close();
        try {
            this.sipStack = sipFactory.createSipStack(properties, classSecurityToken);
            this.sipStack.setStackConnector(this);
        }
        catch (PeerUnavailableException e) {
            throw new IOException(e.getMessage());
        }
        this.classSecurityToken = classSecurityToken;
    }

    public static synchronized StackConnector getInstance(SecurityToken classSecurityToken) throws IOException {
        if (instance == null) {
            instance = new StackConnector(classSecurityToken);
        }
        return instance;
    }

    public static synchronized void releaseInstance() {
        instance = null;
    }

    public SipConnectionNotifier createSharedSipConnectionNotifier(boolean secure, String transport, String mimeType) throws IOException {
        if (this.sharedMimeTypes != null) {
            for (int i = 0; i < this.sharedMimeTypes.size(); ++i) {
                if (!mimeType.equalsIgnoreCase((String)this.sharedMimeTypes.elementAt(i))) continue;
                throw new IOException("Application type is already reserved");
            }
        } else {
            this.sharedMimeTypes = new Vector();
        }
        this.sharedMimeTypes.addElement(mimeType);
        if (this.sharedListeningPoint == null && this.sharedSipProvider == null) {
            this.sharedPortNumber = this.selectPort(this.sharedPortNumber, transport);
            this.sharedListeningPoint = this.tempListeningPoint;
            this.sharedSipProvider = this.tempSipProvider;
        }
        SipConnectionNotifierImpl sipConnectionNotifier = new SipConnectionNotifierImpl(this.sharedSipProvider, this.localAddress, this.sharedPortNumber, this.classSecurityToken, mimeType, true);
        this.connectionNotifiersList.addElement(sipConnectionNotifier);
        return sipConnectionNotifier;
    }

    private int selectPort(int portNumber, String transport) throws IOException {
        boolean isRandomPort;
        boolean bl = isRandomPort = portNumber == -1;
        do {
            if (isRandomPort) {
                portNumber = new DistributedRandom().nextInt(8975) + 1024;
            }
            try {
                this.tempListeningPoint = this.sipStack.createListeningPoint(portNumber, transport);
            }
            catch (TransportNotSupportedException tnse) {
                throw new IOException(tnse.getMessage());
            }
            try {
                this.tempSipProvider = this.sipStack.createSipProvider(this.tempListeningPoint);
            }
            catch (ObjectInUseException oiue) {
                if (isRandomPort) continue;
                throw new ObjectInUseException(oiue.getMessage());
            }
            isRandomPort = false;
            try {
                this.tempSipProvider.addSipListener(this);
            }
            catch (TooManyListenersException tmle) {
                throw new IOException(tmle.getMessage());
            }
        } while (isRandomPort);
        return portNumber;
    }

    public SipConnectionNotifier createSipConnectionNotifier(int portNumber, boolean secure, String transport, String mimeType) throws IOException {
        portNumber = this.selectPort(portNumber, transport);
        SipConnectionNotifierImpl sipConnectionNotifier = new SipConnectionNotifierImpl(this.tempSipProvider, this.localAddress, portNumber, this.classSecurityToken, mimeType, false);
        this.connectionNotifiersList.addElement(sipConnectionNotifier);
        if (NetMonProxy.isNetworkMonitorActive0()) {
            this.md = this.openServerConn0("", portNumber);
            sipConnectionNotifier.setMd(this.md);
        }
        return sipConnectionNotifier;
    }

    public SipClientConnection createSipClientConnection(SipURI inputURI) {
        SipClientConnectionImpl sipClientConnection = new SipClientConnectionImpl(inputURI, this.classSecurityToken);
        if (NetMonProxy.isNetworkMonitorActive0()) {
            this.md = this.openClientConn0("", inputURI.toString(), inputURI.getPort());
            sipClientConnection.setMd(this.md);
        }
        return sipClientConnection;
    }

    public Vector getConnectionNotifiersList() {
        return this.connectionNotifiersList;
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public SipConnectionNotifier getSipConnectionNotifier(int portNumber, String acceptContactType) {
        Enumeration e = this.connectionNotifiersList.elements();
        while (e.hasMoreElements()) {
            SipConnectionNotifier sipConnectionNotifier = (SipConnectionNotifier)e.nextElement();
            try {
                if (sipConnectionNotifier.getLocalPort() != portNumber) continue;
                if (acceptContactType != null) {
                    String scnMimeType = ((SipConnectionNotifierImpl)sipConnectionNotifier).getMIMEType();
                    if (scnMimeType == null || !scnMimeType.equalsIgnoreCase(acceptContactType)) continue;
                    return sipConnectionNotifier;
                }
                return sipConnectionNotifier;
            }
            catch (IOException ioe) {
            }
        }
        return null;
    }

    protected static String generateTag() {
        return String.valueOf(new Random().nextInt(Integer.MAX_VALUE));
    }

    protected SipDialog findDialog(String dialogID) {
        Enumeration e = this.sipDialogList.elements();
        while (e.hasMoreElements()) {
            SipDialog sipDialog = (SipDialog)e.nextElement();
            if (sipDialog.getDialogID() == null || !sipDialog.getDialogID().equals(dialogID)) continue;
            return sipDialog;
        }
        return null;
    }

    public void processRequest(RequestEvent requestEvent) {
        try {
            String acceptContactType = null;
            Request request = requestEvent.getRequest();
            AcceptContactHeader acHdr = request.getAcceptContact();
            if (acHdr != null) {
                acceptContactType = acHdr.getType();
            }
            SipConnectionNotifierImpl sipConnectionNotifier = null;
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            if (serverTransaction != null) {
                sipConnectionNotifier = (SipConnectionNotifierImpl)serverTransaction.getApplicationData();
            }
            if (sipConnectionNotifier == null) {
                SipProvider sipProvider = (SipProvider)requestEvent.getSource();
                ListeningPoint listeningPoint = sipProvider.getListeningPoint();
                sipConnectionNotifier = (SipConnectionNotifierImpl)this.getSipConnectionNotifier(listeningPoint.getPort(), acceptContactType);
                if (serverTransaction != null && sipConnectionNotifier != null) {
                    serverTransaction.setApplicationData(sipConnectionNotifier);
                }
            }
            if (sipConnectionNotifier != null) {
                sipConnectionNotifier.notifyRequestReceived(request);
            }
        }
        catch (NullPointerException npe) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        block6: {
            try {
                Response response = responseEvent.getResponse();
                ClientTransaction clientTransaction = responseEvent.getClientTransaction();
                SipClientConnectionImpl sipClientConnection = (SipClientConnectionImpl)clientTransaction.getApplicationData();
                if (sipClientConnection != null) {
                    if (sipClientConnection.getClientTransaction().equals(clientTransaction)) {
                        sipClientConnection.notifyResponseReceived(response, null);
                    } else {
                        sipClientConnection.notifyResponseReceived(response, clientTransaction);
                    }
                    break block6;
                }
                throw new RuntimeException("we cannot find any client connectionmatching to handle this request");
            }
            catch (NullPointerException npe) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
    }

    public void closeSharedSipConnectionNotifier(String mimeType) throws IOException {
        this.sharedMimeTypes.removeElement(mimeType);
        if (this.sharedMimeTypes.size() == 0) {
            try {
                this.sipStack.deleteListeningPoint(this.sharedListeningPoint);
                this.sipStack.deleteSipProvider(this.sharedSipProvider);
            }
            catch (ObjectInUseException oiue) {
                throw new IOException(oiue.getMessage());
            }
            this.sharedMimeTypes = null;
            this.sipStack.stopStack();
        }
    }

    static {
        messageFactory = new MessageFactory();
        addressFactory = new AddressFactory();
        headerFactory = new HeaderFactory();
    }
}

