/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite;

import gov.nist.siplite.EventWrapper;
import gov.nist.siplite.RequestEvent;
import gov.nist.siplite.ResponseEvent;
import gov.nist.siplite.SipEvent;
import gov.nist.siplite.SipListener;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.TimeoutEvent;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.stack.ClientTransaction;
import gov.nist.siplite.stack.Transaction;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class EventScanner
implements Runnable {
    private SipStack sipStack;
    private Vector pendingEvents;
    private SipListener sipListener;
    private boolean isStopped;

    public EventScanner(SipStack sipStack) {
        this.sipStack = sipStack;
        this.pendingEvents = new Vector();
    }

    public void start() {
        Thread myThread = new Thread(this);
        myThread.setPriority(10);
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Vector vector = this.pendingEvents;
        synchronized (vector) {
            this.isStopped = true;
            this.pendingEvents.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(EventWrapper eventWrapper) {
        Vector vector = this.pendingEvents;
        synchronized (vector) {
            this.pendingEvents.addElement(eventWrapper);
            this.pendingEvents.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            SipEvent sipEvent = null;
            EventWrapper eventWrapper = null;
            Vector vector = this.pendingEvents;
            synchronized (vector) {
                if (this.pendingEvents.isEmpty()) {
                    try {
                        this.pendingEvents.wait();
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                }
                if (this.isStopped) {
                    return;
                }
                SipListener sipListener = this.sipStack.getSipListener();
                Enumeration iterator = this.pendingEvents.elements();
                while (iterator.hasMoreElements()) {
                    eventWrapper = (EventWrapper)iterator.nextElement();
                    sipEvent = eventWrapper.sipEvent;
                    try {
                        if (sipEvent instanceof RequestEvent) {
                            Transaction tr;
                            Request sipRequest = ((RequestEvent)sipEvent).getRequest();
                            if (sipRequest.getMethod().equals("CANCEL") && (tr = this.sipStack.findTransaction(sipRequest, true)) != null && tr.getState() == 6) {
                                try {
                                    tr.sendMessage(sipRequest.createResponse(200));
                                }
                                catch (IOException ex) {}
                                continue;
                            }
                            sipListener.processRequest((RequestEvent)sipEvent);
                            continue;
                        }
                        if (sipEvent instanceof ResponseEvent) {
                            sipListener.processResponse((ResponseEvent)sipEvent);
                            ClientTransaction ct = ((ResponseEvent)sipEvent).getClientTransaction();
                            ct.clearEventPending();
                            continue;
                        }
                        if (!(sipEvent instanceof TimeoutEvent)) continue;
                        sipListener.processTimeout((TimeoutEvent)sipEvent);
                        if (eventWrapper.transaction == null || !(eventWrapper.transaction instanceof ClientTransaction)) continue;
                        ((ClientTransaction)eventWrapper.transaction).clearEventPending();
                    }
                    catch (Throwable exc) {}
                }
                this.pendingEvents.removeAllElements();
            }
        }
    }
}

