/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite;

import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.NistSipMessageHandlerImpl;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.SIPServerRequestInterface;
import gov.nist.siplite.stack.SIPServerResponseInterface;
import gov.nist.siplite.stack.SIPStackMessageFactory;
import gov.nist.siplite.stack.SIPTransactionStack;
import gov.nist.siplite.stack.Transaction;

public class NistSipMessageFactoryImpl
implements SIPStackMessageFactory {
    private SipStack sipStackImpl;

    public SIPServerRequestInterface newSIPServerRequest(Request sipRequest, MessageChannel messageChannel) throws IllegalArgumentException {
        if (messageChannel == null || sipRequest == null) {
            throw new IllegalArgumentException("Null Arg!");
        }
        NistSipMessageHandlerImpl retval = new NistSipMessageHandlerImpl();
        if (messageChannel instanceof Transaction) {
            retval.transactionChannel = (Transaction)messageChannel;
        }
        SIPTransactionStack theStack = (SIPTransactionStack)messageChannel.getSIPStack();
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        return retval;
    }

    public SIPServerResponseInterface newSIPServerResponse(Response sipResponse, MessageChannel messageChannel) {
        try {
            ListeningPoint lp;
            Transaction tr;
            NistSipMessageHandlerImpl retval = new NistSipMessageHandlerImpl();
            SIPTransactionStack theStack = (SIPTransactionStack)messageChannel.getSIPStack();
            SipStack sipStackImpl = (SipStack)theStack;
            retval.transactionChannel = tr = theStack.findTransaction(sipResponse, false);
            retval.listeningPoint = lp = messageChannel.getMessageProcessor().getListeningPoint();
            return retval;
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    public NistSipMessageFactoryImpl(SipStack sipStackImpl) {
        this.sipStackImpl = sipStackImpl;
    }
}

