/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite;

import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.RequestEvent;
import gov.nist.siplite.ResponseEvent;
import gov.nist.siplite.SipListener;
import gov.nist.siplite.SipProvider;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.ClientTransaction;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.SIPServerException;
import gov.nist.siplite.stack.SIPServerRequestInterface;
import gov.nist.siplite.stack.SIPServerResponseInterface;
import gov.nist.siplite.stack.ServerTransaction;
import gov.nist.siplite.stack.Transaction;

public class NistSipMessageHandlerImpl
implements SIPServerRequestInterface,
SIPServerResponseInterface {
    protected Transaction transactionChannel;
    protected MessageChannel rawMessageChannel;
    protected ListeningPoint listeningPoint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(Request sipRequest, MessageChannel incomingMessageChannel) throws SIPServerException {
        this.rawMessageChannel = incomingMessageChannel;
        SipStack sipStack = (SipStack)this.transactionChannel.getSIPStack();
        this.listeningPoint = incomingMessageChannel.getMessageProcessor().getListeningPoint();
        if (this.listeningPoint == null) {
            return;
        }
        SipProvider sipProvider = this.listeningPoint.getProvider();
        if (sipProvider == null) {
            return;
        }
        SipListener sipListener = sipProvider.sipListener;
        Transaction transaction = this.transactionChannel;
        SipProvider sipProvider2 = sipProvider;
        synchronized (sipProvider2) {
            RequestEvent sipEvent;
            String dialogId = sipRequest.getDialogId(true);
            Dialog dialog = sipStack.getDialog(dialogId);
            ServerTransaction requestTransaction = (ServerTransaction)sipRequest.getTransaction();
            if (null == requestTransaction.getDialog()) {
                requestTransaction.setDialog(dialog);
            }
            if (sipRequest.getMethod().equals("ACK")) {
                if (dialog == null) {
                    transaction = sipStack.findTransaction(sipRequest, true);
                } else if (dialog.getLastAck() != null && dialog.getLastAck().equals(sipRequest)) {
                    if (sipStack.isRetransmissionFilterActive()) {
                        dialog.ackReceived(sipRequest);
                        transaction.setDialog(dialog);
                        return;
                    }
                } else {
                    Transaction tr = dialog.getLastTransaction();
                    Response sipResponse = tr.getLastResponse();
                    if (tr instanceof ServerTransaction && sipResponse != null && sipResponse.getStatusCode() / 100 == 2 && sipResponse.getCSeqHeader().getSequenceNumber() == sipRequest.getCSeqHeader().getSequenceNumber()) {
                        transaction.setDialog(dialog);
                        dialog.ackReceived(sipRequest);
                        if (sipStack.isRetransmissionFilterActive() && tr.isAckSeen()) {
                            return;
                        }
                        tr.setAckSeen();
                    } else {
                        if (tr == null) {
                            return;
                        }
                        transaction = tr;
                        if (transaction instanceof ClientTransaction) {
                            return;
                        }
                    }
                }
            } else if (sipRequest.getMethod().equals("BYE")) {
                transaction = this.transactionChannel;
                if (transaction != null && ((ServerTransaction)transaction).isTransactionMapped()) {
                    if (dialog != null) {
                        dialog.addTransaction(transaction);
                    } else {
                        dialogId = sipRequest.getDialogId(false);
                        dialog = sipStack.getDialog(dialogId);
                        if (dialog != null) {
                            dialog.addTransaction(transaction);
                        } else {
                            transaction = null;
                        }
                    }
                } else if (transaction != null) {
                    if (dialog != null) {
                        return;
                    }
                    transaction = null;
                }
            } else if (sipRequest.getRequestLine().getMethod().equals("CANCEL")) {
                ServerTransaction serverTransaction = (ServerTransaction)sipStack.findCancelTransaction(sipRequest, true);
                transaction = serverTransaction == null ? null : serverTransaction;
            }
            if (!(dialog == null || transaction == null || sipRequest.getMethod().equals("BYE") || sipRequest.getMethod().equals("CANCEL") || sipRequest.getMethod().equals("ACK"))) {
                if (dialog.getRemoteSequenceNumber() >= sipRequest.getCSeqHeader().getSequenceNumber()) {
                    return;
                }
                dialog.addTransaction(transaction);
                dialog.addRoute(sipRequest);
            }
            if (dialog == null && sipRequest.getMethod().equals("NOTIFY")) {
                ClientTransaction ct = sipStack.findSubscribeTransaction(sipRequest);
                if (ct != null) {
                    transaction.setDialog(ct.getDialog());
                    sipEvent = ct.getDialog().getState() == -1 ? new RequestEvent(sipProvider, null, sipRequest) : new RequestEvent(sipProvider, (ServerTransaction)transaction, sipRequest);
                } else {
                    sipEvent = new RequestEvent(sipProvider, null, sipRequest);
                }
            } else {
                sipEvent = transaction != null && ((ServerTransaction)transaction).isTransactionMapped() ? new RequestEvent(sipProvider, (ServerTransaction)transaction, sipRequest) : new RequestEvent(sipProvider, null, sipRequest);
            }
            sipProvider.handleEvent(sipEvent, transaction);
        }
    }

    public void processResponse(Response sipResponse, MessageChannel incomingMessageChannel) throws SIPServerException {
        try {
            this.listeningPoint = incomingMessageChannel.getMessageProcessor().getListeningPoint();
            if (this.listeningPoint == null) {
                return;
            }
            Transaction transaction = this.transactionChannel;
            SipProvider sipProvider = this.listeningPoint.getProvider();
            if (sipProvider == null) {
                return;
            }
            SipStack sipStack = sipProvider.sipStack;
            if (this.transactionChannel == null) {
                String dialogId = sipResponse.getDialogId(false);
                Dialog dialog = sipStack.getDialog(dialogId);
                if (sipProvider.sipListener == null) {
                    return;
                }
                if (dialog != null) {
                    if (sipResponse.getStatusCode() != 200) {
                        return;
                    }
                    if (sipStack.isRetransmissionFilterActive() && sipResponse.getCSeqHeader().equals(dialog.getFirstTransaction().getRequest().getHeader("CSeq"))) {
                        dialog.resendAck();
                        return;
                    }
                }
                ResponseEvent sipEvent = new ResponseEvent(sipProvider, null, sipResponse);
                sipProvider.handleEvent(sipEvent, transaction);
                return;
            }
            this.rawMessageChannel = incomingMessageChannel;
            String method = sipResponse.getCSeqHeader().getMethod();
            ClientTransaction clientTransaction = (ClientTransaction)this.transactionChannel;
            Dialog dialog = null;
            if (transaction != null) {
                dialog = transaction.getDialog();
            }
            SipListener sipListener = sipProvider.sipListener;
            ResponseEvent responseEvent = new ResponseEvent(sipProvider, (ClientTransaction)transaction, sipResponse);
            sipProvider.handleEvent(responseEvent, transaction);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public MessageChannel getRequestChannel() {
        return this.transactionChannel;
    }

    public MessageChannel getResponseChannel() {
        if (this.transactionChannel != null) {
            return this.transactionChannel;
        }
        return this.rawMessageChannel;
    }

    public String getProcessingInfo() {
        return null;
    }
}

