/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite;

import gov.nist.siplite.AuthenticationListener;
import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.RequestEvent;
import gov.nist.siplite.ResponseEvent;
import gov.nist.siplite.SipListener;
import gov.nist.siplite.SipProvider;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.TimeoutEvent;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.header.CSeqHeader;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.HeaderFactory;
import gov.nist.siplite.header.MaxForwardsHeader;
import gov.nist.siplite.message.MessageFactory;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.ClientTransaction;
import java.io.IOException;
import javax.microedition.sip.SipException;

public class RegistrationHelper
implements SipListener,
Runnable {
    private SipStack sipStack;
    private SipProvider sipProvider;
    private MessageFactory messageFactory;
    private HeaderFactory headerFactory;
    private String userName;
    private String userAddress;
    private ListeningPoint lp;
    private Thread myThread;
    protected boolean successfulRegistration;
    private AuthenticationListener authenticationListener;
    private int countReoriginateRequest = 1;

    public RegistrationHelper(SipStack myStack, String userName, String userAddress, ListeningPoint lp) {
        this.sipStack = myStack;
        this.userName = userName;
        this.userAddress = userAddress;
        this.messageFactory = new MessageFactory();
        this.headerFactory = new HeaderFactory();
        this.lp = lp;
        this.myThread = new Thread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegister() {
        this.myThread.start();
        RegistrationHelper registrationHelper = this;
        synchronized (registrationHelper) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.sipStack.stackInitialized = false;
            Hop hop = this.sipStack.getRouter().getOutboundProxy();
            this.sipProvider = this.lp.getProvider();
            StringBuffer requestLine = new StringBuffer("REGISTER sip:").append(this.sipStack.getNextHop().getHost()).append(":").append(this.sipStack.getNextHop().getPort()).append(";transport=" + hop.getTransport()).append(" SIP/2.0\r\n");
            StringBuffer from = new StringBuffer("From: <sip:").append(this.userName).append("@").append(this.userAddress).append(">;tag=1234\r\n");
            StringBuffer to = new StringBuffer("To: <sip:").append(this.userName).append("@").append(this.userAddress).append(">\r\n");
            String via = this.lp.messageProcessor.getViaHeader().toString();
            int port = this.lp.getPort();
            StringBuffer contact = new StringBuffer("Contact: <sip:" + this.userName + "@" + this.sipStack.getIPAddress() + ":" + port + ";transport=" + hop.getTransport() + ">\r\n");
            CallIdHeader callId = this.sipProvider.getNewCallId();
            CSeqHeader cseq = new CSeqHeader();
            cseq.setMethod("REGISTER");
            cseq.setSequenceNumber(1);
            MaxForwardsHeader maxForwards = new MaxForwardsHeader();
            maxForwards.setMaxForwards(1);
            String registerRequest = requestLine + via + callId.toString() + cseq.toString() + maxForwards.toString() + from + to + contact;
            Request request = this.messageFactory.createRequest(registerRequest);
            ClientTransaction ct = this.sipProvider.getNewClientTransaction(request);
            ct.sendRequest();
        }
        catch (Exception ex) {
            RegistrationHelper registrationHelper = this;
            synchronized (registrationHelper) {
                this.notify();
            }
        }
    }

    public void processRequest(RequestEvent requestEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(ResponseEvent responseEvent) {
        Response response = responseEvent.getResponse();
        if (response.getStatusCode() == 200) {
            this.successfulRegistration = true;
            RegistrationHelper registrationHelper = this;
            synchronized (registrationHelper) {
                this.notify();
            }
        }
        if (response.getStatusCode() == 407 || response.getStatusCode() == 401) {
            Throwable ex = null;
            try {
                ClientTransaction clientTransac = responseEvent.getClientTransaction();
                Request newRequest = this.authenticationListener.createNewRequest(this.sipStack, clientTransac.getRequest(), response, this.countReoriginateRequest);
                if (newRequest == null) {
                    return;
                }
                ++this.countReoriginateRequest;
                ClientTransaction ct = this.sipProvider.getNewClientTransaction(newRequest);
                ct.sendRequest();
            }
            catch (SipException se) {
                ex = se;
            }
            catch (IOException ioe) {
                ex = ioe;
            }
            if (ex != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimeout(TimeoutEvent timeoutEvent) {
        RegistrationHelper registrationHelper = this;
        synchronized (registrationHelper) {
            this.notify();
        }
    }
}

