/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite;

import gov.nist.siplite.EventScanner;
import gov.nist.siplite.EventWrapper;
import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.SIPUtils;
import gov.nist.siplite.SipEvent;
import gov.nist.siplite.SipListener;
import gov.nist.siplite.SipStack;
import gov.nist.siplite.Timeout;
import gov.nist.siplite.TimeoutEvent;
import gov.nist.siplite.TooManyListenersException;
import gov.nist.siplite.TransactionAlreadyExistsException;
import gov.nist.siplite.TransactionUnavailableException;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.header.CallIdHeader;
import gov.nist.siplite.header.RouteHeader;
import gov.nist.siplite.header.ViaHeader;
import gov.nist.siplite.message.Request;
import gov.nist.siplite.message.Response;
import gov.nist.siplite.stack.ClientTransaction;
import gov.nist.siplite.stack.Dialog;
import gov.nist.siplite.stack.MessageChannel;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPTransactionErrorEvent;
import gov.nist.siplite.stack.SIPTransactionEventListener;
import gov.nist.siplite.stack.ServerTransaction;
import gov.nist.siplite.stack.Transaction;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.sip.SipException;

public final class SipProvider
implements SIPTransactionEventListener {
    protected SipListener sipListener;
    protected boolean isActive;
    protected SipStack sipStack;
    protected ListeningPoint listeningPoint;
    protected ServerTransaction currentTransaction;
    private EventScanner eventScanner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        SipProvider sipProvider = this;
        synchronized (sipProvider) {
            this.listeningPoint.removeSipProvider();
        }
        this.eventScanner.stop();
    }

    public void handleEvent(SipEvent sipEvent, Transaction transaction) {
        if (this.sipListener == null) {
            return;
        }
        EventWrapper eventWrapper = new EventWrapper();
        eventWrapper.sipEvent = sipEvent;
        eventWrapper.transaction = transaction;
        if (transaction != null && transaction instanceof ClientTransaction) {
            ((ClientTransaction)transaction).setEventPending();
        }
        this.eventScanner.addEvent(eventWrapper);
    }

    protected SipProvider(SipStack sipStack) {
        this.sipStack = sipStack;
        this.eventScanner = sipStack.eventScanner;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSipListener(SipListener sipListener) throws TooManyListenersException {
        SipProvider provider;
        Enumeration it;
        SipStack sipStack = this.sipStack;
        synchronized (sipStack) {
            it = this.sipStack.getSipProviders();
            while (it.hasMoreElements()) {
                provider = (SipProvider)it.nextElement();
                if (provider.sipListener == null || provider.sipListener == sipListener) continue;
                throw new TooManyListenersException();
            }
        }
        this.sipListener = sipListener;
        this.sipStack.sipListener = sipListener;
        sipStack = this.sipStack;
        synchronized (sipStack) {
            it = this.sipStack.getSipProviders();
            while (it.hasMoreElements()) {
                provider = (SipProvider)it.nextElement();
                provider.sipListener = sipListener;
            }
        }
    }

    public ListeningPoint getListeningPoint() {
        return this.listeningPoint;
    }

    public CallIdHeader getNewCallId() {
        String callId = SIPUtils.generateCallIdentifier(this.getSipStack().getIPAddress());
        CallIdHeader callid = new CallIdHeader();
        callid.setCallId(callId);
        return callid;
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        block20: {
            Enumeration it;
            int dialogState;
            ClientTransaction ct;
            if (request == null) {
                throw new NullPointerException("null request");
            }
            if (request.getTransaction() != null) {
                throw new TransactionUnavailableException("Transaction already assigned to request");
            }
            if (request.getMethod().equals("CANCEL") && (ct = (ClientTransaction)this.sipStack.findCancelTransaction(request, false)) != null) {
                ClientTransaction retval = this.sipStack.createClientTransaction(ct.getMessageChannel());
                retval.setOriginalRequest(request);
                retval.addEventListener(this);
                this.sipStack.addTransaction(retval);
                retval.setDialog(ct.getDialog());
                return retval;
            }
            String dialogId = request.getDialogId(false);
            Dialog dialog = this.sipStack.getDialog(dialogId);
            boolean isDialog = false;
            if (dialog != null && ((dialogState = dialog.getState()) == 1 || dialogState == 2 || dialogState == 3)) {
                isDialog = true;
            }
            if ((it = this.sipStack.getRouter().getNextHops(request, isDialog)) == null || !it.hasMoreElements()) {
                if (dialog != null) {
                    try {
                        Hop hop = dialog.getNextHop();
                        if (hop != null) {
                            ClientTransaction ct2 = null;
                            ct2 = (ClientTransaction)this.sipStack.createMessageChannel(hop);
                            String branchId = SIPUtils.generateBranchId();
                            if (request.getTopmostVia() != null) {
                                request.getTopmostVia().setBranch(branchId);
                            } else {
                                MessageProcessor messageProcessor = this.listeningPoint.messageProcessor;
                                ViaHeader via = messageProcessor.getViaHeader();
                                request.addHeader(via);
                            }
                            ct2.setOriginalRequest(request);
                            ct2.setBranch(branchId);
                            ct2.setDialog(dialog);
                            ct2.addEventListener(this);
                            return ct2;
                        }
                        break block20;
                    }
                    catch (Exception ex) {
                        throw new TransactionUnavailableException(ex.getMessage());
                    }
                }
                throw new TransactionUnavailableException("no route!");
            }
            try {
                while (it.hasMoreElements()) {
                    Hop hop = (Hop)it.nextElement();
                    ClientTransaction ct3 = null;
                    ct3 = (ClientTransaction)this.sipStack.createMessageChannel(hop);
                    if (ct3 == null) continue;
                    String branchId = SIPUtils.generateBranchId();
                    if (request.getTopmostVia() != null) {
                        request.getTopmostVia().setBranch(branchId);
                    } else {
                        MessageProcessor messageProcessor = this.listeningPoint.messageProcessor;
                        ViaHeader via = messageProcessor.getViaHeader();
                        request.addHeader(via);
                    }
                    ct3.setOriginalRequest(request);
                    ct3.setBranch(branchId);
                    if (this.sipStack.isDialogCreated(request.getMethod())) {
                        if (dialog != null) {
                            ct3.setDialog(dialog);
                        } else {
                            this.sipStack.createDialog(ct3);
                        }
                    } else {
                        ct3.setDialog(dialog);
                    }
                    ct3.addEventListener(this);
                    return ct3;
                }
            }
            catch (SipException ex) {
                throw new TransactionUnavailableException(ex.getMessage());
            }
        }
        throw new TransactionUnavailableException("Could not create transaction - could not resolve next hop! ");
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        try {
            ServerTransaction transaction = null;
            Request sipRequest = request;
            if (this.sipStack.isDialogCreated(sipRequest.getMethod())) {
                if (this.sipStack.findTransaction(request, true) != null) {
                    throw new TransactionAlreadyExistsException("server transaction already exists!");
                }
                transaction = this.currentTransaction;
                if (transaction == null) {
                    throw new TransactionUnavailableException("Transaction not available");
                }
                if (!transaction.isMessagePartOfTransaction(request)) {
                    throw new TransactionUnavailableException("Request Mismatch");
                }
                transaction.setOriginalRequest(sipRequest);
                try {
                    this.sipStack.addTransaction(transaction);
                }
                catch (IOException ex) {
                    throw new TransactionUnavailableException("Error sending provisional response");
                }
                this.equipADialogForTransaction(transaction, sipRequest);
            } else {
                transaction = (ServerTransaction)this.sipStack.findTransaction(request, true);
                if (transaction != null) {
                    throw new TransactionAlreadyExistsException("Transaction exists! ");
                }
                transaction = this.currentTransaction;
                if (transaction == null) {
                    throw new TransactionUnavailableException("Transaction not available!");
                }
                if (!transaction.isMessagePartOfTransaction(request)) {
                    throw new TransactionUnavailableException("Request Mismatch");
                }
                transaction.setOriginalRequest(sipRequest);
                try {
                    this.sipStack.addTransaction(transaction);
                }
                catch (IOException ex) {
                    throw new TransactionUnavailableException("Could not send back provisional response!");
                }
                String dialogId = sipRequest.getDialogId(true);
                Dialog dialog = this.sipStack.getDialog(dialogId);
                if (dialog != null) {
                    dialog.addTransaction(transaction);
                    dialog.addRoute(sipRequest);
                }
            }
            return transaction;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void equipADialogForTransaction(ServerTransaction transaction, Request sipRequest) {
        transaction.addEventListener(this);
        String dialogId = sipRequest.getDialogId(true);
        Dialog dialog = this.sipStack.getDialog(dialogId);
        if (dialog == null) {
            dialog = this.sipStack.createDialog(transaction);
        }
        dialog.setStack(this.sipStack);
        dialog.addRoute(sipRequest);
        if (dialog.getRemoteTag() != null && dialog.getLocalTag() != null) {
            this.sipStack.putDialog(dialog);
        }
        transaction.setDialog(dialog);
    }

    public SipStack getSipStack() {
        return this.sipStack;
    }

    public void removeSipListener(SipListener sipListener) {
        if (sipListener == this.sipListener) {
            this.sipListener = null;
        }
    }

    public void sendRequest(Request request) throws SipException {
        Enumeration it = this.sipStack.getRouter().getNextHops(request, false);
        if (it == null || !it.hasMoreElements()) {
            throw new SipException("could not determine next hop!", 0);
        }
        Transaction tr = this.sipStack.findTransaction(request, false);
        if (tr != null) {
            throw new SipException("Cannot send: stateless Transaction found!", 0);
        }
        while (it.hasMoreElements()) {
            Request newRequest;
            Hop nextHop = (Hop)it.nextElement();
            Request sipRequest = request;
            String bid = sipRequest.getTransactionId();
            ViaHeader via = sipRequest.getTopmostVia();
            via.setBranch(bid);
            if (sipRequest.getHeader("Route") != null) {
                newRequest = (Request)sipRequest.clone();
                Enumeration rl = newRequest.getHeaders("Route");
                RouteHeader route = (RouteHeader)rl.nextElement();
                newRequest.setRequestURI(route.getAddress().getURI());
                sipRequest.removeHeader("Route", true);
            } else {
                newRequest = sipRequest;
            }
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(nextHop);
            try {
                if (messageChannel != null) {
                    messageChannel.sendMessage(newRequest);
                    return;
                }
                throw new SipException("Could not forward request.", 0);
            }
            catch (IOException ex) {
            }
        }
    }

    public void sendResponse(Response sipResponse) throws IOException, SipException {
        ViaHeader via = sipResponse.getTopmostVia();
        if (via == null) {
            throw new SipException("No via header in response!", 8);
        }
        int port = via.getPort();
        String transport = via.getTransport();
        String host = via.getReceived();
        if (host == null) {
            host = via.getHost();
        }
        if (port == -1) {
            port = 5060;
        }
        Hop hop = new Hop(host + ":" + port + "/" + transport);
        MessageChannel messageChannel = this.sipStack.createRawMessageChannel(hop);
        messageChannel.sendMessage(sipResponse);
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        if (listeningPoint == null) {
            throw new NullPointerException("Null listening point");
        }
        ListeningPoint lp = listeningPoint;
        lp.sipProviderImpl = this;
        this.listeningPoint = listeningPoint;
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        Transaction transaction = transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            Transaction errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof ServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject) : new TimeoutEvent(this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, errorObject);
        } else {
            Transaction errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof ServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject) : new TimeoutEvent(this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, errorObject);
        }
    }
}

