/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite;

import com.sun.midp.security.SecurityToken;
import gov.nist.core.StringTokenizer;
import gov.nist.core.Utils;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.ConfigurationProperties;
import gov.nist.siplite.EventScanner;
import gov.nist.siplite.ListeningPoint;
import gov.nist.siplite.NistSipMessageFactoryImpl;
import gov.nist.siplite.ObjectInUseException;
import gov.nist.siplite.PeerUnavailableException;
import gov.nist.siplite.SipListener;
import gov.nist.siplite.SipProvider;
import gov.nist.siplite.TransportNotSupportedException;
import gov.nist.siplite.address.Hop;
import gov.nist.siplite.address.Router;
import gov.nist.siplite.stack.MessageProcessor;
import gov.nist.siplite.stack.SIPTransactionErrorEvent;
import gov.nist.siplite.stack.SIPTransactionStack;
import gov.nist.siplite.stack.Transaction;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SipStack
extends SIPTransactionStack {
    private Hashtable listeningPoints;
    private Vector sipProviders;
    protected boolean stackInitialized;
    protected String routerPath;
    protected EventScanner eventScanner;
    protected SipListener sipListener;
    protected StackConnector sipStackConnector;
    private String logFilename = null;
    protected String outboundProxy = null;
    protected int outboundPort = -1;

    public void setStackConnector(StackConnector stackConnector) {
        this.sipStackConnector = stackConnector;
    }

    protected SipStack() {
        NistSipMessageFactoryImpl msgFactory = new NistSipMessageFactoryImpl(this);
        super.setMessageFactory(msgFactory);
        this.listeningPoints = new Hashtable();
        this.sipProviders = new Vector();
    }

    public void stopStack() {
        super.stopStack();
        this.eventScanner.stop();
        SipStack sipStack = this;
        sipStack.sipStackConnector.releaseInstance();
    }

    public SipStack(ConfigurationProperties configurationProperties, SecurityToken classSecurityToken) throws PeerUnavailableException {
        this();
        String transactionTableSize;
        String threadPoolSize;
        String extensionMethods;
        this.eventScanner = new EventScanner(this);
        this.eventScanner.start();
        String address = configurationProperties.getProperty("javax.sip.IP_ADDRESS");
        if (address == null) {
            throw new PeerUnavailableException("address not specified");
        }
        super.setHostAddress(address);
        String name = configurationProperties.getProperty("javax.sip.STACK_NAME");
        if (name == null) {
            throw new PeerUnavailableException("stack name is missing");
        }
        super.setStackName(name);
        this.routerPath = "gov.nist.siplite.stack.DefaultRouter";
        this.outboundProxy = configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY");
        ReflectiveOperationException ex = null;
        try {
            Class<?> routerClass = Class.forName(this.routerPath);
            Router router = (Router)routerClass.newInstance();
            if (this.outboundProxy != null) {
                router.setOutboundProxy(this.outboundProxy);
            }
            router.setSipStack(this);
            super.setRouter(router);
        }
        catch (ClassNotFoundException cnfe) {
            ex = cnfe;
        }
        catch (InstantiationException ie) {
            ex = ie;
        }
        catch (IllegalAccessException iae) {
            ex = iae;
        }
        if (ex != null) {
            throw new PeerUnavailableException("Could not instantiate router");
        }
        if (this.outboundProxy != null) {
            Hop hop = new Hop(this.outboundProxy);
            this.outboundProxy = hop.getHost();
            this.outboundPort = hop.getPort();
        }
        if ((extensionMethods = configurationProperties.getProperty("javax.sip.EXTENSION_METHODS")) != null) {
            StringTokenizer st = new StringTokenizer(extensionMethods, ':');
            while (st.hasMoreChars()) {
                String em = st.nextToken();
                if (em.toUpperCase().equals("BYE") || em.toUpperCase().equals("ACK") || em.toUpperCase().equals("OPTIONS")) {
                    throw new PeerUnavailableException("Bad extension method " + em);
                }
                this.addExtensionMethod(em.toUpperCase());
            }
        }
        this.retransmissionFilter = true;
        String maxConnections = configurationProperties.getProperty("gov.nist.javax.sip.MAX_CONNECTIONS");
        if (maxConnections != null) {
            try {
                this.maxConnections = Integer.parseInt(maxConnections);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((threadPoolSize = configurationProperties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE")) != null) {
            try {
                this.threadPoolSize = Integer.parseInt(threadPoolSize);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((transactionTableSize = configurationProperties.getProperty("gov.nist.javax.sip.MAX_SERVER_TRANSACTIONS")) != null) {
            try {
                this.transactionTableSize = Integer.parseInt(transactionTableSize);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.setSecurityToken(classSecurityToken);
    }

    public SipListener getSipListener() {
        return this.sipListener;
    }

    public synchronized ListeningPoint createListeningPoint(int port, String transport) throws TransportNotSupportedException, IllegalArgumentException {
        if (transport == null) {
            throw new NullPointerException("null transport");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("bad port");
        }
        if (!Utils.equalsIgnoreCase(transport, "UDP") && !Utils.equalsIgnoreCase(transport, "TCP")) {
            throw new TransportNotSupportedException("bad transport " + transport);
        }
        String key = ListeningPoint.makeKey(this.stackAddress, port, transport);
        ListeningPoint lip = (ListeningPoint)this.listeningPoints.get(key);
        if (lip != null) {
            return lip;
        }
        try {
            MessageProcessor messageProcessor = this.createMessageProcessor(port, transport);
            lip = new ListeningPoint(this, this.getIPAddress(), port, transport);
            lip.messageProcessor = messageProcessor;
            messageProcessor.setListeningPoint(lip);
            this.listeningPoints.put(key, lip);
            return lip;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        if (listeningPoint.sipProviderImpl != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        SipProvider provider = new SipProvider(this);
        provider.setListeningPoint(listeningPoint);
        this.sipProviders.addElement(provider);
        return provider;
    }

    public void deleteListeningPoint(ListeningPoint listeningPoint) throws ObjectInUseException {
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint arg");
        }
        ListeningPoint lip = listeningPoint;
        lip.messageProcessor.stop();
        String key = lip.getKey();
        this.listeningPoints.remove(key);
    }

    public void deleteSipProvider(SipProvider sipProvider) throws ObjectInUseException {
        if (sipProvider == null) {
            throw new NullPointerException("null provider arg");
        }
        SipProvider sipProviderImpl = sipProvider;
        if (sipProviderImpl.listeningPoint.messageProcessor.inUse()) {
            throw new ObjectInUseException("Provider in use");
        }
        sipProviderImpl.sipListener = null;
        this.sipProviders.removeElement(sipProvider);
    }

    public String getIPAddress() {
        return super.getHostAddress();
    }

    public Enumeration getListeningPoints() {
        return this.listeningPoints.elements();
    }

    public ListeningPoint getListeningPoint(int port, String transport) {
        String key = ListeningPoint.makeKey(this.stackAddress, port, transport);
        return (ListeningPoint)this.listeningPoints.get(key);
    }

    public String getOutboundProxy() {
        return this.outboundProxy;
    }

    public boolean isRetransmissionFilterActive() {
        return this.retransmissionFilter;
    }

    public Router getRouter() {
        return super.getRouter();
    }

    public Enumeration getSipProviders() {
        return this.sipProviders.elements();
    }

    public String getStackName() {
        return this.stackName;
    }

    protected String getDefaultTransport() {
        if (this.isTransportEnabled("udp")) {
            return "udp";
        }
        if (this.isTransportEnabled("tcp")) {
            return "tcp";
        }
        return null;
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        Transaction transaction = transactionErrorEvent.getSource();
    }
}

