/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.core.GenericObject;
import gov.nist.core.HostPort;
import gov.nist.core.ParseException;
import gov.nist.microedition.sip.StackConnector;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.TelURL;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.parser.Lexer;
import java.util.Vector;

public class Address
extends GenericObject {
    public static final int NAME_ADDR = 1;
    public static final int ADDRESS_SPEC = 2;
    public static final int WILD_CARD = 3;
    protected int addressType = 1;
    protected String displayName;
    protected URI address;

    public HostPort getHostPort() {
        if (this.addressType == 3) {
            return null;
        }
        if (this.address.isSipURI()) {
            return ((SipURI)this.address).getHostPort();
        }
        return null;
    }

    public int getPort() {
        if (this.addressType == 3) {
            return 0;
        }
        if (this.address.isSipURI()) {
            SipURI uri = (SipURI)this.address;
            int port = uri.getPort();
            if (port < 0) {
                port = uri.getDefaultPort();
            }
            return port;
        }
        return 5060;
    }

    public String getUserAtHostPort() {
        if (this.addressType == 3) {
            return null;
        }
        if (this.address.isSipURI()) {
            SipURI uri = (SipURI)this.address;
            return uri.getUserAtHostPort();
        }
        return this.address.toString();
    }

    public String getHost() {
        if (this.addressType == 3) {
            return null;
        }
        if (this.address.isSipURI()) {
            return ((SipURI)this.address).getHostPort().getHost().getHostname();
        }
        return null;
    }

    public void setHost(String host) throws IllegalArgumentException {
        if (this.address.isSipURI()) {
            ((SipURI)this.address).setHost(host);
        } else {
            ((TelURL)this.address).setPostDial(host);
        }
    }

    public void removeParameter(String parameterName) {
        if (this.addressType == 3) {
            return;
        }
        if (this.address.isSipURI()) {
            ((SipURI)this.address).removeParameter(parameterName);
        }
    }

    public String encode() {
        if (this.addressType == 3) {
            return "*";
        }
        StringBuffer encoding = new StringBuffer();
        if (this.displayName != null) {
            encoding.append(this.displayName).append(" ");
        }
        if (this.address != null) {
            if (this.addressType == 1 || this.displayName != null) {
                encoding.append("<");
            }
            encoding.append(this.address.encode());
            if (this.addressType == 1 || this.displayName != null) {
                encoding.append(">");
            }
        }
        return encoding.toString();
    }

    public String toString() {
        return this.encode();
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int atype) {
        this.addressType = atype;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String dn) throws IllegalArgumentException {
        if (null == dn) {
            throw new IllegalArgumentException("Null pointer argument");
        }
        if (dn.equals("")) {
            this.displayName = null;
        } else {
            if (!Lexer.isValidDisplayName(dn)) {
                throw new IllegalArgumentException("Invalid display name " + dn);
            }
            this.displayName = dn;
            this.addressType = 1;
        }
    }

    public void setURI(URI addr) {
        this.address = addr;
    }

    public void setURI(String URI2) {
        URI uri = null;
        try {
            uri = StackConnector.addressFactory.createURI(URI2);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe.getMessage());
        }
        if (uri == null) {
            throw new IllegalArgumentException("The URI is invalid");
        }
        if (uri.isSipURI()) {
            ((SipURI)uri).clearUriParms();
            if (this.address.isSipURI()) {
                SipURI addr = (SipURI)this.address;
                Vector names = addr.getParameterNames();
                for (int i = 0; i < names.size(); ++i) {
                    String name = (String)names.elementAt(i);
                    String value = addr.getParameter(name);
                    try {
                        ((SipURI)uri).setParameter(name, value);
                        continue;
                    }
                    catch (ParseException ex) {
                        // empty catch block
                    }
                }
            }
        }
        this.setURI(uri);
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Address that = (Address)other;
        if (this.addressType == 3 && that.addressType != 3) {
            return false;
        }
        boolean retval = this.address.equals(that.address);
        return retval;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public void removeDisplayName() {
        this.displayName = null;
    }

    public boolean isSIPAddress() {
        return this.address.isSipURI();
    }

    public URI getURI() {
        return this.address;
    }

    public String getPlainURI() {
        if (this.addressType == 3) {
            return null;
        }
        return this.address.getPlainURI();
    }

    public boolean isWildcard() {
        return this.addressType == 3;
    }

    public void setUser(String user) throws IllegalArgumentException {
        if (this.addressType == 3) {
            return;
        }
        if (this.address.isSipURI()) {
            int colonPos;
            SipURI uri = (SipURI)this.address;
            if (null != user && (colonPos = user.indexOf(":")) != -1) {
                uri.setUser(user.substring(0, colonPos));
                uri.setUserPassword(user.substring(colonPos + 1));
            } else {
                uri.setUser(user);
                uri.clearPassword();
            }
        } else if (this.address.isTelURL()) {
            ((TelURL)this.address).setPhoneNumber(user);
        } else {
            throw new IllegalArgumentException("Can't set a user for this type of address");
        }
    }

    public String getUser() {
        if (this.addressType == 3) {
            return null;
        }
        if (this.address.isSipURI()) {
            SipURI uri = (SipURI)this.address;
            String psswd = uri.getUserPassword();
            if (null != psswd) {
                return new String(uri.getUser() + ":" + psswd);
            }
            return uri.getUser();
        }
        if (this.address.isTelURL()) {
            return ((TelURL)this.address).getPhoneNumber();
        }
        return null;
    }

    public String[] getParameterNames() {
        Vector parameterNameList;
        if (this.addressType == 3) {
            return null;
        }
        if (this.address.isSipURI()) {
            parameterNameList = ((SipURI)this.address).getParameterNames();
        } else if (this.address.isTelURL()) {
            parameterNameList = ((TelURL)this.address).getParameterNames();
        } else {
            return null;
        }
        if (null == parameterNameList || parameterNameList.size() == 0) {
            return null;
        }
        String[] parameterNames = new String[parameterNameList.size()];
        for (int i = 0; i < parameterNameList.size(); ++i) {
            parameterNames[i] = (String)parameterNameList.elementAt(i);
        }
        return parameterNames;
    }

    public String getScheme() {
        if (this.addressType == 3) {
            return null;
        }
        return this.address.getScheme();
    }

    public void setParameter(String name, String value) throws IllegalArgumentException {
        if (!Lexer.isValidName(name)) {
            throw new IllegalArgumentException("Invalid parameter's name.");
        }
        if (!Lexer.isValidParameterValue(value)) {
            throw new IllegalArgumentException("Invalid parameter's value.");
        }
        URI uri = this.getURI();
        if (uri.isSipURI()) {
            try {
                ((SipURI)uri).setParameter(name, value);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(pe.getMessage());
            }
        }
    }

    public String getParameter(String name) {
        URI uri = this.getURI();
        if (uri.isSipURI()) {
            return ((SipURI)uri).getParameter(name);
        }
        return null;
    }

    public Object clone() {
        Address retval = new Address();
        retval.addressType = this.addressType;
        if (this.displayName != null) {
            retval.displayName = new String(this.displayName);
        }
        if (this.address != null) {
            retval.address = (URI)this.address.clone();
        }
        return retval;
    }
}

