/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.core.ParseException;
import gov.nist.core.Token;
import gov.nist.core.Utils;
import gov.nist.siplite.address.Address;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.TelURL;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.parser.Lexer;
import gov.nist.siplite.parser.StringMsgParser;
import gov.nist.siplite.parser.URLParser;

public class AddressFactory {
    public Address createAddress(String displayName, URI uri) {
        if (uri == null) {
            throw new NullPointerException("null URI");
        }
        Address addressImpl = new Address();
        if (displayName != null) {
            addressImpl.setDisplayName(displayName);
        }
        addressImpl.setURI(uri);
        return addressImpl;
    }

    public SipURI createSipURI(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null URI");
        }
        try {
            StringMsgParser smp = new StringMsgParser();
            SipURI sipUri = smp.parseSIPUrl(uri);
            return sipUri;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public SipURI createSipURI(String user, String host) throws ParseException {
        if (host == null) {
            throw new NullPointerException("null host");
        }
        StringBuffer uriString = new StringBuffer("sip:");
        if (user != null) {
            uriString.append(user);
            uriString.append("@");
        }
        if (host.indexOf(58) != host.lastIndexOf(58) && host.trim().charAt(0) != '[') {
            host = '[' + host + ']';
        }
        uriString.append(host);
        StringMsgParser smp = new StringMsgParser();
        try {
            SipURI sipUri = smp.parseSIPUrl(uriString.toString());
            return sipUri;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public TelURL createTelURL(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null url");
        }
        String telUrl = "tel:" + uri;
        try {
            StringMsgParser smp = new StringMsgParser();
            TelURL timp = (TelURL)smp.parseUrl(telUrl);
            return timp;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public Address createAddress(URI uri) {
        if (uri == null) {
            throw new NullPointerException("null address");
        }
        Address addressImpl = new Address();
        addressImpl.setURI(uri);
        return addressImpl;
    }

    public Address createAddress(String address) throws ParseException {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        if (address.equals("*")) {
            Address addressImpl = new Address();
            addressImpl.setAddressType(3);
            return addressImpl;
        }
        StringMsgParser smp = new StringMsgParser();
        return smp.parseAddress(address);
    }

    public URI createURI(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null arg");
        }
        try {
            Lexer lexer = new Lexer("sip_urlLexer", uri);
            Token token = lexer.peekNextToken();
            if (token.getTokenType() == 60) {
                lexer.consume();
                token = lexer.peekNextToken();
                uri = uri.substring(uri.indexOf(60) + 1, uri.lastIndexOf(62));
            }
            URLParser urlParser = new URLParser(uri);
            String scheme = token.getTokenValue();
            if (scheme == null || !Lexer.isValidScheme(scheme)) {
                throw new ParseException("bad scheme", 0);
            }
            if (Utils.equalsIgnoreCase(scheme, "SIP")) {
                return urlParser.sipURL(token);
            }
            if (Utils.equalsIgnoreCase(scheme, "SIPS")) {
                return urlParser.sipURL(token);
            }
            if (Utils.equalsIgnoreCase(scheme, "TEL")) {
                return urlParser.telURL();
            }
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
        return new URI(uri);
    }
}

