/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.core.GenericObject;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.siplite.address.UserInfo;

public class Authority
extends GenericObject {
    protected HostPort hostPort;
    protected UserInfo userInfo;

    public String encode() {
        String user;
        StringBuffer retval = new StringBuffer();
        if (this.userInfo != null && (user = this.userInfo.encode()) != null) {
            retval.append(user).append("@");
        }
        if (this.hostPort != null) {
            retval.append(this.hostPort.encode());
        }
        return retval.toString();
    }

    public boolean equals(Object other) {
        if (!other.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        Authority otherAuth = (Authority)other;
        if (!this.hostPort.equals(otherAuth.hostPort)) {
            return false;
        }
        return this.userInfo == null || otherAuth.userInfo == null || this.userInfo.equals(otherAuth.userInfo);
    }

    public HostPort getHostPort() {
        return this.hostPort;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public String getPassword() {
        if (this.userInfo == null) {
            return null;
        }
        return this.userInfo.getPassword();
    }

    public String getUser() {
        return this.userInfo != null ? this.userInfo.getUser() : null;
    }

    public Host getHost() {
        if (this.hostPort == null) {
            return null;
        }
        return this.hostPort.getHost();
    }

    public int getPort() {
        if (this.hostPort == null) {
            return -1;
        }
        return this.hostPort.getPort();
    }

    public void removePort() {
        if (this.hostPort != null) {
            this.hostPort.removePort();
        }
    }

    public void setPassword(String passwd) throws IllegalArgumentException {
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        this.userInfo.setPassword(passwd);
    }

    public void setUser(String user) throws IllegalArgumentException {
        if (this.userInfo == null) {
            this.userInfo = new UserInfo();
        }
        this.userInfo.setUser(user);
    }

    public void setHost(Host host) {
        if (this.hostPort == null) {
            this.hostPort = new HostPort();
        }
        this.hostPort.setHost(host);
    }

    public void setPort(int port) {
        if (this.hostPort == null) {
            this.hostPort = new HostPort();
        }
        this.hostPort.setPort(port);
    }

    public void setHostPort(HostPort h) {
        this.hostPort = h;
    }

    public void setUserInfo(UserInfo u) {
        this.userInfo = u;
    }

    public void removeUserInfo() {
        this.userInfo = null;
    }

    public Object clone() {
        Authority retval = new Authority();
        try {
            retval.setUser(this.getUser());
            retval.setPassword(this.getPassword());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        retval.setHostPort(this.getHostPort());
        return retval;
    }
}

