/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.core.ParseException;
import gov.nist.core.StringTokenizer;
import gov.nist.core.Utils;

public class Hop {
    protected String host;
    protected int port;
    protected String transport;
    protected boolean explicitRoute;
    protected boolean defaultRoute;
    protected boolean uriRoute;

    public String toString() {
        return this.host + ":" + this.port + "/" + this.transport;
    }

    public boolean equals(Object other) {
        if (other.getClass().equals(this.getClass())) {
            Hop otherhop = (Hop)other;
            return otherhop.host.equals(this.host) && otherhop.port == this.port;
        }
        return false;
    }

    public Hop(String hostName, int portNumber, String trans) throws IllegalArgumentException {
        if (portNumber < 0) {
            throw new IllegalArgumentException("Invalid port: " + portNumber);
        }
        this.host = hostName;
        this.port = portNumber;
        this.transport = trans == null ? "UDP" : (trans == "" ? "UDP" : trans);
    }

    public Hop(String hop) throws IllegalArgumentException {
        if (hop == null) {
            throw new IllegalArgumentException("Null arg!");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(hop + "/");
            String hostPort = stringTokenizer.getNextToken('/');
            stringTokenizer.getNextChar();
            this.transport = stringTokenizer.getNextToken('/').trim();
            if (this.transport == null) {
                this.transport = "UDP";
            } else if (this.transport == "") {
                this.transport = "UDP";
            }
            if (Utils.compareToIgnoreCase(this.transport, "UDP") != 0 && Utils.compareToIgnoreCase(this.transport, "TCP") != 0) {
                System.out.println("Bad transport string " + this.transport);
                throw new IllegalArgumentException(hop);
            }
            stringTokenizer = new StringTokenizer(hostPort + ":");
            this.host = stringTokenizer.getNextToken(':');
            if (this.host == null || this.host.equals("")) {
                throw new IllegalArgumentException("no host!");
            }
            stringTokenizer.consume(1);
            String portString = null;
            portString = stringTokenizer.getNextToken(':');
            if (portString == null || portString.equals("")) {
                throw new IllegalArgumentException("no port!");
            }
            try {
                this.port = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Bad port spec");
            }
            this.defaultRoute = true;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad hop");
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isExplicitRoute() {
        return this.explicitRoute;
    }

    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public boolean isURIRoute() {
        return this.uriRoute;
    }

    public void setURIRouteFlag() {
        this.uriRoute = true;
    }

    public void setDefaultRouteFlag() {
        this.defaultRoute = true;
    }

    public void setExplicitRouteFlag() {
        this.explicitRoute = true;
    }
}

