/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.core.GenericObject;
import gov.nist.core.Host;
import gov.nist.core.HostNameParser;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.core.ParseException;
import gov.nist.siplite.address.Authority;
import gov.nist.siplite.address.TelephoneNumber;
import gov.nist.siplite.address.URI;
import gov.nist.siplite.address.UserInfo;
import gov.nist.siplite.parser.Lexer;
import java.util.Enumeration;
import java.util.Vector;

public class SipURI
extends URI {
    protected Authority authority = null;
    protected NameValueList uriParms = null;
    protected NameValueList qheaders = null;
    protected TelephoneNumber telephoneSubscriber = null;
    private boolean isServer = false;
    private boolean isShared = false;

    public SipURI() {
        this.scheme = "SIP";
        this.uriParms = new NameValueList("uriparms");
        this.qheaders = new NameValueList("qheaders");
        this.qheaders.setSeparator("&");
    }

    public void setServer() {
        this.isServer = true;
    }

    public void setShared() {
        this.isShared = true;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public boolean isShared() {
        return this.isShared;
    }

    public void setScheme(String scheme) throws IllegalArgumentException {
        if (SipURI.compareToIgnoreCase(scheme, "SIP") != 0 && SipURI.compareToIgnoreCase(scheme, "SIPS") != 0) {
            throw new IllegalArgumentException("bad scheme " + scheme);
        }
        this.scheme = scheme.toLowerCase();
    }

    public void clearUriParms() {
        this.uriParms = new NameValueList("uriparms");
    }

    public void clearPassword() {
        UserInfo userInfo;
        if (this.authority != null && (userInfo = this.authority.getUserInfo()) != null) {
            userInfo.clearPassword();
        }
    }

    public Authority getAuthority() {
        return this.authority;
    }

    public void clearQheaders() {
        this.qheaders = new NameValueList("qheaders");
    }

    public boolean equals(Object that) {
        String hisTransport;
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        SipURI other = (SipURI)that;
        if (!this.authority.equals(other.authority)) {
            return false;
        }
        NameValueList hisParms = other.uriParms;
        String currTransport = this.uriParms.getValueDefault("transport", "UDP");
        if (!currTransport.equals(hisTransport = hisParms.getValueDefault("transport", "UDP"))) {
            return false;
        }
        Enumeration enumNames = this.uriParms.getKeys();
        while (enumNames.hasMoreElements()) {
            String currKey = (String)enumNames.nextElement();
            if (currKey.equals("transport")) continue;
            if (!hisParms.hasNameValue(currKey)) {
                return false;
            }
            if (this.uriParms.getValue(currKey).equals(hisParms.getValue(currKey))) continue;
            return false;
        }
        return true;
    }

    public String encode() {
        StringBuffer retval = new StringBuffer(this.scheme).append(":");
        if (this.authority != null) {
            retval.append(this.authority.encode());
        }
        if (!this.uriParms.isEmpty()) {
            retval.append(";").append(this.uriParms.encode());
        }
        if (!this.qheaders.isEmpty()) {
            retval.append("?").append(this.qheaders.encode());
        }
        return retval.toString();
    }

    public String toString() {
        return this.encode();
    }

    public String getUserAtHost() {
        if (this.authority == null) {
            return null;
        }
        String user = this.authority.getUserInfo().getUser();
        String host = this.authority.getHost().encode();
        return user + "@" + host;
    }

    public String getPlainURI() {
        StringBuffer retval = new StringBuffer(this.scheme).append(":");
        retval.append(this.getUserAtHostPort());
        return retval.toString();
    }

    public String getUserAtHostPort() {
        return this.authority.encode();
    }

    public Object getParm(String parmname) {
        Object obj = this.uriParms.getValue(parmname);
        return obj;
    }

    public String getMethod() {
        return (String)this.getParm("method");
    }

    public NameValueList getUriParms() {
        return this.uriParms;
    }

    public void removeUriParms() {
        this.uriParms = new NameValueList();
    }

    public NameValueList getQheaders() {
        return this.qheaders;
    }

    public String getUserType() {
        return (String)this.uriParms.getValue("user");
    }

    public String getUserPassword() {
        if (this.authority == null) {
            return null;
        }
        return this.authority.getPassword();
    }

    public void setUserPassword(String password) throws IllegalArgumentException {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPassword(password);
    }

    public TelephoneNumber getTelephoneSubscriber() {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        return this.telephoneSubscriber;
    }

    public HostPort getHostPort() {
        if (this.authority == null) {
            return null;
        }
        return this.authority.getHostPort();
    }

    public int getPort() {
        HostPort hp = this.getHostPort();
        if (hp == null) {
            return -1;
        }
        return hp.getPort();
    }

    public int getDefaultPort() {
        return this.scheme.equalsIgnoreCase("SIP") ? 5060 : 5061;
    }

    public String getHost() {
        Host h = this.authority.getHost();
        return h == null ? "" : h.encode();
    }

    public boolean isUserTelephoneSubscriber() {
        String usrtype = (String)this.uriParms.getValue("user");
        if (usrtype == null) {
            return false;
        }
        return usrtype.equals("phone");
    }

    public void removeTTL() {
        if (this.uriParms != null) {
            this.uriParms.delete("ttl");
        }
    }

    public void removeMAddr() {
        if (this.uriParms != null) {
            this.uriParms.delete("maddr");
        }
    }

    public void removeTransport() {
        if (this.uriParms != null) {
            this.uriParms.delete("transport");
        }
    }

    public void removeHeader(String name) {
        if (this.qheaders != null) {
            this.qheaders.delete(name);
        }
    }

    public void removeHeaders() {
        this.qheaders = new NameValueList("qheaders");
    }

    public void removeUserType() {
        if (this.uriParms != null) {
            this.uriParms.delete("user");
        }
    }

    public void removePort() {
        this.authority.removePort();
    }

    public void removeMethod() {
        if (this.uriParms != null) {
            this.uriParms.delete("method");
        }
    }

    public void setUser(String uname) throws IllegalArgumentException {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setUser(uname);
    }

    public void removeUser() {
        this.authority.removeUserInfo();
    }

    public void setDefaultParm(String name, Object value) {
        if (this.uriParms.getValue(name) == null) {
            NameValue nv = new NameValue(name, value);
            this.uriParms.add(nv);
        }
    }

    public void setAuthority(Authority newAuthority) {
        this.authority = newAuthority;
    }

    public void setHost(Host h) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHost(h);
    }

    public void setQheaders(NameValueList parms) {
        this.qheaders = parms;
    }

    public void setMAddr(String mAddr) {
        NameValue nameValue = this.uriParms.getNameValue("maddr");
        Host host = new Host();
        host.setAddress(mAddr);
        if (nameValue != null) {
            nameValue.setValue(host);
        } else {
            nameValue = new NameValue("maddr", host);
            this.uriParms.add(nameValue);
        }
    }

    public void setUserParam(String usertype) {
        this.uriParms.delete("user");
        this.uriParms.add("user", usertype);
    }

    public void setMethod(String method) {
        this.uriParms.add("method", method);
    }

    public void setIsdnSubAddress(String isdnSubAddress) {
        if (this.telephoneSubscriber == null) {
            this.telephoneSubscriber = new TelephoneNumber();
        }
        this.telephoneSubscriber.setIsdnSubaddress(isdnSubAddress);
    }

    public void setTelephoneSubscriber(TelephoneNumber tel) {
        this.telephoneSubscriber = tel;
    }

    public void setPort(int p) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setPort(p);
    }

    public boolean hasParameter(String name) {
        return this.uriParms.getValue(name) != null;
    }

    public void setQHeader(NameValue nameValue) {
        this.qheaders.set(nameValue);
    }

    public void setUriParameter(NameValue nameValue) {
        this.uriParms.set(nameValue);
    }

    public boolean hasTransport() {
        return this.hasParameter("transport");
    }

    public void removeParameter(String name) {
        this.uriParms.delete(name);
    }

    public void setHostPort(HostPort hostPort) {
        if (this.authority == null) {
            this.authority = new Authority();
        }
        this.authority.setHostPort(hostPort);
    }

    public Object clone() {
        SipURI retval = new SipURI();
        retval.scheme = new String(this.scheme);
        retval.authority = (Authority)this.authority.clone();
        retval.uriParms = (NameValueList)this.uriParms.clone();
        if (this.qheaders != null) {
            retval.qheaders = (NameValueList)this.qheaders.clone();
        }
        if (this.telephoneSubscriber != null) {
            retval.telephoneSubscriber = (TelephoneNumber)this.telephoneSubscriber.clone();
        }
        return retval;
    }

    public String getHeader(String name) {
        return this.qheaders.getValue(name) != null ? this.qheaders.getValue(name).toString() : null;
    }

    public Vector getHeaderNames() {
        return this.qheaders.getNames();
    }

    public String getLrParam() {
        boolean haslr = this.hasParameter("lr");
        return haslr ? "true" : null;
    }

    public String getMAddrParam() {
        NameValue maddr = this.uriParms.getNameValue("maddr");
        if (maddr == null) {
            return null;
        }
        String host = (String)maddr.getValue();
        return host;
    }

    public String getMethodParam() {
        return this.getParameter("method");
    }

    public String getParameter(String name) {
        Object val = this.uriParms.getValue(name.toLowerCase());
        if (val == null) {
            return null;
        }
        if (val instanceof GenericObject) {
            return ((GenericObject)val).encode();
        }
        return val.toString();
    }

    public Vector getParameterNames() {
        return this.uriParms.getNames();
    }

    public int getTTLParam() {
        Integer ttl = (Integer)this.uriParms.getValue("ttl");
        if (ttl != null) {
            return ttl;
        }
        return -1;
    }

    public String getTransportParam() {
        if (this.uriParms != null) {
            return (String)this.uriParms.getValue("transport");
        }
        return null;
    }

    public String getTypeParam() {
        if (this.uriParms != null) {
            NameValue nv = this.uriParms.getNameValue("type");
            if (nv == null) {
                return null;
            }
            return (String)nv.getUnquotedValue();
        }
        return null;
    }

    public String getUser() {
        return this.authority.getUser();
    }

    public boolean isSecure() {
        return SipURI.equalsIgnoreCase(this.getScheme(), "SIPS");
    }

    public boolean isSipURI() {
        return true;
    }

    public boolean isTelURL() {
        return false;
    }

    public void setHeader(String name, String value) {
        if (this.qheaders.getValue(name) == null) {
            NameValue nv = new NameValue(name, value);
            this.qheaders.add(nv);
        } else {
            NameValue nv = this.qheaders.getNameValue(name);
            nv.setValue(value);
        }
    }

    public void setHost(String host) throws IllegalArgumentException {
        Lexer lexer = new Lexer("sip_urlLexer", host);
        HostNameParser hnp = new HostNameParser(lexer);
        try {
            Host h = new Host(hnp.hostName());
            if (GenericObject.compareToIgnoreCase(h.getHostname(), host) == 0) {
                this.setHost(h);
                return;
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        throw new IllegalArgumentException("Illegal host name");
    }

    public void setLrParam() {
        if (this.uriParms.getValue("lr") != null) {
            return;
        }
        NameValue nv = new NameValue("lr", null);
        this.uriParms.add(nv);
    }

    public void setMAddrParam(String maddr) throws ParseException {
        if (maddr == null) {
            throw new NullPointerException("bad maddr");
        }
        this.setParameter("maddr", maddr);
    }

    public void setMethodParam(String method) throws ParseException {
        this.setParameter("method", method);
    }

    public void setParameter(String name, String value) throws ParseException {
        if (name.equalsIgnoreCase("ttl")) {
            try {
                int ttl = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("bad parameter " + value, 0);
            }
        }
        name = name.toLowerCase();
        NameValue nv = new NameValue(name, value == null ? "" : value);
        this.uriParms.delete(name);
        this.uriParms.add(nv);
    }

    public void setSecure(boolean secure) {
        this.scheme = secure ? "SIPS" : "SIP";
    }

    public void setTTLParam(int ttl) throws IllegalArgumentException {
        if (ttl <= 0) {
            throw new IllegalArgumentException("Bad ttl value");
        }
        if (this.uriParms != null) {
            this.uriParms.delete("ttl");
            NameValue nv = new NameValue("ttl", new Integer(ttl));
            this.uriParms.add(nv);
        }
    }

    public void setTransportParam(String transport) throws ParseException {
        if (transport == null) {
            throw new NullPointerException("null arg");
        }
        if (!SipURI.equalsIgnoreCase(transport, "UDP") && !SipURI.equalsIgnoreCase(transport, "TCP")) {
            throw new ParseException("bad transport " + transport, 0);
        }
        NameValue nv = new NameValue("transport", transport.toLowerCase());
        this.uriParms.delete("transport");
        this.uriParms.add(nv);
    }

    public String getUserParam() {
        return this.getParameter("user");
    }

    public boolean hasLrParam() {
        return this.uriParms.getNameValue("lr") != null;
    }
}

