/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.core.GenericObject;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;

public class TelephoneNumber
extends GenericObject {
    public static final String POSTDIAL = "postdial";
    public static final String PHONE_CONTEXT_TAG = "context-tag";
    public static final String ISUB = "isub";
    public static final String PROVIDER_TAG = "provider-tag";
    protected boolean isglobal;
    protected String phoneNumber;
    protected NameValueList parms = new NameValueList("telparms");

    public void deleteParm(String name) {
        this.parms.delete(name);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getPostDial() {
        return (String)this.parms.getValue(POSTDIAL);
    }

    public String getIsdnSubaddress() {
        return (String)this.parms.getValue(ISUB);
    }

    public boolean hasPostDial() {
        return this.parms.getValue(POSTDIAL) != null;
    }

    public boolean hasParm(String pname) {
        return this.parms.hasNameValue(pname);
    }

    public boolean hasIsdnSubaddress() {
        return this.hasParm(ISUB);
    }

    public boolean isGlobal() {
        return this.isglobal;
    }

    public void removePostDial() {
        this.parms.delete(POSTDIAL);
    }

    public void removeIsdnSubaddress() {
        this.deleteParm(ISUB);
    }

    public void setParameters(NameValueList p) {
        this.parms = p;
    }

    public void setGlobal(boolean g) {
        this.isglobal = g;
    }

    public void setPostDial(String p) {
        NameValue nv = new NameValue(POSTDIAL, p);
        this.parms.add(nv);
    }

    public void setParm(String name, Object value) {
        NameValue nv = new NameValue(name, value);
        this.parms.add(nv);
    }

    public void setIsdnSubaddress(String isub) {
        this.setParm(ISUB, isub);
    }

    public void setPhoneNumber(String num) {
        this.phoneNumber = num;
    }

    public String encode() {
        String retval = "";
        if (this.isglobal) {
            retval = retval + "+";
        }
        retval = retval + this.phoneNumber;
        if (!this.parms.isEmpty()) {
            retval = retval + ";";
            retval = retval + this.parms.encode();
        }
        return retval;
    }

    public Object clone() {
        TelephoneNumber retval = new TelephoneNumber();
        retval.isglobal = this.isglobal;
        retval.phoneNumber = new String(this.phoneNumber);
        retval.parms = (NameValueList)this.parms.clone();
        return retval;
    }
}

