/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.siplite.address;

import gov.nist.core.GenericObject;
import gov.nist.core.ParseException;
import gov.nist.core.StringTokenizer;
import gov.nist.siplite.address.SipURI;
import gov.nist.siplite.address.TelURL;

public class URI
extends GenericObject {
    public static final String POSTDIAL = "postdial";
    public static final String PHONE_CONTEXT_TAG = "context-tag";
    public static final String ISUB = "isub";
    public static final String PROVIDER_TAG = "provider-tag";
    public static final String USER = "user";
    public static final String TRANSPORT = "transport";
    public static final String METHOD = "method";
    public static final String TTL = "ttl";
    public static final String MADDR = "maddr";
    public static final String LR = "lr";
    protected String uriString;
    protected String scheme;

    protected URI() {
    }

    public URI(String uriString) throws ParseException {
        try {
            this.uriString = uriString;
            int colPos = uriString.indexOf(":");
            if (colPos == -1) {
                throw new ParseException("URI, no separator after scheme", 0);
            }
            String uriCutScheme = uriString.substring(colPos + 1);
            int symAtPos = uriCutScheme.indexOf("@");
            if (symAtPos == 0) {
                throw new ParseException("URI, no user part", 0);
            }
        }
        catch (Throwable e) {
            throw new ParseException("URI, Bad URI format", 0);
        }
    }

    public String encode() {
        return this.uriString;
    }

    public String toString() {
        return this.encode();
    }

    public String getPlainURI() {
        return this.encode();
    }

    public Object clone() {
        try {
            return new URI(this.uriString);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage() + this.uriString);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String sch) throws IllegalArgumentException {
        String errMsg = "Invalid scheme format";
        if (sch == null || !StringTokenizer.isAlpha(sch.charAt(0))) {
            throw new IllegalArgumentException("Invalid scheme format");
        }
        for (int i = 1; i < sch.length(); ++i) {
            char ch = sch.charAt(i);
            if (StringTokenizer.isAlpha(ch) || StringTokenizer.isDigit(ch) || ch == '+' || ch == '-' || ch == '.') continue;
            throw new IllegalArgumentException("Invalid scheme format");
        }
        this.scheme = sch;
    }

    public boolean isSipURI() {
        return this instanceof SipURI;
    }

    public boolean isTelURL() {
        return this instanceof TelURL;
    }
}

